/* ./src/crypt/arithmetic/std/mult.c */

static char *rcsid = "$Id: mult.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: mult.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: mult.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*	L_NUMBER multiplikation
 *
 */

#include	"arithmetic.h"
#include	"optimize.h"

#define	Max(a,b)	( a>b? a:b )
#define	Min(a,b)	( a>b? b:a )


char * mult_string1 = "mult:";
char * mult_string2 = "mult: * \nmult:";
char * mult_string3 = "mult: = \nmult:";

/***************************************************************
 *
 * Procedure _mult
 *
 ***************************************************************/
#ifdef __STDC__

void _mult(
	L_NUMBER	  A[],
	L_NUMBER	  B[],
	L_NUMBER	  erg[]
)

#else

void _mult(
	A,
	B,
	erg
)
L_NUMBER	  A[];
L_NUMBER	  B[];
L_NUMBER	  erg[];

#endif

{
	register int    i, j;
	L_NUMBER        Prod[2 * MAXGENL];
	register L_NUMBER *Ap, *Bp, *Cp = Prod, e1, e2, e3;
	register int    lenA = lngofln(A);
	register int    lenB = lngofln(B);
	register int    lenC = lenA + lenB;

#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
 					arithmetic_trace_counter--;
					fprintf(arithmetic_trace, mult_string1);
					arithmetic_trace_print(A); 
			 		fprintf(arithmetic_trace, mult_string2);
					arithmetic_trace_print(B);
				} 
#endif
	if (!(lenA && lenB)) {
		*erg = 0;
		return;
	}
	Cp++;

	e1 = 0;
	e2 = 0;
	e3 = 0;
	for (i = 1; i < lenC; i++, Cp++) {	/* run through result */
		j = Max(0, i - lenA);
		Bp = B + j;
		Ap = A + i - j;
		for (; (j < i) && (j < lenB); j++) {
			REGISTER L_NUMBER dlow;
			REGISTER L_NUMBER dhigh;

			/* multiply A[i-j] * B[j] */
			dmult(*Ap--, *++Bp, ADDR dhigh, ADDR dlow);
			e3 += dlow;
			if(e3 < dlow) dhigh ++;
			e2 += dhigh;
			if(e2 < dhigh) e1++;

			
		}
		*Cp = e3;
		e3 = e2;
		e2 = e1;
		e1 = 0;
	}
	*Cp = e3;
	if (!*Cp)
		Cp--;
	lngofln(Prod) = Cp - Prod;
	trans(Prod, erg);

#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
					fprintf(arithmetic_trace, mult_string3);
 					arithmetic_trace_print(erg);
				}
#endif
	return;
}
