/* ./src/crypt/arithmetic/std/div.c */

static char *rcsid = "$Header: /home/secude/new_release/secude/src/crypt/arithmetic/std/RCS/div.c,v 1.4 1994/11/10 16:38:21 schneiw Exp $";

/* 
 *
 * $Header: /home/secude/new_release/secude/src/crypt/arithmetic/std/RCS/div.c,v 1.4 1994/11/10 16:38:21 schneiw Exp $
 *
 * $Log: div.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/*
 *	division for LNUMBERs
 *
 */
#include	"arithmetic.h"


char *div_string1 = "div:";
char *div_string2 = "div: / \ndiv:";
char *div_string3 = "div: = \ndiv:";
char *div_string4 = "div: Re \ndiv:";

/***************************************************************
 *
 * Procedure _div
 *
 ***************************************************************/
#ifdef __STDC__

void _div(
	L_NUMBER	  A[],
	L_NUMBER	  B[],
	L_NUMBER	  Q[],
	L_NUMBER	  R[]
)

#else

void _div(
	A,
	B,
	Q,
	R
)
L_NUMBER	  A[];
L_NUMBER	  B[];
L_NUMBER	  Q[];
L_NUMBER	  R[];

#endif

{
	L_NUMBER        AA[MAXGENL];	/* A shifted */
	L_NUMBER        BB[MAXGENL];	/* B shifted */
	register unsigned int a1, a2, a3, q, qb, *Aptr;
	int    i, n, j;
	unsigned int lshift = 0, leftword, nextword, overflow, b1, b2, b3, b2t;

#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
 					arithmetic_trace_counter--;
					fprintf(arithmetic_trace, div_string1);
					arithmetic_trace_print(A); 
					fprintf(arithmetic_trace, div_string2);
					arithmetic_trace_print(B);
				} 
#endif

/* --------------------------------- */
/* --------------------------------- */
/* division by zero */
	if (!*B)
		ALU_exception(*B);	/* zero divide */

/* --------------------------------- */
/* --------------------------------- */
/* a is lower than b */
	if (*A < *B) {
		trans(A, R);
		if (Q != R)
			inttoln(0, Q);
#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
					fprintf(arithmetic_trace, div_string3);
 					arithmetic_trace_print(Q);
					fprintf(arithmetic_trace, div_string4);
 					arithmetic_trace_print(R);
				}
#endif
		return;
	}

/* --------------------------------- */
/* --------------------------------- */
/* b has only one word */
	if(*B == 1) {

/* save the input args */
		trans(A, AA);
		trans(B, BB);

/* get b */
		leftword = B[*BB];

		a1 = 0;
/* --------------------------------- */
		for(i = *AA; i > 0; i--) {
/* divide 2 words of A (a1,a2) by one (leftword) of B*/
			a2 = AA[i];

/* store leftword << (SIZEOFINT-1) in (b1,b2) */

			b2 = (leftword & 1) ? HSBIT : 0;
			b1 = leftword >> 1;
	
			q = 0;
			qb = HSBIT;
	
			for(n = SIZEOFINT-1; n > 0; n--) {

/* if (a1,a2) > (b1,b2) then (a1,a2) -= (b1,b2); q += qb; */

				if(b1 < a1 || (b1 == a1 && b2 <= a2)) {
					q |= qb;
					if(b2 > a2) a1--;
					a1 -= b1;
					a2 -= b2;
				}
/* (b1,b2) >>= 1 ; qb >>= 1; */
				qb >>= 1;
				b2 >>= 1;
				if(b1 & 1) b2 |= HSBIT;
				b1 >>= 1;
			}
/* if (a1,a2) > (b1,b2) then (a1,a2) -= (b1,b2); q += qb; */
			if(b1 < a1 || (b1 == a1 && b2 <= a2)) {
				q |= qb;
				a2 -= b2;
			}

/* the rest of the division becomes the next high word */
			a1 = a2;

/* store the 2 word division result in Q */
			Q[i] = q;
				


		}
/* --------------------------------- */
/* sore results */
		*Q = *AA;
		if(!Q[*Q]) Q[0] --;

		R[1] = a2;
		R[0] = 1;
		if(!a2) R[0]--;

#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
					fprintf(arithmetic_trace, div_string3);
 					arithmetic_trace_print(Q);
					fprintf(arithmetic_trace, div_string4);
 					arithmetic_trace_print(R);
				}
#endif
		return;

	}
/* --------------------------------- */
/* --------------------------------- */
/* b has 2 or more words */


/* --------------------------------- */
/* shift both args to left until highest bit of highest word of B is set */
	leftword = B[*B];

#if SIZEOFINT == 32
	if(leftword < 0x10000) lshift = 16;
	else leftword >>= 16;
#endif
	if(leftword < 0x100) lshift += 8;
	else leftword >>= 8;

	if(leftword < 0x10) lshift += 4;
	else leftword >>= 4;

	if(leftword < 0x4) lshift += 2;
	else leftword >>= 2;

	if(leftword < 0x2) lshift ++;


	_shift(A, lshift, AA);
	_shift(B, lshift, BB);

/* --------------------------------- */
	leftword = BB[*BB];
	nextword = BB[*BB-1];


/* A needs a preceeding 0 */
	AA[*AA+1] = 0;


	for(i = *AA; i >= *BB; i--) {


/* devide the 2 highest words of A (a1,a2) by highest word of B (leftword) */
		a2 = AA[i];
		a1 = AA[i+1];

/* store leftword << (SIZEOFINT-1) in (b1,b2) */
		b2 = (leftword & 1) ? HSBIT : 0;
		b1 = leftword >> 1;

		q = 0;
		qb = HSBIT;

		for(n = 31; n > 0; n--) {

/* if (a1,a2) > (b1,b2) then (a1,a2) -= (b1,b2); q += qb; */

			if(b1 < a1 || (b1 == a1 && b2 <= a2)) {
				q |= qb;
				if(b2 > a2) a1--;
				a1 -= b1;
				a2 -= b2;
			}
/* (b1,b2) >>= 1 ; qb >>= 1; */
			qb >>= 1;
			b2 >>= 1;
			if(b1 & 1) b2 |= HSBIT;
			b1 >>= 1;
		}

/* if (a1,a2) > (b1,b2) then (a1,a2) -= (b1,b2); q += qb; */

		if(b1 < a1 || (b1 == a1 && b2 <= a2)) {
			q |= qb;
			if(b2 > a2) a1--;
			a2 -= b2;
		}

		if(q) {
/*  we habe q*b1 <= (a1,a2) but q*(b1,b2) can be greater than (a1,a2,a3)*/
/* while q*(b1,b2) > (a1,a2,a3) q-- */

			a3 = AA[i-1];
			a2 = AA[i];
			a1 = AA[i+1];
			while (1) {
				dmult(leftword, q, &b1, &b2);
				dmult(nextword, q, &b2t, &b3);
				b2 += b2t;
				if(b2 < b2t) b1++;
				if(b1 < a1) break;
				if(b1 == a1 && b2 < a2) break;
				if(b2 == a2 && b3 <= a3) break;
				q--;
			}
	
/* --------------------------------- */
/* q*B is subtracted from highest part of A */

			overflow = 0;
			Aptr = AA + (i + 1 - *BB);
			for(n = 1; n <= *BB; n++) {
				dmult (BB[n], q, &b1, &b2);
				if(overflow) {
					b1++;
					if(*Aptr < b2) b1++;
					*Aptr -= b2;
					Aptr ++;
					if(b1) {
						if(*Aptr >= b1) overflow = 0;
						*Aptr -= b1;
					}
				}
				else {
					if(*Aptr < b2) b1++;
					*Aptr -= b2;
					Aptr ++;
					if(*Aptr < b1) overflow = 1;
					*Aptr -= b1;
				}
	
	
			}
/* if a is negative than q was 1 to big */

			if(overflow) {
/* decrement q an add B to A */
				q --; 
				overflow = 0;
				Aptr = AA + (i + 1 - *BB);
				for(n = 1; n <= *BB; n++) {
					if(overflow) {
		
						*Aptr += BB[n] + overflow;
						if(*Aptr > BB[n]) overflow = 0;
					}
					else {
		
						*Aptr += BB[n];
						if(*Aptr < BB[n]) overflow = 1;
					}
					Aptr ++;
				}
	
	
			}
			if(overflow) (*Aptr)++;
		}
/* store q */
		Q[i + 1 - *BB] = q;
	}

/* set length of Q */
	Q[0] = *AA + 1 - *BB;
	if(!Q[Q[0]]) Q[0]--;

/* normalize the rest (A) */
	AA[0] = BB[0];
	while(AA[0] && !AA[AA[0]]) AA[0]--;

/* reshift the rest (A) */
	shift(AA, -lshift, R);




#ifdef ARITHMETIC_TEST
				if(arithmetic_trace_counter) {
					fprintf(arithmetic_trace, div_string3);
 					arithmetic_trace_print(Q);
					fprintf(arithmetic_trace, div_string4);
 					arithmetic_trace_print(R);
				}
#endif
	return;
}
