/* ./src/aux/aux_ostr.c */

static char *rcsid = "$Id: aux_ostr.c,v 1.5 1995/03/10 07:51:39 surkau Exp $";

/* 
 *
 * $Id: aux_ostr.c,v 1.5 1995/03/10 07:51:39 surkau Exp $
 *
 * $Log: aux_ostr.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "secure.h"
#include "arithmetic.h"

#ifdef ICR1
#include "ul/psap.h"
#else
#include "psap.h"
#endif

#include <stdio.h>
#ifdef MAC
#include <stdlib.h>
#include <string.h>
#endif
#include <errno.h>

/************************************************************************/
/*                                                                      */
/*      aux_create_OctetString                                          */
/*                                                                      */
/*      erzeugt octetstring und initialisiert ihn mit text              */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_create_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_create_OctetString(
	char	 *text
)

#else

OctetString *aux_create_OctetString(
	text
)
char	 *text;

#endif

{
	unsigned int	   n;
	OctetString      * bst;
	char		 * proc = "aux_create_OctetString";

	if (!(bst = (OctetString * ) malloc( sizeof( OctetString ) ))) {
		aux_add_error(EMALLOC, "bst", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	bst->noctets = text ? strlen( text ) : 0;
	if ( bst->noctets ) {
		bst->octets = (char * ) calloc( 1 , bst->noctets );
		if ( !bst->octets ) {
			free( bst );
			aux_add_error(EMALLOC, "bst->octets", CNULL, 0, proc);
			return (NULLOCTETSTRING);
		}
	}
	for ( n = 0 ; n < bst->noctets ; n++) 
		bst->octets[n] = text[n];

	return( bst );
}

/************************************************************************/
/*                                                                      */
/*      aux_new_OctetString                                             */
/*                                                                      */
/*      erzeugt octetstring und initialisiert ihn mit zeros             */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_new_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_new_OctetString(
	int	  length
)

#else

OctetString *aux_new_OctetString(
	length
)
int	  length;

#endif

{
	unsigned int	   n;
	OctetString      * ostr;
	char		 * proc = "aux_new_OctetString";

	if (!(ostr = (OctetString * ) malloc( sizeof( OctetString ) ))) {
		aux_add_error(EMALLOC, "ostr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	ostr->noctets = length;
	if ( length > 0 ) {
		ostr->octets = (char * ) calloc( 1 , length );
		if ( !ostr->octets ) {
			free( ostr );
			aux_add_error(EMALLOC, "ostr->octets", CNULL, 0, proc);
			return (NULLOCTETSTRING);
		}
	}
	else ostr->octets = CNULL;

	return ( ostr );
}


/************************************************************************/
/*                                                                      */
/*      aux_append_OctetString                                          */
/*                                                                      */
/*      haengt octetstring append an octetstream to an                  */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_append_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_append_OctetString(
	OctetString	 *to,
	OctetString	 *append
)

#else

RC aux_append_OctetString(
	to,
	append
)
OctetString	 *to;
OctetString	 *append;

#endif

{
	char		* new_;
	unsigned int	  n;
	char		* proc = "aux_append_OctetString";

	if ( !to ) {
		aux_add_error(EINVALID, "to empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !append ) return( 0 );    /* nichts anhaengen */

	if (!(new_ = (char * )calloc( 1 , to->noctets + append->noctets ))) {
		aux_add_error(EMALLOC, "new_", CNULL, 0, proc);
		return(-1);
	}

	bcopy(to->octets, new_, to->noctets);
	bcopy(append->octets, &new_[to->noctets], append->noctets);

	if(to->octets) free(to->octets); /*alten speicherplatz freigeben */

	to->octets = new_;
	to->noctets += append->noctets;


	return(0);
}



/************************************************************************/
/*                                                                      */
/*      aux_concatenate_OctetString                                     */
/*                                                                      */
/*      haengt octetstring part2 an octetstream part1 an                */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_concatenate_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString * aux_concatenate_OctetString(
	OctetString	 *part1,
	OctetString	 *part2
)

#else

OctetString * aux_concatenate_OctetString(
	part1,
	part2
)
OctetString	 *part1;
OctetString	 *part2;

#endif

{
	OctetString     * res;
	RC		  rc;
	char		* proc = "aux_concatenate_OctetString";

	if (! part1) {
		aux_add_error(EINVALID, "part1 empty", CNULL, 0, proc);
		return(NULLOCTETSTRING);
	}

	res = aux_cpy_OctetString(part1);

	if (! part2) 
		return(res);    /* nichts anhaengen */

	rc = aux_append_OctetString(res, part2);
	if(rc < 0){
		AUX_ADD_ERROR;
		return(NULLOCTETSTRING);
	}

	return(res);
}


/***************************************************************
 *
 * Procedure aux_append_BitString
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_append_BitString(
	BitString	 *to,
	BitString	 *append
)

#else

RC aux_append_BitString(
	to,
	append
)
BitString	 *to;
BitString	 *append;

#endif

{
	char		* new_, high, low, sh;
	unsigned int	  n, m, h_mask, l_mask;
	char		* proc = "aux_append_BitString";

	if ( !to ) {
		aux_add_error(EINVALID, "to empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !append ) 
		return( 0 );    /* nichts anhaengen */

	if (!(new_ = (char * )calloc( 1 , (to->nbits + append->nbits + 7 ) / 8 ))) {
		aux_add_error(EMALLOC, "new_", CNULL, 0, proc);
		return(-1);
	}


	for ( n = 0 ; n < (to->nbits + 7) / 8 ; n++)
		new_[n] = to->bits[n]; /* to kopieren  */

	if (to->nbits%8) {
		n--;

		sh = to->nbits%8;
		h_mask = (0xff00 >> (sh)) & 0xff;
		l_mask = 0xff - h_mask;

		new_[n] &= h_mask; 


		for ( m = 0 ; m < (append->nbits + 7) / 8; m++) {
			high = (append->bits[m] >> sh) & l_mask;
			low = (append->bits[m] << sh) & h_mask;
			new_[m + n] |= high; 
			new_[m + n + 1] = low; 
		}
	}
	else {
		for ( m = 0 ; m < (append->nbits + 7) / 8 ; m++)
			new_[n + m] = append->bits[m]; /* to kopieren  */

	}
	if(to->bits) free(to->bits); /*alten speicherplatz freigeben */

	to->bits = new_;
	to->nbits += append->nbits;

	return(0);
}


/************************************************************************/
/*                                                                      */
/*      aux_append_char                                                 */
/*                                                                      */
/*      haengt char*  an octetstring an                                 */
/*                                                                      */
/*                                                                      */
/************************************************************************/

/***************************************************************
 *
 * Procedure aux_append_char
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_append_char(
	OctetString	 *to,
	char		 *append
)

#else

RC aux_append_char(
	to,
	append
)
OctetString	 *to;
char		 *append;

#endif

{
	char		* new_;
	unsigned int	  n, len;
	char		* proc = "aux_append_char";

	if ( !to ) {
		aux_add_error(EINVALID, "to empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !append ) 
		return( 0 );    /* nichts anhaengen */
	len = strlen( append );

	if (!(new_ = (char * ) calloc( 1 , to->noctets + len ))) {
		aux_add_error(EMALLOC, "new_", CNULL, 0, proc);
		return(-1);
	}


	for ( n = 0 ; n < to->noctets ; n++)
		new_[n] = to->octets[n]; /* to kopieren  */

	for ( n = 0 ; n < len ; n++)
		new_[to->noctets++] = append[n]; /*append kopieren*/

	if(to->octets) free(to->octets); /*alten speicherplatz freigeben */

	to->octets = new_;


	return(0);
}


/************************************************************************/
/*                                                                      */
/*    aux_hex_append                                                    */
/*                                                                      */
/*    haengt octetstring append in HEX-darstellung an octetstring to an */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_hex_append
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_hex_append(
	OctetString	 *to,
	OctetString	 *append
)

#else

RC aux_hex_append(
	to,
	append
)
OctetString	 *to;
OctetString	 *append;

#endif

{
	OctetString       * hexstr;
	int		    ec;
	char		  * proc = "aux_hex_append";

	/*----------------------------------------------------------------------*/
	if (!(hexstr = aux_enchex( append ))) {
		aux_add_error(LASTERROR, "aux_enchex failed", CNULL, 0, proc);
		return(-1);
	}

	if (( ec = aux_append_OctetString( to , hexstr )) ) {/*----------------------------------------------------------------------*/

		aux_add_error(LASTERROR, "aux_append_OctetString failed", CNULL, 0, proc);
		aux_free_OctetString( &hexstr );
		return( ec );
	}
	aux_free_OctetString( &hexstr );
	return( 0 );
}



/************************************************************************/
/*                                                                      */
/*      aux_searchitem                                                  */
/*                                                                      */
/*      sucht in octetstring bst nach string item beginnend bei         */
/*      *pos. bei returncode 0 war die suche erfolgreich und *pos       */
/*      ist die position des ersten zeichens nach item                  */
/*      nicht gefunden: rc=-1                                           */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_searchitem
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_searchitem(
	OctetString	 *bst,
	char		 *item,
	int	 	 *pos
)

#else

RC aux_searchitem(
	bst,
	item,
	pos
)
OctetString	 *bst;
char		 *item;
int		 *pos;

#endif

{
	char		incs[256];
	unsigned int	le, n, m, l;
	char		c, * text;
	char	      * proc = "aux_searchitem";

	if ( !bst || !item || !pos ) {
		aux_add_error(EINVALID, "one parameter = 0", CNULL, 0, proc);
		return(-1);
	}


	text = bst->octets;

	le = strlen( item );

	for ( n = 0 ; n < 256 ; n++) 
		incs[ n ] = le;
	for ( n = le - 1 ; n > 0 ; n--) {
		c = item[ n - 1 ];
		if ( incs[ c ] == le )
			incs[ c ] = le - n;
	}

	n = le - 1 + *pos;
	l = bst->noctets;
	while ( n < l ) {

		for ( m = le ; m > 0 && item[ m - 1 ] == text[ n + m - le ] ; m--) 
			;
		if ( !m ) {
			*pos = n + 1;
			return( 0 );
		} else
			n += incs[ (unsigned char)text[ n ] ];
	}

	return (-1);

}


/************************************************************************/
/*                                                                      */
/*      aux_ostr_get64                                                  */
/*                                                                      */
/*      holt den text von pos ab bis zum naechsten X-Header-Feld        */
/*      aus dem msgbuf wobei erwartet wird das jede zeile 64 zeichen    */
/*      enthaelt und das erste zeichen ein leerzeichen ist              */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_ostr_get64
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_ostr_get64(
	OctetString	 *msgbuf,
	int		  pos
)

#else

OctetString *aux_ostr_get64(
	msgbuf,
	pos
)
OctetString	 *msgbuf;
int		  pos;

#endif

{
	int		  n, m;
	OctetString       text64, *text;   /*return*/
	char		* proc = "aux_ostr_get64";

	m = msgbuf->noctets - 1;
	for ( n = pos; n < m; n++) {
		if (msgbuf->octets[n] == '\n') {
			if (msgbuf->octets[n+1] != ' ')
				break;
		}
	}
	text64.noctets = n - pos;
	text64.octets = msgbuf->octets + pos;
	if ( text64.octets[text64.noctets - 1] == '\r' )
		text64.noctets--;

	if (!(text = aux_de64(&text64 , 1))) {
		aux_add_error(LASTERROR, "aux_de64 failed", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	return( text );
}


/************************************************************************/
/*                                                                      */
/*      aux_cmpitem                                                     */
/*                                                                      */
/*      vergleicht item mit dem text in msgbuf bei position pos         */
/*      bei returncode 0 sind die texte gleich                          */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_cmpitem
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_cmpitem(
	OctetString	 *msgbuf,
	char		 *item,
	int		  pos
)

#else

RC aux_cmpitem(
	msgbuf,
	item,
	pos
)
OctetString	 *msgbuf;
char		 *item;
int		  pos;

#endif

{
	int	  n, le;
	char	* proc = "aux_cmpitem";

	if (!msgbuf || !item ) {
		aux_add_error(EINVALID, "one parameter = 0", CNULL, 0, proc);
		return(-1);
	}

	le = strlen( item );

	for ( n = 0 ; n < le ; n++)
		if ( msgbuf->octets[ n + pos ] != item[ n ] )  
			return( 1 );

	return( 0 );
}




/************************************************************************/
/*                                                                      */
/*      aux_create_SerialNo                                             */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/***************************************************************
 *
 * Procedure aux_create_SerialNo
 *
 ***************************************************************/
#ifdef __STDC__

OctetString * aux_create_SerialNo(
	char		 *number
)

#else

OctetString * aux_create_SerialNo(
	number
)
char		 *number;

#endif

{
	RC		rc;
	OctetString     *ret;
	OctetString     *tmp_ostr1 = NULLOCTETSTRING, *tmp_ostr2 = NULLOCTETSTRING;
	char	        *proc = "aux_create_SerialNo";

	if (!number) {
		aux_add_error(EINVALID, "empty parameter", CNULL, 0, proc);
		return(NULLOCTETSTRING);
	}

	tmp_ostr1 = aux_create_OctetString(number);
	if(tmp_ostr1->noctets % 2){
		tmp_ostr2 = aux_new_OctetString(1);
		tmp_ostr2->octets[0] = 0x30;
		rc = aux_append_OctetString(tmp_ostr2, tmp_ostr1);
		ret = aux_dechex(tmp_ostr2);
	}
	else ret = aux_dechex(tmp_ostr1);
	if(tmp_ostr1) aux_free_OctetString(&tmp_ostr1);
	if(tmp_ostr2) aux_free_OctetString(&tmp_ostr2);

	return(ret);
}





/***************************************************************
 *
 * Procedure aux_String2SerialNumber
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_String2SerialNumber(
	char	 *ostr_repr
)

#else

OctetString *aux_String2SerialNumber(
	ostr_repr
)
char	 *ostr_repr;

#endif

{
	int 		 n = 0, l;
	char		 c;
	L_NUMBER 	 lnum[5];
	static L_NUMBER	 rep[2] = { 1, 2 };
	static L_NUMBER	 tmp[2] = { 1, 0 };
	char 		*proc = "aux_String2SerialNumber";

	if (!ostr_repr) {
		aux_add_error(EINVALID, "empty parameter", CNULL, 0, proc);
		return((OctetString *)0);
	}
	l = strlen(ostr_repr);

	if(!l) {
		aux_add_error(EINVALID, "empty parameter", CNULL, 0, proc);
		return((OctetString *)0);
	}
	if(ostr_repr[0] != '0') {
/* decimal */
		rep[1] = 10;
	}
	else if(l > 1 && (ostr_repr[1] == 'x' || ostr_repr[1] == 'x')) {
/* hexadecimal */
		n += 2;
		rep[1] = 16;


	}
	else if(l > 1 && (ostr_repr[1] == 'b' || ostr_repr[1] == 'b')) {
/* binary */
		n += 2;
		rep[1] = 2;


	}
	else {
/* octal */
		n ++;
		rep[1] = 8;


	}
	for(lnum[0] = 0; n < l; n++) {
		mult(lnum, rep, lnum);
		c = ostr_repr[n];

		if(c >= '0' && c <= '9') tmp[1] = c - '0';
		else if(c >= 'a' && c <= 'f') tmp[1] = c - 'a' + 10;
		else if(c >= 'A' && c <= 'F') tmp[1] = c - 'A' + 10;
		else  {
			aux_add_error(EINVALID, "invalid number format", CNULL, 0, proc);
			return((OctetString *)0);
		}

		if(tmp[1] >= rep[1])  {
			aux_add_error(EINVALID, "invalid number format", CNULL, 0, proc);
			return((OctetString *)0);
		}

		add(lnum, tmp, lnum);
	}
	if(!lnum[0]) {
		OctetString *ret;
		ret = aux_new_OctetString(1);
		ret->octets[0] = 0x00;
		return(ret);
	}
	return(aux_LN2OctetString(lnum, 0));

	
}




/* Transforms "int" representation of Integer into "OctetString" representation*/

/***************************************************************
 *
 * Procedure aux_int2OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString * aux_int2OctetString(
	int	 int_repr
)

#else

OctetString * aux_int2OctetString(
	int_repr
)
int	 int_repr;

#endif

{
	OctetString	 * ostr_repr;
	PE                 P_INTEGER;
	int		   result;
	char		 * proc = "aux_int2OctetString";

	if (int_repr < 0) {
		aux_add_error(EINVALID, "invalid parameter", CNULL, 0, proc);
		return(NULLOCTETSTRING);
	}

	ostr_repr = (OctetString * ) malloc(sizeof(OctetString));
	if(!ostr_repr){
		aux_add_error(EMALLOC, "ostr_repr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	P_INTEGER = num2prim (int_repr, PE_CLASS_UNIV, PE_PRIM_INT);
	if(P_INTEGER == NULLPE)
		return (NULLOCTETSTRING);

	result = parse_SEC_OURINTEGER(P_INTEGER, 1, NULLIP, NULLVP, ostr_repr);
	pe_free(P_INTEGER);

	return (result ? NULLOCTETSTRING : ostr_repr);

	
}


/***************************************************************
 *
 * Procedure aux_prepend_dash_
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_prepend_dash_(
	OctetString	 *ostr,
	int		  number
)

#else

RC aux_prepend_dash_(
	ostr,
	number
)
OctetString	 *ostr;
int		  number;

#endif

{
	char		 * proc = "aux_prepend_dash_";
	int		   n, m, dashes = 0;
	char		 * new_, *old;

	if(!ostr)  {
		aux_add_error(EINVALID, "ostr is empty", CNULL, 0, proc);
		return (-1);
	}
	if(!ostr->noctets || !number) return(0);




	if(*ostr->octets == '-') dashes = 1;

	for(n = ostr->noctets - 2; n >= 0; n--)
		if(ostr->octets[n] == '\n' && ostr->octets[n+1] == '-') dashes++;

	if(!dashes) return(0);


	m = ostr->noctets + 2 * dashes * number;

	ostr->octets = realloc(ostr->octets, m);
	if (!ostr->octets) {
		aux_add_error(EMALLOC, "ostr->octets", CNULL, 0, proc);
		return (-1);
	}
	for(old = ostr->octets + (ostr->noctets - 1), new_ = ostr->octets + (m - 1);      new_ > old;       old--, new_--) {
		*new_ = *old;
		if(*old == '-' && (old == ostr->octets || *(old-1) == '\n')) 
		for(n = number; n; n--) {
			*(--new_) = ' ';
			*(--new_) = '-';
		}
	}
	ostr->noctets = m;
	return(0);
}
/***************************************************************
 *
 * Procedure aux_strip_dash_
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_strip_dash_(
	OctetString	 *ostr,
	int		  number
)

#else

RC aux_strip_dash_(
	ostr,
	number
)
OctetString	 *ostr;
int		  number;
#endif

{
	char		 * proc = "aux_strip_dash_";
	char		 * new_, *old, *last;
	Boolean		   warning = FALSE;
	int		   n;

	if(!ostr)  {
		aux_add_error(EINVALID, "ostr is empty", CNULL, 0, proc);
		return (-1);
	}
	if(!ostr->noctets) return(0);


	old = ostr->octets;
	last = old + ostr->noctets;
	new_ = ostr->octets;

	if(*old == '-') {
		for(n = number; n; n--)
		if(old + 2 > last || old[1] != ' ' || old[2] != '-') warning = TRUE;
		else old += 2;

	}
	for(; old < last; old++, new_++) {


		if(*old == '-' && *(old-1) == '\n') 
			for(n = number; n; n--)
			if(old + 2 > last || old[1] != ' ' || old[2] != '-') warning = TRUE;
			else old += 2;
		
		*new_ = *old;
	}
	if(warning) aux_add_warning(EMSGBUF, "There is a \"-\" at the beginning of the line which was not prependet by \"- \"", CNULL, 0, proc);


	ostr->noctets = (int) (new_ - ostr->octets);

	return(0);
}
/***************************************************************
 *
 * Procedure aux_OctetString_delete_string
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_OctetString_delete_string(
	OctetString	 *ostr,
	unsigned int	  pos,
	unsigned int	  len
)

#else

RC aux_OctetString_delete_string(
	ostr,
	pos,
	len
)
OctetString	 *ostr;
unsigned int	  pos;
unsigned int	  len;

#endif

{
	char		 * proc = "aux_OctetString_delete_string";

	if(!ostr)  {
		aux_add_error(EINVALID, "ostr is empty", CNULL, 0, proc);
		return (-1);
	}
	if(pos >= ostr->noctets) return(0);
	if(pos + len >= ostr->noctets) {
		ostr->noctets = pos;
		if(!pos) free(ostr->octets);
		return(0);
	}
	bcopy(ostr->octets + (pos + len), ostr->octets + pos, ostr->noctets - pos - len);

	ostr->noctets -= len;

	return(0);
}
/***************************************************************
 *
 * Procedure aux_OctetString_insert_string
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_OctetString_insert_string(
	OctetString	 *ostr,
	OctetString	 *item,
	unsigned int	  pos
)

#else

RC aux_OctetString_insert_string(
	ostr,
	item,
	pos
)
OctetString	 *ostr;
OctetString	 *item;
unsigned int	  pos;

#endif

{
	char		 * proc = "aux_OctetString_insert_string";

	if(!ostr || !item)  {
		aux_add_error(EINVALID, "ostr or item is empty", CNULL, 0, proc);
		return (-1);
	}
	if(ostr->noctets < pos) {
		aux_add_error(EINVALID, "Can't insert string at this position", CNULL, 0, proc);
		return (-1);
	}
	if(!item->noctets) return (0);
	
	if(!ostr->noctets) {
		if(aux_cpy2_OctetString(ostr, item) < 0)  {
			AUX_ADD_ERROR;
			return (-1);
		}
		return (0);
	}


	ostr->octets = realloc(ostr->octets, ostr->noctets + item->noctets);

	if(ostr->noctets > pos) bcopy(ostr->octets + pos, ostr->octets + (pos + item->noctets), ostr->noctets - pos);
	bcopy(item->octets, ostr->octets + pos, item->noctets);

	ostr->noctets += item->noctets;

	return(0);
}

