/* ./src/aux/aux_malloc.c */

static char *rcsid = "$Id: aux_malloc.c,v 1.3 1994/11/02 10:44:39 surkau Exp $";

/* 
 *
 * $Id: aux_malloc.c,v 1.3 1994/11/02 10:44:39 surkau Exp $
 *
 * $Log: aux_malloc.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include <stdlib.h>
#include <stdio.h>

#ifdef __STDC__
       void	mftrace	();
       char	*aux_malloc	(char *proc, unsigned size);
       char	*aux_calloc	(char *proc, unsigned elem, unsigned size);
       char	*aux_realloc	(char *proc, void *ptr, unsigned size);
       void	aux_free	(char *proc, void *ptr);
       void	MF_fprint	(FILE *fp);
       void	MF_fprint_stderr	();
#else
       void	mftrace	();
       char	*aux_malloc	();
       char	*aux_calloc	();
       char	*aux_realloc	();
       void	aux_free	();
       void	MF_fprint	();
       void	MF_fprint_stderr	();
#endif


#define MAXMLIST 4096
#define FALSE       0
#define TRUE        1

static struct {
	void 		*maddr;
	unsigned 	 msize;
	char		*mproc;
} mlist[MAXMLIST];

unsigned 	 mindex,
		allsize;
void 		*MFtrace = 0;
char 		 MFfound = 0;

extern char 	 MF_check;
extern int 	 sec_debug;


#ifdef __STDC__
        void	settrace	(void *addr);
	static void	mlist_check	(char *cmd, char *proc);
	static void	mlist_lookup	(char *cmd, char *proc, char *ptr);
	static void	malloc_panic	(char *proc, char *alloc, int size, char *ptr);
#else
        void	settrace	();
	static void	mlist_check	();
	static void	mlist_lookup	();
	static void	malloc_panic	();
#endif


/***************************************************************
 *
 * Procedure mftrace
 *
 ***************************************************************/
#ifdef __STDC__

void mftrace(
)

#else

void mftrace(
)

#endif
{
}
/***************************************************************
 *
 * Procedure mfwarning
 *
 ***************************************************************/
#ifdef __STDC__

void mfwarning(
)

#else

void mfwarning(
)

#endif
{
}


/***************************************************************
 *
 * Procedure settrace
 *
 ***************************************************************/
#ifdef __STDC__

void settrace(
	void	 *addr
)

#else

void settrace(
	addr
)
void	 *addr;

#endif

{
	MFtrace = addr;
	sec_debug = 2;
}


/***************************************************************
 *
 * Procedure mlist_lookup
 *
 ***************************************************************/
#ifdef __STDC__

static void mlist_lookup(
	char	 *cmd,
	char	 *proc,
	char	 *ptr
)

#else

static void mlist_lookup(
	cmd,
	proc,
	ptr
)
char	 *cmd;
char	 *proc;
char	 *ptr;

#endif

{
	int  i;
	for(i = 0; i < mindex; i++) {
		if (ptr == mlist[i].maddr) {
			fprintf(stderr, "Warning Malloc/Free: %s in %s: Address 0x%x is already allocated with size 0x%x in %s \n",cmd , proc, ptr, mlist[i].msize, mlist[i].mproc);
			mfwarning();
		}
	}

}

/***************************************************************
 *
 * Procedure aux_malloc
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_malloc_check(
	char		 *proc,
	char 		 *addr
)

#else

char *aux_malloc_check(
	proc,
	addr
)
char		 *proc;
char	  	 *addr;

#endif

{



	if(MF_check) {
		if(addr == MFtrace) mftrace();
		mlist_lookup("sys-malloc", proc, addr);
		if(mindex < MAXMLIST) {
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = 0;
			mlist[mindex].mproc = proc;
		        if(sec_debug > 1) fprintf(stderr, "    Total:%6d allocated. Address 0x%x (?? octets) (m)allocated in %s\n", allsize, addr, proc);
			mindex++;
		}
		else {
			fprintf(stderr, "Warning Malloc/Free: MAXMLIST too small. MF_check deactivated\n");
			mfwarning();
			MF_check = FALSE;
		}
	}

	return (addr);
}

/***************************************************************
 *
 * Procedure aux_malloc
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_malloc(
	char		 *proc,
	unsigned	  size
)

#else

char *aux_malloc(
	proc,
	size
)
char		 *proc;
unsigned	  size;

#endif

{
	char * addr;


	if(!size) size = 4;
	addr = calloc(1, size);
	if(!addr) malloc_panic(proc, "malloc", size, (char *)0);

	if(MF_check) {
		if(addr == MFtrace) mftrace();
		mlist_lookup("malloc", proc, addr);
		if(mindex < MAXMLIST) {
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = size;
			mlist[mindex].mproc = proc;
			allsize += size;
		        if(sec_debug > 1) fprintf(stderr, "    Total:%6d allocated. Address 0x%x (%4d octets) (m)allocated in %s\n", allsize, addr, size, proc);
			mindex++;
		}
		else {
			fprintf(stderr, "Warning Malloc/Free: MAXMLIST too small. MF_check deactivated\n");
			mfwarning();
			MF_check = FALSE;
		}
	}

	return (addr);
}


/***************************************************************
 *
 * Procedure aux_calloc
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_calloc(
	char		 *proc,
	unsigned	  elem,
	unsigned	  size
)

#else

char *aux_calloc(
	proc,
	elem,
	size
)
char		 *proc;
unsigned	  elem;
unsigned	  size;

#endif

{
	char           *addr;



	if(!elem) elem = 1;
	if(!size) size = 4;
	if(elem * size == 4800) {
		addr = (char *)0;
	}
	addr = calloc(elem, size);
	if(!addr) malloc_panic(proc, "calloc", elem*size, (char *)0);

	if(MF_check) {
		if(addr == MFtrace) mftrace();
		mlist_lookup("calloc", proc, addr);

		if(mindex < MAXMLIST) {
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = size * elem;
			mlist[mindex].mproc = proc;
			allsize += (size * elem);
		        if(sec_debug > 1) fprintf(stderr, "    Total:%6d allocated. Address 0x%x (%4d octets) (c)allocated in %s\n", allsize, addr, size * elem, proc);
			mindex++;
		}
		else {
			fprintf(stderr, "Warning Malloc/Free: MAXMLIST too small. MF_check deactivated\n");
			mfwarning();
			MF_check = FALSE;
		}
	}

	return (addr);
}

/***************************************************************
 *
 * Procedure aux_realloc
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_realloc(
	char		 *proc,
	void		 *ptr,
	unsigned	  size
)

#else

char *aux_realloc(
	proc,
	ptr,
	size
)
char		 *proc;
void		 *ptr;
unsigned	  size;

#endif

{
	char           *addr;
	int             i;



	if(!size) size = 4;
	addr = realloc(ptr, size);
	if(!addr) malloc_panic(proc, "realloc", size, ptr);

	if(MF_check) {
			
		if(addr == MFtrace) mftrace();

		for(i = 0; i < mindex && mlist[i].maddr != ptr; i++);
		if(i < mindex) {
			allsize += size - mlist[i].msize;
			mlist[i].maddr = addr;
			mlist[i].msize = size;
			mlist[i].mproc = proc;
		        if(sec_debug > 1) fprintf(stderr, "    Total:%6d allocated. Address 0x%x (%4d octets) reallocated in %s\n", allsize, addr, size, proc);
		} 
		else {
	        	fprintf(stderr, "Warning Malloc/Free: Block with address 0x%x and size %d reallocated in %s but not found in table\n", addr, size, proc);
			mfwarning();
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = size;
			mlist[mindex].mproc = proc;
			allsize += size;
			mindex++;
		}


	}

	return (addr);
}

/***************************************************************
 *
 * Procedure aux_free
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free(
	char	 *proc,
	void	 *ptr
)

#else

void aux_free(
	proc,
	ptr
)
char	 *proc;
void	 *ptr;

#endif

{
	int             ret = 0, i;


	if(!MF_check) {
		if(ptr) free(ptr);
		return;
	}

	if(ptr) {
		if(ptr == MFtrace) mftrace();
		for(i = 0; i < mindex; i++) {
			if(mlist[i].maddr == ptr) {
				if(i < mindex - 1) {
					allsize -= mlist[i].msize;
					if(sec_debug > 1) fprintf(stderr, "    Total:%6d allocated. Address 0x%x (%4d octets) freed in %s\n", allsize, ptr, mlist[i].msize, proc);
					mlist[i].maddr = mlist[mindex - 1].maddr;
					mlist[i].msize = mlist[mindex - 1].msize;
					mlist[i].mproc = mlist[mindex - 1].mproc;
				}
				else {
					allsize -= mlist[i].msize;
					if(sec_debug > 1) fprintf(stderr, "    Total:%6d allocated. Address 0x%x (%4d octets) freed in %s\n", allsize, ptr, mlist[i].msize, proc);
				}
				mlist[mindex - 1].maddr = (char *)0;
				mindex--;

				free(ptr); 
				return;
			}
		}
		fprintf(stderr, "Warning Malloc/Free: Bad address 0x%x in free in %s\n", ptr, proc);
		mfwarning();
	}
	else fprintf(stderr, "Warning Malloc/Free: NULL pointer in free in %s\n", proc);
	mfwarning();
	return;
}

/***************************************************************
 *
 * Procedure MF_fprint
 *
 ***************************************************************/
#ifdef __STDC__

void MF_fprint(
	FILE	 *fp
)

#else

void MF_fprint(
	fp
)
FILE	 *fp;

#endif

{

	int i;

	fprintf(fp, "%d addresses currently allocated\n", mindex);
	fprintf(fp, "%d octets of memory currently allocated\n", allsize);
	if(sec_debug > 1) for(i = 0; i < mindex; i++) fprintf(fp, "    addr = 0x%x (%4d octets) allocated in %s\n", mlist[i].maddr, mlist[i].msize, mlist[i].mproc);
}

/***************************************************************
 *
 * Procedure MF_fprint_stderr
 *
 ***************************************************************/
#ifdef __STDC__

void MF_fprint_stderr(
)

#else

void MF_fprint_stderr(
)

#endif
{


	MF_fprint(stderr);

}

/***************************************************************
 *
 * Procedure malloc_panic
 *
 ***************************************************************/
#ifdef __STDC__

static void malloc_panic(
	char	 *proc,
	char	 *alloc,
	int	  size,
	char	 *ptr
)

#else

static void malloc_panic(
	proc,
	alloc,
	size,
	ptr
)
char	 *proc;
char	 *alloc;
int	  size;
char	 *ptr;

#endif

{
	fprintf(stderr, "\n!!! PANIC: can't %s %d octets in %s\n", alloc, size, proc);
	if(!strcmp(alloc, "realloc")) fprintf(stderr, "           tried to realloc address %04X\n", ptr);
	MF_fprint(stderr);
	exit(-1);
}

