/* ./src/aux/aux_conv.c */

static char *rcsid = "$Id: aux_conv.c,v 1.5 1995/03/01 11:17:45 surkau Exp $";

/* 
 *
 * $Id: aux_conv.c,v 1.5 1995/03/01 11:17:45 surkau Exp $
 *
 * $Log: aux_conv.c,v $
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include <sys/types.h>

#ifdef MAC
#include <stdlib.h>
#endif /* MAC */

#include "secure.h"
#define APCONV

#define rfcval(x)	(rfctable[ascii(x)])
#define hexval(x)	(hextable[ascii(x)])

#ifndef EBCDIC
#define ascii(x)	((x)&0x7f)
#else
extern ascii();
#endif



#ifdef __STDC__
	static OctetString	*newocts	(int size);
	static void	maptorfc	(char *in, char *out, int len);
	static void	maprfc	(char *in, char *out, int len);
	static void	maptohex	(char *in, char *out, int len);
	static void	maphex	(char *in, char *out, int len);
	static void	maptoap	(char *in, char *out, int len);
	static char	apval	(int x);
	static void	mapap	(char *in, char *out, int len);
#else
	static OctetString	*newocts	();
	static void	maptorfc	();
	static void	maprfc	();
	static void	maptohex	();
	static void	maphex	();
	static void	maptoap	();
	static char	apval	();
	static void	mapap	();
#endif

/***************************************************************
 *
 * Procedure newocts
 *
 ***************************************************************/
#ifdef __STDC__

static OctetString *newocts(
	int	  size
)

#else

static OctetString *newocts(
	size
)
int	  size;

#endif

{
	OctetString * result;
	char	    * proc = "newocts";


	if ( !(result = (OctetString * )calloc(1, sizeof(OctetString))) )	
		return (NULLOCTETSTRING);
	result->noctets = size;
	result->octets = (char *)malloc(size+1);

	if (!result->octets) 
		free(result), result = NULLOCTETSTRING;

	return result;
}


/***************************************************************
 *
 * Procedure maptorfc
 *
 ***************************************************************/
#ifdef __STDC__

static void maptorfc(
	char	 *in,
	char	 *out,
	int	  len
)

#else

static void maptorfc(
	in,
	out,
	len
)
char	 *in;
char	 *out;
int	  len;

#endif

{
	static rfctable[64] = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
		'U', 'V', 'W', 'X', 'Y', 'Z',
		'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
		'u', 'v', 'w', 'x', 'y', 'z',
		'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
		'+', '/' 	};

	int	tri;

	for (tri = len; tri >= 3; tri -= 3) {
		*out++ = rfctable[ (in[0] >> 2) & 63 ];
		*out++ = rfctable[ ((in[1] >> 4) & 15) | ((in[0] & 3 ) << 4)  ];
		*out++ = rfctable[ ((in[2] >> 6) & 3) | ((in[1] & 15 ) << 2)  ];
		*out++ = rfctable[ in[2] & 63 ];
		in += 3;
	}
	switch (tri) {
	case 1:	
		*out++ = rfctable[ (in[0] >> 2) & 63  ];
		*out++ = rfctable[ (in[0] & 3 ) << 4  ];
		*out++ = '=';
		*out++ = '=';
		in++;
		break;

	case 2: 
		*out++ = rfctable[ (in[0] >> 2) & 63  ];
		*out++ = rfctable[ ((in[1] >> 4) & 15) | ((in[0] & 3 ) << 4)  ];
		*out++ = rfctable[ (in[1] & 15 ) << 2 ];
		*out++ = '=';
		in += 2;
		break;

	default: 
		break;
	}
	return;
}


/***************************************************************
 *
 * Procedure maprfc
 *
 ***************************************************************/
#ifdef __STDC__

static void maprfc(
	char	 *in,
	char	 *out,
	int	  len
)

#else

static void maprfc(
	in,
	out,
	len
)
char	 *in;
char	 *out;
int	  len;

#endif

{
	static rfctable[128] = {
		/*	x0 x1 x2 x3 x4 x5 x6 x7 x8 x9 10 11 12 13 14 15		*/
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 00 .. 0F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 10 .. 1F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 	/* 20 .. 2F */
		52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, 	/* 30 .. 3F */
		-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 	/* 40 .. 4F */
		15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, 	/* 50 .. 5F */
		-1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 	/* 60 .. 6F */
		41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, 	/* 70 .. 7F */
	};
	char	c0, c1, c2, c3;
	int	quattro;

	for ( quattro = len; quattro >= 4; quattro -= 4) {
		c0 = rfcval( *in++);
		c1 = rfcval( *in++);
		c2 = rfcval( *in++);
		c3 = rfcval( *in++);
		*out++ = (c0 << 2) | (c1 >> 4);
		*out++ = ((c1 & 15) << 4 ) | (c2 >> 2);
		*out++ = ((c2 & 3) << 6) | c3;
	}

	switch ( quattro ) {
	case 1:	/* decoding error */
		break;
	case 2:
		c0 = rfcval( *in++);
		c1 = rfcval( *in++);
		*out++ = (c0 << 2) | (c1 >> 4);
		break;
	case 3:
		c0 = rfcval( *in++);
		c1 = rfcval( *in++);
		c2 = rfcval( *in++);
		*out++ = (c0 << 2) | (c1 >> 4);
		*out++ = ((c1 & 15) << 4 ) | (c2 >> 2);
		break;
	default:
		break;
	}
}


/***************************************************************
 *
 * Procedure maptohex
 *
 ***************************************************************/
#ifdef __STDC__

static void maptohex(
	char	 *in,
	char	 *out,
	int	  len
)

#else

static void maptohex(
	in,
	out,
	len
)
char	 *in;
char	 *out;
int	  len;

#endif

{
	static hextable[16] = {
		'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
		'A', 'B', 'C', 'D', 'E', 'F',
	};
	int	bi;

	for (bi = len; bi > 0; bi--) {
		*out++ = hextable[(*in >> 4) & 15];
		*out++ = hextable[*(in++) & 15];
	}
	return;
}


/***************************************************************
 *
 * Procedure maphex
 *
 ***************************************************************/
#ifdef __STDC__

static void maphex(
	char	 *in,
	char	 *out,
	int	  len
)

#else

static void maphex(
	in,
	out,
	len
)
char	 *in;
char	 *out;
int	  len;

#endif

{
	static hextable[128] = {
		/*	x0 x1 x2 x3 x4 x5 x6 x7 x8 x9 10 11 12 13 14 15		*/
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 00 .. 0F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 10 .. 1F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 20 .. 2F */
	         0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1, 	/* 30 .. 3F */
		-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 40 .. 4F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 50 .. 5F */
		-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 60 .. 6F */
		-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 	/* 70 .. 7F */
	};
	char	c0, c1;
	int	bi;

	for (bi = len; bi >= 2; bi -= 2) {
		c0 = hexval( *in++);
		c1 = hexval( *in++);
		*out++ = (c0 << 4) | c1;
	}
	if (bi) {
		c0 = hexval( *in++);
		*out++ = c0 << 4;
	}
	return;
}


#ifdef APCONV

/***************************************************************
 *
 * Procedure maptoap
 *
 ***************************************************************/
#ifdef __STDC__

static void maptoap(
	char	 *in,
	char	 *out,
	int	  len
)

#else

static void maptoap(
	in,
	out,
	len
)
char	 *in;
char	 *out;
int	  len;

#endif

{
	static aptable[16] = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
	};
	int	bi;

	for (bi = len; bi > 0; bi--) {
		*out++ = aptable[(*in >> 4) & 15];
		*out++ = aptable[*(in++) & 15];
	}
	return;
}


/***************************************************************
 *
 * Procedure apval
 *
 ***************************************************************/
#ifdef __STDC__

static char apval(
	int	  x
)

#else

static char apval(
	x
)
int	  x;

#endif

{
	char	c = ascii(x);

	if (('A' <= c) && (c <= 'P') )	
		return c - 'A';
	if (('a' <= c) && (c <= 'p') )	
		return c - 'a';
	return - 1;
}


/***************************************************************
 *
 * Procedure mapap
 *
 ***************************************************************/
#ifdef __STDC__

static void mapap(
	char	 *in,
	char	 *out,
	int	  len
)

#else

static void mapap(
	in,
	out,
	len
)
char	 *in;
char	 *out;
int	  len;

#endif

{
	char	c0, c1;
	int	bi;

	for (bi = len; bi >= 2; bi -= 2) {
		c0 = apval( *in++);
		c1 = apval( *in++);
		*out++ = (c0 << 4) | c1;
	}
	if (bi) {
		c0 = apval( *in++);
		*out++ = c0 << 4;
	}
	return;
}


#endif



/***************************************************************
 *
 * Procedure aux_encrfc
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_encrfc(
	OctetString	 *in
)

#else

OctetString *aux_encrfc(
	in
)
OctetString	 *in;

#endif

{
	OctetString * v;
	int	      vlen;
	char	    * proc = "aux_encrfc";

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	vlen = (in->noctets + 2) / 3 * 4;
	if ( !(v = newocts(vlen)) ) {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maptorfc( in->octets, v->octets, in->noctets );
	return v;
}


/***************************************************************
 *
 * Procedure aux_decrfc
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_decrfc(
	OctetString	 *in
)

#else

OctetString *aux_decrfc(
	in
)
OctetString	 *in;

#endif

{
	OctetString * 	v;
	int	vlen, l;
	char	*proc = "aux_decrfc";

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	if ((vlen = in->noctets & 0x03)) {	/* assume padding stripped */
		vlen += in->noctets / 4 * 3 - 1;
		l = in->noctets;
	} else {
		vlen = in->noctets / 4 * 3;
		l = in->noctets;
		if (in->octets[in->noctets-1] == '=') {
			vlen--;
			l--;
			if (in->octets[in->noctets-2] == '=')
				vlen--, l--;
		}
	}
	if ( !(v = newocts(vlen)) )  {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maprfc( in->octets, v->octets, l );
	return v;
}


/***************************************************************
 *
 * Procedure aux_enchex
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_enchex(
	OctetString	 *in
)

#else

OctetString *aux_enchex(
	in
)
OctetString	 *in;

#endif

{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_enchex";

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = in->noctets * 2;
	if ( !(v = newocts(vlen)) )  {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maptohex( in->octets, v->octets, in->noctets );
	return v;
}


/***************************************************************
 *
 * Procedure aux_dechex
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_dechex(
	OctetString	 *in
)

#else

OctetString *aux_dechex(
	in
)
OctetString	 *in;

#endif

{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_dechex";

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = (in->noctets + 1) / 2;
	if ( !(v = newocts(vlen)) )  {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maphex( in->octets, v->octets, in->noctets );
	return v;
}

/***************************************************************
 *
 * Procedure aux_encap
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_encap(
	OctetString	 *in
)

#else

OctetString *aux_encap(
	in
)
OctetString	 *in;

#endif

{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_encap";

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = in->noctets * 2;
	if ( !(v = newocts(vlen)) ) {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	maptoap( in->octets, v->octets, in->noctets );
	return v;
}


/***************************************************************
 *
 * Procedure aux_decap
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_decap(
	OctetString	 *in
)

#else

OctetString *aux_decap(
	in
)
OctetString	 *in;

#endif

{
	OctetString * 	v;
	int	vlen;
	char	*proc = "aux_decap";

	if ( !in || !in->octets ) {
		aux_add_error(EINVALID, "in-param empty", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}

	vlen = (in->noctets + 1) / 2;
	if ( !(v = newocts(vlen)) ) {
		aux_add_error(EMALLOC, "v", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	mapap( in->octets, v->octets, in->noctets );
	return v;
}
