/* ./src/aux/aux_alias.c */

static char *rcsid = "$Id: aux_alias.c,v 1.13 1995/02/09 07:53:29 surkau Exp surkau $";

/* 
 *
 * $Id: aux_alias.c,v 1.13 1995/02/09 07:53:29 surkau Exp surkau $
 *
 * $Log: aux_alias.c,v $
 * deletes named PSE object
 *
 * Revision 1.10  1994/11/02  10:44:39  surkau
 * Header replaced by Id
 *
 * Revision 1.9  1994/11/02  10:30:56  koletzki
 * *** empty log message ***
 *
 * Revision 1.8  1994/11/02  09:39:08  surkau
 * SecuDE-4.4.a0
 *
 *
 */
 
/*
 *  
 */
/********************************************************************
 * Copyright (C) 1990-1994, GMD Darmstadt. All rights reserved.     *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


/********************************************************************
 *	EXPORT:							    *
 *								    *
 *		aux_alias()					    *
 *		aux_alias2Name()				    *
 *		aux_alias2DName()				    *
 *		aux_Name2alias()				    *
 *		aux_Name2NameOrAlias()				    *
 *		aux_DName2alias()				    *
 *		aux_DName2NameOrAlias()				    *
 *		aux_Name2aliasf()				    *
 *		aux_DName2aliasf()				    *
 *		aux_add_alias_name()				    *
 *		aux_add_alias()					    *
 *		aux_delete_alias()				    *
 *		aux_delete_group_alias()			    *
 *		aux_cat_groupORalias()			    	    *
 *		aux_fprint_alias2dname()			    *
 *		aux_fprint_dname2alias()			    *
 *		aux_search_AliasList()				    *
 *		aux_next_AliasList()				    *
 *		aux_alias_nxtname()				    *
 *		aux_alias_chkfile()				    *
 *		aux_alias_getall()				    *
 *		aux_get_AliasList()				    *
 *		aux_put_AliasList()				    *
 *		aux_check_AliasList()				    *
 *		aux_select_AliasList()				    *
 *		aux_filter_AliasList()				    *
 *		aux_alias_filter()				    *
 *				  				    *
 *		kill_aliases_without_reading			    *
 *		got_system_aliases_once				    *
 *		got_user_aliases_once				    *
 *								    *
 *	IMPORT:							    *
 *		AliasList_read	(from af_pse.c)			    *
 *								    *
 *	LOCAL:							    *
 *								    *
 *		get_AliasList()					    *
 *		free_AliasList()				    *
 *		pass_filter()					    *
 *		strmtch()					    *
 *                                                                  *
 *		aliaslist					    *
 *		last_aliaslist					    *
 *		filter_user_aliases				    *
 *		filter_system_aliases		 		    *
 *								    *
 ********************************************************************/


#include <stdio.h>
#include "af.h"
#ifdef MAC 
#include "Mac.h"
#endif




/* EXPORT */

/* 	aux_put_AliasList() kills given alias list physically
 * 	if get_AliasList() has not been called before.
 *	Set kill_aliases_without_reading = TRUE to allow, = FALSE to avoid this "feature".
 */
Boolean     		kill_aliases_without_reading = FALSE;
/*
 *	get_AliasList() sets got_*_alias_once = TRUE after the related
 *	part of aliaslist has been addressed (independant of success in reading)
 */
Boolean     		got_system_aliases_once = TRUE;
Boolean     		got_user_aliases_once = TRUE;

/* IMPORT */

/* PSE object AliasList cached */
extern Boolean		AliasList_read;

/* LOCAL */
static AliasList 	*aliaslist;
static AliasList 	*last_aliaslist;
static Boolean     	systemfile_write_protection;
static AliasFile	filter_aliases;
static Boolean     	filter_user_aliases = TRUE;
static Boolean     	filter_system_aliases = TRUE;



#ifdef __STDC__
	static char	*strmtch	(char *a, char *b);
	static AliasList * get_AliasList();
	static void free_AliasList();
	static Boolean pass_filter(AliasFile afile);
#else
	static char *strmtch();
	static AliasList * get_AliasList();
	static void free_AliasList();
	static Boolean pass_filter();
#endif



/****************************************************************/

/*
 *	search alias
 *	return useralias/systemalias if found, else notstored
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_alias
 *
 ***************************************************************/
#ifdef __STDC__

AliasFile aux_alias(
	char	 *alias
)

#else

AliasFile aux_alias(
	alias
)
char	 *alias;

#endif

{
	char			*proc = "aux_alias";
	register AliasList	*aa;
	register Aliases 	*aliasmember;



	if (!alias) {
		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(notstored);
	}
		
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(notstored); 			 /* no alias names read */
		
	aa = aliaslist;
	while (aa)  {
		aliasmember = aa->a;
		while (aliasmember)  {
			if (!strcmp(aliasmember->aname, alias)) return(aliasmember->aliasfile);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	return(notstored);

}




/*
 *	search alias
 *	return pointer to owner's DName, else NULL
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_alias2DName
 *
 ***************************************************************/
#ifdef __STDC__

DName *aux_alias2DName(
	Name	 *alias
)

#else

DName *aux_alias2DName(
	alias
)
Name	 *alias;

#endif

{
	DName   * dname;
	Name    * name;
	char	* proc = "aux_alias2DName";


	name = aux_alias2Name(alias);

	if (name) {
		dname = aux_Name2DName(name);
		free(name);
	}
	else dname = (DName *)0;

	return (dname);
}




/*
 *	search alias
 *	return pointer to owner's Name if target exists, else alias
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_alias2Name
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_alias2Name(
	Name	 *alias
)

#else

Name *aux_alias2Name(
	alias
)
Name	 *alias;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char    *target, *zwalias, *zwalias2, *dd;
	DName   *zwdname;
	Boolean alias_in_Name_form = FALSE, free_dd = FALSE;
	char	*proc = "aux_alias2Name";


	if (!alias) {
 		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(CNULL);
	}
		
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(aux_cpy_String(alias));  /* no alias names read */

	zwalias = (char *)0;
	if(strchr(alias, '=')) {

		/* if alias names are in the Name form, compare on the basis of
                   normalized names. Ignore ORName attributes.  */
 
		alias_in_Name_form = TRUE;
		zwdname = aux_ORName2DName(alias);
		if(zwdname) {
			zwalias = aux_DName2CAPITALName(zwdname);
			aux_free_DName(&zwdname);
		}
	}
	if(!zwalias) zwalias = aux_cpy_String(alias);


	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
		
			/* Filter */
			if (!pass_filter(aliasmember->aliasfile)) {
				aliasmember = aliasmember->next;
				continue;
			}
		
			dd = aliasmember->aname;
			free_dd = FALSE;
			if(alias_in_Name_form && strchr(aliasmember->aname, '=')) {
				zwdname = aux_ORName2DName(aliasmember->aname);
				if(zwdname) {
					dd = aux_DName2CAPITALName(zwdname);
					free_dd = TRUE;
					aux_free_DName(&zwdname);
				}
				/*** else aux_free_error(); ***/
			}

			if (strcmp(dd, zwalias) == 0) {

				/* alias found, return target */
			
				free(zwalias);
				if(free_dd) free(dd);

				return(aux_cpy_String(aa->dname));
			}

			if(free_dd) free(dd);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	/* alias not found */

	free(zwalias);
	return(aux_cpy_String(alias));
}




/***************************************************************
 *
 * Procedure aux_cat_groupORalias
 *
 ***************************************************************/
#ifdef __STDC__

int aux_cat_groupORalias(
	Name	 *alias,
	SET_OF_NAME **list
)

#else

int aux_cat_groupORalias(
	alias,	
	list
)
Name	 *alias;
SET_OF_NAME **list;

#endif

{
	SET_OF_NAME *list2;
	int      number = 0;
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char    *target, *zwalias, *zwalias2, *dd;
	DName   *zwdname;
	Boolean alias_in_Name_form = FALSE, free_dd = FALSE;
	char	*proc = "aux_cat_groupORalias";


	if (!alias) {
 		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(-1);
	}
		
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) goto set_name;  /* no alias names read */

	zwalias = (char *)0;
	if(strchr(alias, '=')) {

		/* if alias names are in the Name form, compare on the basis of
                   normalized names. Ignore ORName attributes.  */
 
		alias_in_Name_form = TRUE;
		zwdname = aux_ORName2DName(alias);
		if(zwdname) {
			zwalias = aux_DName2CAPITALName(zwdname);
			aux_free_DName(&zwdname);
		}
	}
	if(!zwalias) zwalias = aux_cpy_String(alias);


	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
		
			/* Filter */
			if (!pass_filter(aliasmember->aliasfile)) {
				aliasmember = aliasmember->next;
				continue;
			}
		
			dd = aliasmember->aname;
			free_dd = FALSE;
			if(alias_in_Name_form && strchr(aliasmember->aname, '=')) {
				zwdname = aux_ORName2DName(aliasmember->aname);
				if(zwdname) {
					dd = aux_DName2CAPITALName(zwdname);
					free_dd = TRUE;
					aux_free_DName(&zwdname);
				}
				/*** else aux_free_error(); ***/
			}

			if (strcmp(dd, zwalias) == 0 || (strncmp(dd, GROUP_PREFIX, GROUP_PREFIX_LENGTH) == 0 && strcmp(dd + GROUP_PREFIX_LENGTH, zwalias) == 0)) {

				/* alias found, return target */
			
				if(free_dd) free(dd);

				if(!(list2 = (SET_OF_NAME *) calloc(1, sizeof(SET_OF_NAME)))){
					aux_add_error(EMALLOC, "list2", CNULL, 0, proc);
					return(-1);
				}
				if(!(list2->element = (NAME *) calloc(1, sizeof(NAME)))){
					aux_add_error(EMALLOC, "list2->element", CNULL, 0, proc);
					return(-1);
				}
				list2->next = *list;
				*list = list2;
				if(!(list2->element->dname = aux_Name2DName(aa->dname))){
					AUX_ADD_ERROR;
					return(-1);
				}
				if(!(list2->element->name = aux_cpy_String(aa->dname))){
					AUX_ADD_ERROR;
					return(-1);
				}
				if(!(list2->element->alias = aux_Name2alias(aa->dname, ANYALIAS))){
					AUX_ADD_ERROR;
					return(-1);
				}
				number++;

			}

			if(free_dd) free(dd);
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	free(zwalias);

set_name:
	if(!number){
		zwdname = aux_Name2DName(alias);
		if(zwdname) {
				/* alias not found, return alias */
			
				if(free_dd) free(dd);

				if(!(list2 = (SET_OF_NAME *) calloc(1, sizeof(SET_OF_NAME)))){
					aux_add_error(EMALLOC, "list2", CNULL, 0, proc);
					return(-1);
				}
				if(!(list2->element = (NAME *) calloc(1, sizeof(NAME)))){
					aux_add_error(EMALLOC, "list2->element", CNULL, 0, proc);
					return(-1);
				}
				list2->next = *list;
				*list = list2;
				list2->element->dname = zwdname;

				if(!(list2->element->name = aux_cpy_String(alias))){
					AUX_ADD_ERROR;
					return(-1);
				}
				if(!(list2->element->alias = aux_cpy_String(alias))){
					AUX_ADD_ERROR;
					return(-1);
				}
				number++;

		}
	}
	return(number);
}





/*
 *	search alias for DName with given flag for alias type
 *	return pointer to alias on success, else NULL
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_DName2alias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2alias(
	DName		 *dname,
	AliasType	  type
)

#else

char *aux_DName2alias(
	dname,
	type
)
DName		 *dname;
AliasType	  type;

#endif

{
	char			*proc = "aux_DName2alias";
	Name 			*name;
	char 			*alias;



	if(!dname){
		aux_add_error(EINVALID, "Invalid parameter: dname", CNULL, 0, proc);
		return(CNULL);
	}

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2alias(name, type);

	if (name) free(name);
	if (!alias) return(CNULL);


	return(alias);

}



/*
 *	search alias of type LOCALNAME for DName
 *	return pointer to alias on success, else Name form of DName
 *	(return CNULL if DName transformation failes)
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_DName2NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2NameOrAlias(
	DName		 *dname
)

#else

char *aux_DName2NameOrAlias(
	dname
)
DName		 *dname;

#endif

{
	char			*proc = "aux_DName2NameOrAlias";
	Name 			*name;
	char 			*alias;



	if(!dname) {
		aux_add_error(EINVALID, "Invalid parameter: dname", CNULL, 0, proc);
		return(CNULL);
	}

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2alias(name, LOCALNAME);

	if (!alias) return(name);
	else {
		free(name);
		return(alias);
	}
}


/*
 *	search alias of type LOCALNAME for Name
 *	return pointer to alias on success, else Name
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_Name2NameOrAlias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_Name2NameOrAlias(
	Name		 *name
)

#else

char *aux_Name2NameOrAlias(
	name
)
Name		 *name;

#endif

{
	char			*proc = "aux_Name2NameOrAlias";
	char 			*alias;


	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(CNULL);
	}

	alias = aux_Name2alias(name, LOCALNAME);

	if (!alias) return(aux_cpy_Name(name));
	else return(alias);
}




/*
 *	search alias for Name with given flag for alias type
 *	return pointer to alias on success, else NULL
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_Name2alias
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_Name2alias(
	Name		 *name,
	AliasType	  type
)

#else

char *aux_Name2alias(
	name,
	type
)
Name		 *name;
AliasType	  type;

#endif

{
	char	*proc = "aux_Name2alias";
	register Aliases 	*aliasmember, *am;
	register AliasList 	*aa;


	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(CNULL);
	}
	if (type != LOCALNAME && type != RFCMAIL && type != X400MAIL && type != ANYALIAS) {
		aux_add_error(EINVALID, "Invalid parameter: type", CNULL, 0, proc);
		return(CNULL);
	}

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (CNULL);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
        	if (strcmp(aa->dname, name) == 0) {
	        	aliasmember = aa->a;
			while(aliasmember && !strncmp(aliasmember->aname, GROUP_PREFIX, GROUP_PREFIX_LENGTH)) aliasmember = aliasmember->next;
        		if(aliasmember) {
        		
				/* Filter */
				if (!pass_filter(aliasmember->aliasfile)) {
					aliasmember = aliasmember->next;
					continue;
				}
		
				if(type == ANYALIAS) {
					return(aux_cpy_String(aliasmember->aname)); /* return first alias entry */
				}
				while (aliasmember) {
					switch(type) {
						case RFCMAIL:
							if(strchr(aliasmember->aname, '@')) {
								return(aux_cpy_String(aliasmember->aname));
							}
							break; 
						case X400MAIL:
							if(strchr(aliasmember->aname, '=')) {
								return(aux_cpy_String(aliasmember->aname));
							}
							break; 
						case LOCALNAME:
							if(strchr(aliasmember->aname, '=')) break;
							if(strchr(aliasmember->aname, '@')) break;
							else {
								return(aux_cpy_String(aliasmember->aname));
							}
							break;
					}
					aliasmember = aliasmember->next;
				}
			}		
			else goto noalias;
		}
		aa = aa->next;
	}
noalias:
	return (CNULL);
}




/* 
 *	like aux_DName2alias(), but only for a given dname and alias file
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_DName2aliasf
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_DName2aliasf(
	DName		 *dname,
	AliasType	  type,
	AliasFile	  afile
)

#else

char *aux_DName2aliasf(
	dname,
	type,
	afile
)
DName		 *dname;
AliasType	  type;
AliasFile	  afile;

#endif

{
	char			*proc = "aux_DName2aliasf";
	Name 			*name;
	char 			*alias;



	if(!dname) {
		aux_add_error(EINVALID, "Invalid parameter: dname", CNULL, 0, proc);
		return(CNULL);
	}
	if (afile != useralias && afile != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: afile", CNULL, 0, proc);
		return(CNULL);
	}

	name = aux_DName2Name(dname);
	if(!name) return (CNULL);

	alias = aux_Name2aliasf(name, type, afile);

	if (name) free(name);
	
	if (!alias) return(CNULL);


	return(alias);

}




/* 
 *	like aux_Name2alias(), but only for a given name and alias file
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_Name2aliasf
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_Name2aliasf(
	char		 *name,
	AliasType	  type,
	AliasFile	  afile
)

#else

char *aux_Name2aliasf(
	name,
	type,
	afile
)
char		 *name;
AliasType	  type;
AliasFile	  afile;

#endif

{
	char			*proc = "aux_Name2aliasf";
	register Aliases 	*aliasmember;
	register AliasList 	*aa;


	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(CNULL);
	}
	if (afile != useralias && afile != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: afile", CNULL, 0, proc);
		return(CNULL);
	}
	if (type != LOCALNAME && type != RFCMAIL && type != X400MAIL && type != ANYALIAS) {
		aux_add_error(EINVALID, "Invalid parameter: type", CNULL, 0, proc);
		return(CNULL);
	}

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (CNULL);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
        	if (strcmp(aa->dname, name) == 0) {

			aliasmember = aa->a;
			if(aliasmember) {
		
				while (aliasmember) {
					if (aliasmember->aliasfile == afile) switch(type) {
		
						/* next best: return first alias entry from aliasfile*/
						case ANYALIAS:
		
							return(aux_cpy_String(aliasmember->aname));
							break;
		
						case RFCMAIL:
		
							if(strchr(aliasmember->aname, '@')) 
								return(aux_cpy_String(aliasmember->aname));
							break; 
		
						case X400MAIL:
		
							if(strchr(aliasmember->aname, '=')) 
								return(aux_cpy_String(aliasmember->aname));
							break; 
		
						case LOCALNAME:
		
							if(strchr(aliasmember->aname, '=')) break;
							if(strchr(aliasmember->aname, '@')) break;
							else return(aux_cpy_String(aliasmember->aname));
							break;
		
					}
					aliasmember = aliasmember->next;
				}
			}		
			else goto noalias;
		}
		aa = aa->next;
	}

noalias:
	return (CNULL);

}




/*
 *	add reduced alias to Name's entry with given flags for USER/SYSTEM-file,
 *	chaining priority, and immediate file writing
 *	aliases must be unique for each USER-/SYSTEM-file combination
 *	if prior is TRUE, alias is chained in as first entry (hi priority), else as last entry
 *	new DNames are inserted in alphabetical order
 *	return 0 on success, else -1
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_add_alias_name
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_add_alias_name(
	char		 *alias,
	Name		 *name,
	AliasFile	  aliasf,
	Boolean		  prior,
	Boolean		  writef
)

#else

RC aux_add_alias_name(
	alias,
	name,
	aliasf,
	prior,
	writef
)
char		 *alias;
Name		 *name;
AliasFile	  aliasf;
Boolean		  prior;
Boolean		  writef;

#endif

{
        DName   *dn;
	char	*proc = "aux_add_alias_name";
	int	ret;


	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(-1);
	}
	
	dn = aux_Name2DName(name);
	ret = aux_add_alias(alias, dn, aliasf, prior, writef);
	aux_free_DName(&dn);
	return(ret);
}


/*
 *	like aux_add_alias_name(), for DNames
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_add_alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_add_alias(
	char		 *alias,
	DName		 *dn,
	AliasFile	  aliasf,
	Boolean		  prior,
	Boolean		  writef
)

#else

RC aux_add_alias(
	alias,
	dn,
	aliasf,
	prior,
	writef
)
char		 *alias;
DName		 *dn;
AliasFile	  aliasf;
Boolean		  prior;
Boolean		  writef;

#endif

{
	register Aliases *aliasmember, *new_am;
	register AliasList *new_aa, *aa, *bb;
	Name    *n;
	char	*ralias;
	char	*proc = "aux_add_alias";



	if (! (ralias = aux_cpy_ReducedString(alias)) ) {
 		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(-1);
	}
	if(!dn) {
		aux_add_error(EINVALID, "Invalid parameter: dn", CNULL, 0, proc);
		return(-1);
	}
	if (aliasf != useralias && aliasf != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return(-1);
	}

	if (!aliaslist) aliaslist = get_AliasList();

	/* Filter */
	if (!pass_filter(aliasf)) {
		aux_add_error(EINVALID, "Filter: selected aliases don't pass", CNULL, 0, proc);
		return(-1);
	}

	/*
         *  Try to find alias in aliaslist->aname. If found, return -1, else insert alias and return 0
	 *	prior: if TRUE, alias will be chained as first entry
	 *	       if FALSE, alias will be chained as last entry
         */

	if (strncmp(ralias, GROUP_PREFIX, GROUP_PREFIX_LENGTH) && aux_alias(ralias) != notstored)  {		/* already there ? */
		aux_add_error(EINVALID, "Alias already exists.", CNULL, 0, proc);
		if (ralias) free(ralias);
		return(-1);
	}

	n = aux_DName2Name(dn);

	aa = aliaslist;
	while (aa) {
		if(strcmp(aa->dname, n) == 0)  {		/* dname already exists with at least one alias */
			aliasmember = aa->a;
			while (aliasmember)  {
				if(!aliasmember->next)  { 		/* chain in new member */
					new_am = (Aliases *)malloc(sizeof(Aliases));
					if(!new_am) goto malloc_err;
					new_am->aname = (char *)malloc(strlen(ralias) + 1); 
					if(!new_am->aname) goto malloc_err;

					if (prior)  {			/* chain in as first alias */
						new_am->next = aa->a;
						aa->a = new_am;
					} else  {			/* chain in as last alias */
						aliasmember->next = new_am;
						new_am->next = (Aliases *)0;
					}
						
					strcpy(new_am->aname, ralias);
					new_am->aliasfile = aliasf;

					if (ralias) free(ralias);
					if (writef) {
						if(aux_put_AliasList(aliasf) < 0){
							aux_add_error(LASTERROR, "Can't put alias list after adding alias", CNULL, 0, proc);
							return(-1);
						}
					}

					return(0);
				}
				aliasmember = aliasmember->next;
			}
		}
		aa = aa->next;
	}


	/* else: new dname entry */

 	new_aa = (AliasList *)malloc(sizeof(AliasList));
 	if(!new_aa) goto malloc_err;
 	new_aa->a = (Aliases *)malloc(sizeof(Aliases)); 
 	if(!new_aa->a) goto malloc_err;
	aliasmember = new_aa->a;
  	aliasmember->aname = (char *)malloc(strlen(ralias) + 1); 
 	if(!aliasmember->aname) goto malloc_err;
  	strcpy(aliasmember->aname, ralias);
  	aliasmember->aliasfile = aliasf;
  	aliasmember->next = (Aliases *) 0;
 	new_aa->dname = (char *)malloc(strlen(n) + 1);
 	if(!new_aa->dname) goto malloc_err;
 	strcpy(new_aa->dname, n);

	aa = aliaslist;
	while (aa && strcmp(aa->dname, n) < 0)  {
		bb = aa; 
		aa = aa->next;
	}
	if(aa == aliaslist)  {
		new_aa->next = aliaslist;
		aliaslist = new_aa;
	} else  {
		new_aa->next = bb->next;
		bb->next = new_aa;
	} 
  
  	if (ralias) free(ralias);
  	if (writef){
		if(aux_put_AliasList(aliasf) < 0){
			aux_add_error(LASTERROR, "Can't put alias list after adding alias", CNULL, 0, proc);
			return(-1);
		}
	}
  
  	return(0);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(-1);


}
/***************************************************************
 *
 * Procedure aux_add_alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_add_group_alias(
	char		 *alias,
	DName		 *dn,
	AliasFile	  aliasf,
	Boolean		  prior,
	Boolean		  writef
)

#else

RC aux_add_group_alias(
	alias,
	dn,
	aliasf,
	prior,
	writef
)
char		 *alias;
DName		 *dn;
AliasFile	  aliasf;
Boolean		  prior;
Boolean		  writef;

#endif

{
	RC    rc;
	char *group_alias;

	if (!alias) {
 		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(-1);
	}

	group_alias = CATSPRINTF(CNULL, "%s%s", GROUP_PREFIX, alias);
	rc = aux_add_alias(group_alias, dn, aliasf, prior, writef);
	free(group_alias);

	return(rc);

}


/*
 *	delete alias with given flags for USER/SYSTEM-file and immediate file writing
 *	return 0 on success, else -1
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */
/***************************************************************
 *
 * Procedure aux_delete_alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_delete_alias(
	char		 *alias,
	AliasFile	  aliasf,
	Boolean		  writef
)

#else

RC aux_delete_alias(
	alias,
	aliasf,
	writef
)
char		 *alias;
AliasFile	  aliasf;
Boolean		  writef;

#endif

{
	register Aliases *aliasmember, *aliasmemberpre;
	register AliasList *aa, *aapre;
	char	*proc = "aux_delete_alias";
	Boolean  found = FALSE;

	if (!alias) {
		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(-1);
	}
	if (aliasf != useralias && aliasf != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return(-1);
	}

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(-1);  /* no alias names read */

	/* Filter */
	if (!pass_filter(aliasf)) {
		aux_add_error(EINVALID, "Filter: selected aliases don't pass", CNULL, 0, proc);
		return(-1);
	}

	/*
         *  Try to find alias in aliaslist->aname fitting to given alias file. 
	 *  If found, chain out. Chain out dname entry, too, if last alias is deleted
         */

	aa = aliaslist;
	aapre = (AliasList * ) 0;
	while (aa)  {
		aliasmember = aa->a;
		aliasmemberpre = (Aliases * ) 0;
		while (aliasmember)  {

			if (!strcmp(aliasmember->aname, alias) && (aliasmember->aliasfile == aliasf))  {
  				if(aliasmemberpre) aliasmemberpre->next = aliasmember->next;
  				else if (aliasmember->next) aa->a = aliasmember->next;
  				else  {
 					if(aapre) aapre->next = aa->next;
 					else aliaslist = aa->next;
  
 					free(aa->dname);
 					free(aa);
  				}
  
				if (writef){
					if(aux_put_AliasList(aliasf) < 0){
						aux_add_error(	LASTERROR,
								"Can't put alias list after deleting alias",
								CNULL, 0, proc);
						return(-1);
					}
				}

				return(0);

			}					
			aliasmemberpre = aliasmember;
			aliasmember = aliasmember->next;
		}
		aapre = aa;
		aa = aa->next;
	}


	return(-1);

}


/***************************************************************
 *
 * Procedure aux_delete_group_alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_delete_group_alias(
	char		 *alias,
	DName		 *dname,
	AliasFile	  aliasf,
	Boolean		  writef
)

#else

RC aux_delete_group_alias(
	alias,
	dname,
	aliasf,
	writef
)
char		 *alias;
DName		 *dname;
AliasFile	  aliasf;
Boolean		  writef;

#endif

{
	register Aliases *aliasmember, *aliasmemberpre;
	register AliasList *aa, *aapre;
	char	*proc = "aux_delete_group_alias", *name;
	Boolean  found = FALSE;

	if (!alias) {
		aux_add_error(EINVALID, "Invalid parameter: alias", CNULL, 0, proc);
		return(-1);
	}
	if (aliasf != useralias && aliasf != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return(-1);
	}

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(-1);  /* no alias names read */

	/* Filter */
	if (!pass_filter(aliasf)) {
		aux_add_error(EINVALID, "Filter: selected aliases don't pass", CNULL, 0, proc);
		return(-1);
	}

	/*
         *  Try to find alias in aliaslist->aname fitting to given alias file. 
	 *  If found, chain out. Chain out dname entry, too, if last alias is deleted
         */

	if(dname) name = aux_DName2Name(dname);

	aa = aliaslist;
	aapre = (AliasList * ) 0;
	while (aa)   {
		aliasmember = aa->a;
		aliasmemberpre = (Aliases * ) 0;
		if(!dname || !strcmp(name, aa->dname)) while (aliasmember)  {

			if (strncmp(aliasmember->aname, GROUP_PREFIX, GROUP_PREFIX_LENGTH) == 0
					&& strcmp(aliasmember->aname + GROUP_PREFIX_LENGTH, alias) == 0
					&& (aliasmember->aliasfile == aliasf))  {
  				if(aliasmemberpre) aliasmemberpre->next = aliasmember->next;
  				else if (aliasmember->next) aa->a = aliasmember->next;
  				else  {
 					if(aapre) aapre->next = aa->next;
 					else aliaslist = aa->next;
  
 					free(aa->dname);
 					free(aa);
  				}
  
  				free(aliasmember->aname);
				free(aliasmember);

				found = TRUE;


			}					
			aliasmemberpre = aliasmember;
			aliasmember = aliasmember->next;
		}
		aapre = aa;
		aa = aa->next;
	}

	if(!found) return(-1);


	if (writef){
		if(aux_put_AliasList(aliasf) < 0){
			aux_add_error(	LASTERROR,
					"Can't put alias list after deleting alias",
					CNULL, 0, proc);
			return(-1);
		}
	}

	return(0);

}



/*
 *	search DNames that contain alias (as substring) belongs and print to file
 *	if alias is NULL, print complete list to file
 *	return always 0
  *
 *	SUPPLEMENTARY filter selection IS considered.
*/

/***************************************************************
 *
 * Procedure aux_fprint_alias2dnames
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_alias2dnames(
	FILE	 *ff,
	char	 *alias
)

#else

RC aux_fprint_alias2dnames(
	ff,
	alias
)
FILE	 *ff;
char	 *alias;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_alias2dnames";


	if (!ff) {
		aux_add_error(EINVALID, "Invalid parameter: ff", CNULL, 0, proc);
		return(-1);
	}
	
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(-1);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
		
			/* Filter */
			if (!pass_filter(aliasmember->aliasfile)) {
				aliasmember = aliasmember->next;
				continue;
			}
		
			if (!alias || strmtch(aliasmember->aname, alias)) {
                                fprintf(ff, "%s --> <%s>\n", aliasmember->aname, aa->dname);
                        }
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(0);
}




/*
 *  	Search alias in aliaslist.
 *  	If found, print aliaslist->dname.
 *  	If alias is NULL, print all DNames
 *	return 0 if aliaslist is available, else -1
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */
/***************************************************************
 *
 * Procedure aux_fprint_alias2dname
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_alias2dname(
	FILE	 *ff,
	char	 *alias
)

#else

RC aux_fprint_alias2dname(
	ff,
	alias
)
FILE	 *ff;
char	 *alias;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_alias2dname";


	if (!ff) {
		aux_add_error(EINVALID, "Invalid parameter: ff", CNULL, 0, proc);
		return(-1);
	}
	
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(-1);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
		aliasmember = aa->a;
		while (aliasmember) {
		
			/* Filter */
			if (!pass_filter(aliasmember->aliasfile)) {
				aliasmember = aliasmember->next;
				continue;
			}
		
			if (!alias || strcmp(aliasmember->aname, alias) == 0) {
                                fprintf(ff, "%s --> <%s>\n", aliasmember->aname, aa->dname);
				return(0);
                        }
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	print all aliases which belong to DName to given file
 *	if DName is NULL, print complete list to file
 *	return always 0
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_fprint_dname2alias
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_fprint_dname2alias(
	FILE	 *ff,
	char	 *dname
)

#else

RC aux_fprint_dname2alias(
	ff,
	dname
)
FILE	 *ff;
char	 *dname;

#endif

{
	register Aliases *aliasmember, *am;
	register AliasList *aa;
	char	*proc = "aux_fprint_dname2alias";


	if (!ff) {
		aux_add_error(EINVALID, "Invalid parameter: ff", CNULL, 0, proc);
		return(-1);
	}
	
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(0);  /* no alias names read */

	aa = aliaslist;
	while (aa) {
        	if (!dname || strmtch(aa->dname, dname)) {
	        	aliasmember = aa->a;
        		while (aliasmember) {
        		
				/* Filter */
				if (!pass_filter(aliasmember->aliasfile)) {
					aliasmember = aliasmember->next;
					continue;
				}
			
                                fprintf(ff, "<%s> --> %s\n", aa->dname, aliasmember->aname);
        			aliasmember = aliasmember->next;
                        }
		}
		aa = aa->next;
	}

	return(0);
}



/*
 *	find pattern in any text element of all alias list entries beginning at entry after name
 *	if end of alias list is reached, continue at top until last found entry is reached
 *	comparisons are non-case-sensitive
 *	return pointer to name on success, else NULL
 *	NOTICE: uses aux_next_AliasList(), same name parameter behaviour
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_search_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_search_AliasList(
	Name	 *name,
	char	 *pattern
)

#else

Name *aux_search_AliasList(
	name,
	pattern
)
Name	 *name;
char	 *pattern;

#endif

{
	char			*proc = "aux_search_AliasList";
	AliasList		*aa, *last_aa;
	register Aliases 	*aliasmember;
	register char		*s, *p, *last_name;



	if (! (p = aux_cpy_ReducedString(pattern)) ) {
		aux_add_error(EINVALID, "Invalid parameter: pattern", CNULL, 0, proc);
		return(CNULL);
	}
	
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	p = str_up(p);

	last_name = aux_next_AliasList(name);	/* entry after last found */
	if (!last_name) return(CNULL);
	if (name) last_aa = last_aliaslist;	/* last found entry */
	else last_aa = (AliasList *)NULL;

	do  {
		aa = last_aliaslist;
		if (! (s = aux_cpy_String(aa->dname)) ) return(CNULL);
		s = str_up(s);
		if (strstr(s, p))  {
			if (p) free(p);
			if (s) free(s);
			return(last_name);
		}
		if (s) free(s);
                aliasmember = aa->a;
                while (aliasmember) {
                
			/* Filter */
			if (!pass_filter(aliasmember->aliasfile)) {
				aliasmember = aliasmember->next;
				continue;
			}
		
			if (! (s = aux_cpy_String(aliasmember->aname)) ) return(CNULL);
			s = str_up(s);
			if (strstr(s, p))  {
				if (p) free(p);
				if (s) free(s);
				return(last_name);
			}
			if (s) free(s);
			aliasmember = aliasmember->next;
		}
		if (!name && !last_aa) last_aa = last_aliaslist;
		if (last_name) free(last_name);
		last_name = aux_next_AliasList("");

	} while (last_aa != last_aliaslist);

	if (p) free(p);
	if (last_name) free(last_name);

	return(CNULL);

}


/*
 *	return TRUE if DName has alias in given alias file, else FALSE
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_alias_chkfile
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_alias_chkfile(
	Name		 *name,
	AliasFile	  aliasf
)

#else

Boolean aux_alias_chkfile(
	name,
	aliasf
)
Name		 *name;
AliasFile	  aliasf;

#endif

{
	char			*proc = "aux_alias_chkfile";
	register AliasList	*aa;
	register Aliases 	*aliasmember;



	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(FALSE);
	}
	if (aliasf != useralias && aliasf != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return(FALSE);
	}

		
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(FALSE);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			aliasmember = aa->a;
			while (aliasmember) {
				if (aliasmember->aliasfile == aliasf) return(TRUE);		
				aliasmember = aliasmember->next;
			}
		}
		aa = aa->next;
	}
	return(FALSE);
}


/*
 *	get next name in AliasList after given name; if end of list is reached, return NULL
 *	if name is empty (""), get name after last found entry, begin with top entry at first time
 *	or if end of list is reached
 *	if name is NULL, reset and get name of top entry
 *	return pointer to allocated string on success, else NULL
 *	local pointer last_aliaslist is set
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_next_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_next_AliasList(
	Name	 *name
)

#else

Name *aux_next_AliasList(
	name
)
Name	 *name;

#endif

{
	char			*proc = "aux_next_AliasList";


	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);
	
	if (name)  {
		if (strcmp(name, "")) {					/* search for name */
			last_aliaslist = aliaslist;
			while (last_aliaslist) {
				if (!strcmp(last_aliaslist->dname, name)) break;
				last_aliaslist = last_aliaslist->next;
			}
			if (!last_aliaslist) return(CNULL); 		/* name not found */
		}
		if (last_aliaslist) last_aliaslist = last_aliaslist->next;
	} else  last_aliaslist = (AliasList *)NULL;

	if (!last_aliaslist) last_aliaslist = aliaslist;

	return(aux_cpy_String(last_aliaslist->dname));
}



/*
 *	get name in AliasList after last found entry, according to filter selection
 *	alias list is always passed through continual from top to end
 *	first entry's name is returned at first call, after end is reached, and when reset is TRUE
 *	if end of list is reached, return NULL, reset to top for next call
 *
 *	independant of aux_search_AliasList() and aux_next_AliasList()
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_alias_nxtname
 *
 ***************************************************************/
#ifdef __STDC__

Name *aux_alias_nxtname(
	Boolean	  reset
)

#else

Name *aux_alias_nxtname(
	reset
)
Boolean	  reset;

#endif

{
	char			*proc = "aux_alias_nxtname";
	
	static AliasList	*la = (AliasList *) 0;



	if (!aliaslist)  {
		aliaslist = get_AliasList();
		la = (AliasList *) 0;
	}
	if (!aliaslist) return(CNULL);
	if (!la || reset) la = aliaslist;
	else la = la->next;

	if (!la)  {
		la = (AliasList *) 0;
		return(CNULL);
	} else return(aux_cpy_String(la->dname));
}


/*
 *	get all aliases of name's entry in Users- OR System-alias list
 *	return NULL-terminated string including all aliases separated by ':'
 *	return CNULL if no such alias is stored
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_alias_getallf
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_alias_getallf(
	char	 	*name,
	AliasFile	aliasf
)

#else

char *aux_alias_getallf(
	name,
	aliasf
)
char	 *name;
AliasFile	  aliasf;

#endif

{
	char			*proc = "aux_alias_getallf";
	AliasList		*aa;
	register Aliases	*aliasmember;
	char			*alias_string;
	

	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(CNULL);
	}
	if (aliasf != systemalias && aliasf != useralias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return(CNULL);
	}
	
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			if (! (alias_string = (char *)malloc(1)) ) goto malloc_err;
			*alias_string = '\0';
			aliasmember = aa->a;
			while (aliasmember) {
				/* all aliases or User/System alias selected */
				if (aliasmember->aliasfile == aliasf) {		
					if (strcmp(alias_string, "")) strcat(alias_string, ":");
					if (! (alias_string = (char *)realloc(alias_string,
							strlen(alias_string) + strlen(aliasmember->aname) + 2)) )
						goto malloc_err;
					strcat(alias_string, aliasmember->aname);
				}
				aliasmember = aliasmember->next;
			}
			return(alias_string);
		}
		aa = aa->next;
	}

	return(CNULL);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(CNULL);

}


/*
 *	get all aliases of name's entry
 *	return NULL-terminated string including all aliases separated by ':'
 *	return CNULL if no such alias is stored
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_alias_getall
 *
 ***************************************************************/
#ifdef __STDC__

char *aux_alias_getall(
	char	 *name
)

#else

char *aux_alias_getall(
	name
)
char	 *name;

#endif

{
	char			*proc = "aux_alias_getall";
	AliasList		*aa;
	register Aliases	*aliasmember;
	char			*alias_string;
	

	if (!name) {
		aux_add_error(EINVALID, "Invalid parameter: name", CNULL, 0, proc);
		return(CNULL);
	}
		
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(CNULL);

	aa = aliaslist;
	while (aa)  {
		if (!strcmp(aa->dname, name))  {
			if (! (alias_string = (char *)malloc(1)) ) goto malloc_err;
			*alias_string = '\0';
			aliasmember = aa->a;
			while (aliasmember) {
			
				/* Filter */
				if (!pass_filter(aliasmember->aliasfile)) {
					aliasmember = aliasmember->next;
					continue;
				}
				
				if (strcmp(alias_string, "")) strcat(alias_string, ":");
				if (! (alias_string = (char *)realloc(alias_string,
						strlen(alias_string) + strlen(aliasmember->aname) + 2)) )
					goto malloc_err;
				strcat(alias_string, aliasmember->aname);
				aliasmember = aliasmember->next;
			}
			return(alias_string);
		}
		aa = aa->next;
	}

	return(CNULL);

malloc_err:
	aux_add_error(EMALLOC, "", CNULL, 0, proc);
	return(CNULL);

}



/*
 *	read alias files (via get_AliasList())
 *	return TRUE if OK, else FALSE
 *
 *	INITIAL filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_get_AliasList()
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_get_AliasList(
)

#else

Boolean aux_get_AliasList(
)

#endif

{
	char	*proc = "aux_get_AliasList";


	af_pse_reset(AliasList_name);
	aux_reset_AliasList();
	aliaslist = get_AliasList();
	if (aliaslist) return(TRUE);
	else return(FALSE);

}


/*
 *	Reset static aliaslist cache (used by af_pse_reset())
 *
 *	filter selection is NOT considered, nor is the filter reset!
 */

/***************************************************************
 *
 * Procedure aux_reset_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

void aux_reset_AliasList(
)

#else

void aux_reset_AliasList(
)

#endif

{
	char	*proc = "aux_reset_AliasList";


	if (aliaslist) free_AliasList();

}





/*
 *	read alias list from USER- and/or SYSTEM-aliasfile (according to filter_*_aliases)
 *	DNames are sorted in alphabetical order, aliases are inserted from left-to-right in a FIFO-list
 *	USER-aliases are inserted prior to SYSTEM-aliases (affects transforming routines aux_this2that())
 *	reset last_aliaslist to NULL (used by aux_find_AliasList(), aux_alias_next())
 *	return pointer to first entry
 *
 *	The static systemfile_write_protection is set to TRUE if .af-alias cannot be read
 *	or if alias usage is prohibitted (i.e. af_use_alias == FALSE).
 *
 *	The flags got_system_aliases_once and got_user_aliases_once are set to TRUE on first time
 *	depending on the success of reading them and the INITIAL filter setting.
 *
 *	INITIAL filter selection IS considered.
 */


/***************************************************************
 *
 * Procedure get_AliasList()
 *
 ***************************************************************/
#ifdef __STDC__

static AliasList *get_AliasList(
)

#else

static AliasList *get_AliasList(
)

#endif

{
	AliasList   		* alist = (AliasList *)0;
	AliasList		* alist_from_pse;
	register AliasList 	* aa, * aa_prev, * bb, * bb_prev;
	register Aliases	* aliasmember, * am;
	char	      		* aliasfilepath;
	FILE        		* aff;
	int	      		  dir;
	OctetString 		* asn1_aliaslist;
	Boolean                   tmp_access_dir;
	VerificationResult      * tmp_verifresult;

	char	    		* proc = "get_AliasList()";


	/*
         *  Read PSE-object AliasList and/or secude/.af-alias into alist
         */

	if (!af_use_alias) {
		systemfile_write_protection = TRUE;
		return((AliasList *)0);
	}
	systemfile_write_protection = FALSE;

	/* get filter setting */
	filter_aliases = aux_alias_filter();

	/* Filter: no system aliases? */
	if (!filter_system_aliases) goto read_user_aliases;

	/* Read SYSTEM-aliasfile which is already sorted */
	if(!(aliasfilepath = aux_cat_paths(ALIASDIR, ALIASFILE))) {
		AUX_ADD_ERROR;
		return ((AliasList *)0);
	}

	if ((aff = fopen(aliasfilepath, "r"))) {

		if (accept_alias_without_verification == TRUE)
			asn1_aliaslist = aux_file2OctetString(aliasfilepath);
		else {
			tmp_access_dir = af_access_directory;
			af_access_directory = FALSE;
			tmp_verifresult = verifresult;
			verifresult = (VerificationResult *)0;
			asn1_aliaslist = af_SignedFile2OctetString(aliasfilepath);
			aux_free_VerificationResult(&verifresult);
			verifresult = tmp_verifresult;
			af_access_directory = tmp_access_dir;
		}

		if (! asn1_aliaslist) {
			aux_add_error(LASTERROR, "Can't get alias list", CNULL, 0, proc);
			fclose(aff);
			systemfile_write_protection = TRUE;
			goto read_user_aliases;
		}

		aa = d_AliasList(asn1_aliaslist);
		aux_free_OctetString(&asn1_aliaslist);

		if (! aa)  {
			aux_add_error(EDECODE, "Can't decode Alias list", CNULL, 0, proc);
			free(aliasfilepath);
			return ((AliasList *)0);
		}

		alist = aa;
		
		got_system_aliases_once = TRUE;

		fclose(aff);
	}


	/* Read USER-aliasfile from PSE and sort it into SYSTEM-aliasfile */
read_user_aliases:

	free(aliasfilepath);


	/* Filter: no user aliases */
	if (!filter_user_aliases) goto end_get_aliases;
	
	alist_from_pse = af_pse_get_AliasList();
	if (alist_from_pse) {
		if (! alist)
			alist = alist_from_pse;
		else  {
			/*
			 *	insert USER-aliases
			 *	(system- and user-entries are both sorted by DNames in add_alias() routines)
			 */
			aa = alist_from_pse;
			bb = alist;
			while (aa)  {
				while (bb && strcmp(aa->dname, bb->dname) > 0)  {	
					/* find insertion point */
					bb_prev = bb;
					bb = bb->next;
				}
				if (bb)  {
					if (strcmp(aa->dname, bb->dname) == 0)  {
						/* DName exists: chain in aliases on top,
						   free rest of double DName entry 	  */
						aliasmember = aa->a;
						while (aliasmember)  {
							am = aliasmember->next;
							aliasmember->next = bb->a;
							bb->a = aliasmember;
							aliasmember = am;
						}
						aa_prev = aa;
						aa = aa->next;
						free(aa_prev->dname);
						free(aa_prev);
					}
					else  {
						/* chain in new DName entry */
						aa_prev = aa;
						aa = aa->next;
						if (bb == alist)  {
							aa_prev->next = alist;
							alist = aa_prev;
							bb_prev = aa_prev;
						}
						else  {
							aa_prev->next = bb_prev->next;
							bb_prev->next = aa_prev;
							bb_prev = aa_prev;
						}
					}
				}
				else  {
					/* append all remaining entries, their DNames are "greater" */
					aa_prev = aa;
					aa = aa->next;
					aa_prev->next = bb_prev->next;
					bb_prev->next = aa_prev;
					bb_prev = aa_prev;
				}
			}
		}
	} 
	else aux_free_error();
	
	got_user_aliases_once = TRUE;

end_get_aliases:

	last_aliaslist = (AliasList *) 0;

	return(alist);
}




/*
 *	Write all fitting alias list entries to USER/SYSTEM-aliasfile.
 *	If there is no more alias in the useralias / systemalias file, 
 * 	the PSE-object AliasList / the three system alias files are deleted
 *	If systemfile_write_protection is TRUE (set by get_AliasList()),
 *	or an error occured, -1 is returned.
 *
 *	SUPPLEMENTARY filter selection IS considered.
 */

/***************************************************************
 *
 * Procedure aux_put_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

RC aux_put_AliasList(
	AliasFile	  aliasf
)

#else

RC aux_put_AliasList(
	aliasf
)
AliasFile	  aliasf;

#endif

{
	OctetString 	   * asn1_aliaslist;
	char 	 	   * afile, asigfile[256], actffile[256];
	AliasList	   * aa;
	PSESel		   * pse_sel;
	AlgId 		   * signAI;
	int		     rc;

	char		   * proc = "aux_put_AliasList";


	if (aliasf != useralias && aliasf != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return(-1);
	}

	if (aliasf == systemalias && systemfile_write_protection) {
		aux_add_error(EINVALID, "System alias write protection is on", CNULL, 0, proc);
		return(-1);
	}
	
	/* Filter */
	if (!pass_filter(aliasf)) {
		aux_add_error(EINVALID, "Filter: selected aliases don't pass", CNULL, 0, proc);
		return(-1);
	}

	if(!(afile = aux_cat_paths(ALIASDIR, ALIASFILE))) {
		AUX_ADD_ERROR;
		return (0);
	}
	strcpy(asigfile, afile);
	strcat(asigfile, EXT_SIGNATURE);
	strcpy(actffile, afile);
	strcat(actffile, EXT_CERTIFICATE);


	if (! aliaslist || !(aa = aux_select_AliasList(aliasf))) {
	
		/*
		 * Kill empty System-/User-aliaslist
		 * Prevent them from being killed accidently by calling auf_put_AliasList()
		 * before get_AliasList()
		 */
		if (aliasf == useralias  && (got_user_aliases_once || kill_aliases_without_reading)) {
		/***	if (pse_sel = af_pse_open(AliasList_OID, FALSE)) {
				rc = sec_delete(pse_sel);
				af_pse_reset(AliasList_name);
				aux_free_PSESel(&pse_sel);
			}						***/
			free(afile);
			rc = af_pse_delete(AliasList_name);
			if (rc) AUX_ADD_ERROR;
			return(rc);
		}
		if (aliasf == systemalias  && (got_system_aliases_once || kill_aliases_without_reading)) {
			unlink(afile);
			unlink(asigfile);
			unlink(actffile);
			free(afile);
			return(0);
		}
	}

	if (aliasf == useralias) {
		free(afile);
		if (af_pse_update_AliasList(aa) < 0){
			aux_add_error(EWRITEPSE, "Can't put alias list", CNULL, 0, proc);
			return(- 1);
		}
		return(0);
	}

	asn1_aliaslist = e_AliasList(aa);
	if (! asn1_aliaslist) {
		aux_add_error(EENCODE, "Can't encode alias list", CNULL, 0, proc);
		free(afile);
		return(- 1);
	} 

	rc = af_OctetString2SignedFile(afile, asn1_aliaslist, TRUE, NULLALGID);
	if (rc < 0) {
		aux_add_error(LASTERROR, "Can't put alias list", CNULL, 0, proc);
		free(afile);
		return(- 1);
	}

	free(afile);
	
	aux_free_AliasList(&aa);
		
	return(0);
}
	 


/*
 *	check alias list for consistency
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure aux_check_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_check_AliasList(
	FILE	 *ff
)

#else

Boolean aux_check_AliasList(
	ff
)
FILE	 *ff;

#endif

{
	char			*proc = "aux_check_AliasList";
	register Aliases	*aliasmember, *am;
	register AliasList 	*aa, *bb;
	Boolean			ret = TRUE;
	Boolean			found_first = FALSE;
	Boolean			found;


	if (!ff) {
		aux_add_error(EINVALID, "Invalid parameter: ff", CNULL, 0, proc);
		return(FALSE);
	}
	
	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return(TRUE);	/* No data => no invalid data !? */
		
	aa = aliaslist;
	while (aa)  {
		aliasmember = aa->a;
		while (aliasmember)  {
			found = FALSE;
			bb = aliaslist;
			while (bb)  {
				am = bb->a;
				while (am)  {
					if ((am->aname != aliasmember->aname) && (!strcmp(am->aname, aliasmember->aname))
							&& (strncmp(am->aname, GROUP_PREFIX, GROUP_PREFIX_LENGTH))) {
						if (!found_first)  {
							fprintf(ff, "aux_check_AliasList: There are double aliases.\n");
							fprintf(ff, "----------------------------------------------\n");
							fprintf(ff, " File  : <Alias>  =>  DName\n");
							fprintf(ff, "----------------------------------------------\n");
							found_first = TRUE;
						}
						fprintf(ff, "%s   <%s> = \"%s\"\n",
							aliasmember->aliasfile == useralias ? " USER " : "SYSTEM",
							aliasmember->aname, aa->dname);
						ret = FALSE;
						found = TRUE;
						break;
					}
					am = am->next;
				}
				if (found) break;

				bb = bb->next;
			}
			aliasmember = aliasmember->next;
		}
		aa = aa->next;
	}


	return(ret);

}



/*
 *	check systemfile for write protection
 *	(set by get_AliasList())
 *
 *	INITIAL filter selection is considered if aliaslist does not exist
 */

/***************************************************************
 *
 * Procedure aux_alias_writeprotection
 *
 ***************************************************************/
#ifdef __STDC__

Boolean aux_alias_writeprotection(
)

#else

Boolean aux_alias_writeprotection(
)

#endif

{
	char			*proc = "aux_alias_writeprotection";


        
	if (!aliaslist) aliaslist = get_AliasList();

	return(systemfile_write_protection);

}


/*
 *	Return a copy of the selected part of aliaslist
 *	(i.e. useralias/systemalias)
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
*/

/***************************************************************
 *
 * Procedure aux_select_AliasList
 *
 ***************************************************************/

#ifdef __STDC__

AliasList *aux_select_AliasList(
	AliasFile	  aliasf
)

#else

AliasList *aux_select_AliasList(
	aliasf
)
AliasFile aliasf;

#endif

{
	AliasList	 * aa, * bb, * cc;
	Aliases		 * aliasmember, * tmp_aliasmember;
	int		   first_a_flag, aa_equal_bb_flag;
	char	         *proc = "aux_select_AliasList";


	if(aliasf != useralias && aliasf != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: aliasf", CNULL, 0, proc);
		return ((AliasList *)0);
	}

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return ((AliasList *)0);

	aa = bb = (AliasList * )malloc(sizeof(AliasList));
	if (! aa){
		aux_add_error(EMALLOC, "aa", CNULL, 0, proc);
		return ((AliasList *)0);
	}

	bb->dname = CNULL;
	bb->next = (AliasList * ) 0;
	bb->a = (Aliases * ) 0;

	cc = aliaslist;

	aa_equal_bb_flag = 1;

	while (cc) {
		aliasmember = cc->a;
		first_a_flag = 1;
		while (aliasmember) {
			if(aliasmember->aliasfile == aliasf) {
				if (first_a_flag) {
					if (! aa_equal_bb_flag) {
						bb->next = (AliasList * )malloc(sizeof(AliasList));
						bb = bb->next;
					}
					first_a_flag = aa_equal_bb_flag = 0;
					bb->a = tmp_aliasmember = (Aliases * )malloc(sizeof(Aliases));
					bb->dname = aux_cpy_Name(cc->dname);
					bb->next = (AliasList * ) 0;
				}
				else {
					tmp_aliasmember->next = (Aliases * )malloc(sizeof(Aliases));
					tmp_aliasmember = tmp_aliasmember->next;
				}
				tmp_aliasmember->aname = aux_cpy_Name(aliasmember->aname);
				tmp_aliasmember->aliasfile = aliasmember->aliasfile;
				tmp_aliasmember->next = (Aliases * ) 0;
			}
			aliasmember = aliasmember->next;
		}
		cc = cc->next;
	}

	if(!aa->dname){
		/* no entries of type 'aliasf' found */
		aux_free_AliasList(&aa);
		
		return((AliasList *)0);
	}

	return(aa);
}


/***************************************************************
 *
 * Procedure aux_filter_AliasList
 *
 ***************************************************************/

/*
 * Get/Select only the User- OR System alias entries from aliaslist.
 * 
 * Returns TRUE if the selected part could be loaded, else FALSE
 *
 *
 * INITIAL filter selection:
 *
 * If called before the first alias operation or before aux_get_AliasList(),
 * only the selected part is READ;
 * >>> ALL <<< alias operations are affected.
 *
 *
 * SUPPLEMENTARY filter selection:
 *
 * If called after the first alias operation or after aux_get_AliasList()
 * the >>> FOLLOWING <<< operations on the local (AliasList *)aliaslist
 * CONSIDER only the selected part:
 *
 *		aux_alias2Name()
 *		aux_alias2DName()
 *		aux_Name2alias()
 *		aux_Name2NameOrAlias()
 *		aux_DName2alias()
 *		aux_DName2NameOrAlias()	
 *		aux_add_alias_name()
 *		aux_add_alias()
 *		aux_delete_alias()
 *		aux_fprint_alias2dname()
 *		aux_fprint_dname2alias()
 *		aux_search_AliasList()
 *		aux_alias_getall()
 *		aux_put_AliasList()
 *
 * Only the selected part can be changed (add, delete) or updated (put).
 *
 * To reset the filter, call aux_filter_AliasList(TRUE, TRUE) or
 * aux_filter_AliasList(FALSE, FALSE), then aux_get_AliasList()
 * to get the unfiltered aliaslist.
 */

#ifdef __STDC__

Boolean aux_filter_AliasList(
	Boolean	  user_aliases,
	Boolean	  system_aliases
)

#else

Boolean aux_filter_AliasList(
	user_aliases,
	system_aliases
)
Boolean	  user_aliases;
Boolean	  system_aliases;

#endif

{
	char	         * proc = "aux_filter_AliasList";


	filter_user_aliases = user_aliases;
	filter_system_aliases = system_aliases;
	if (user_aliases == system_aliases) filter_user_aliases = filter_system_aliases = TRUE;
	
	filter_aliases = aux_alias_filter();

	if (!aliaslist) aliaslist = get_AliasList();
	if (!aliaslist) return (FALSE);
	
	return(TRUE);
}


/***************************************************************
 *
 * Procedure aux_alias_filter
 *
 ***************************************************************/

/*
 * Returns alias filter setting:
 *	systemalias: only system aliases pass filter
 *	useralias: only user aliases pass filter
 *	notstored: both system and user aliases pass (no filter)
 */

#ifdef __STDC__

AliasFile aux_alias_filter(
)

#else

AliasFile aux_alias_filter(
)

#endif

{
	char	         * proc = "aux_alias_filter";

	
	if (filter_system_aliases == filter_user_aliases)
	
		return(notstored);
		
	else if (filter_system_aliases)
	
		return(systemalias);
		
	else
		return(useralias);
}



/***************************************************************
 *
 * Procedure pass_filter
 *
 ***************************************************************/

/*
 * Returns TRUE if given alias file passes filter, else FALSE
 */

#ifdef __STDC__

static Boolean pass_filter(
	AliasFile afile
)

#else

static Boolean pass_filter(
	afile
)
AliasFile afile;

#endif

{
	char	         * proc = "pass_filter";

	
	if (afile != useralias && afile != systemalias) {
		aux_add_error(EINVALID, "Invalid parameter: afile", CNULL, 0, proc);
		return(FALSE);
	}

	if (filter_aliases == notstored || filter_aliases == afile)
	
		return(TRUE);
		
	else
		return(FALSE);
}




/*
 *	free local alias list entries, set pointer to first entry to NULL
 *
 *	SUPPLEMENTARY filter selection is NOT considered.
 */

/***************************************************************
 *
 * Procedure free_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

static void free_AliasList(
)

#else

static void free_AliasList(
)

#endif

{

	register Aliases *aliasmember, *am;
	register AliasList *aa, *bb;
	char	*proc = "free_AliasList";

        
        /*
         *  free alist
         */

        if(!aliaslist) return;
        aa = aliaslist;
        while (aa) {
                aliasmember = aa->a;
                while (aliasmember) {
                        free(aliasmember->aname);
                        am = aliasmember->next;
                        free(aliasmember);
                        aliasmember = am;
                }
                free(aa->dname);
                bb = aa->next;
                free(aa);
                aa = bb;
        }
	aliaslist = (AliasList *) 0;
}





/*
 *	search substring b in string a
 *	return pointer to character in a after first substring b found in a, else NULL
 */

/***************************************************************
 *
 * Procedure strmtch
 *
 ***************************************************************/
#ifdef __STDC__

static char *strmtch(
	char	 *a,
	char	 *b
)

#else

static char *strmtch(
	a,
	b
)
char	 *a;
char	 *b;

#endif

{
	char	*proc = "strmtch";
	register char *aa, *bb;


	if (!a || !b) {
		aux_add_error(EINVALID, "Invalid parameter: a or b", CNULL, 0, proc);
		return(CNULL);
	}

	while (*a) {
		aa = a;
		bb = b;
		while (*aa) {
			if(*aa != *bb) break;
                        bb++;
			if(*bb == '\0') return(aa + 1);
                        aa++;
		}
		a++;   
	}
	return (CNULL);
}








