#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/vnode.h>
#include <sys/mount.h>
#include <sys/namei.h>
#include <sys/malloc.h>
#include <sys/buf.h>
#include <miscfs/tcfs/tcfs.h>
#include "tcfs_rw.h"
#ifndef _TCFS_KEYTAB_H_
#include "tcfs_keytab.h"
#endif
#include "tcfs_cmd.h"
#include "tcfs_cipher.h"


int tcfs_exec_cmd(struct tcfs_mount *mp, struct tcfs_args *req)
{
	void *ks;
	int i;
	

	switch (req->cmd)
	{
	 	case TCFS_PUT_UIDKEY:
			ks=TCFS_INIT_KEY(mp,req->tcfs_key);
			if(!ks)
				return ENOMEM;
				

			   i=tcfs_keytab_push_uid(mp->tcfs_uid_kt,req->user,ks);
			   return i;

	 	case TCFS_RM_UIDKEY:
			return tcfs_keytab_rm_uid(mp->tcfs_uid_kt,req->user);

	 	case TCFS_PUT_PIDKEY:
			ks=TCFS_INIT_KEY(mp,req->tcfs_key);
			if(!ks)
				return ENOMEM;
			return 
			   tcfs_keytab_push_pid(mp->tcfs_uid_kt,req->user,req->proc,ks);

	 	case TCFS_RM_PIDKEY:
			return tcfs_keytab_rm_pid(mp->tcfs_uid_kt,req->user,req->proc);
		case TCFS_PUT_GIDKEY:
			return tcfs_keytab_push_gid(mp,mp->tcfs_gid_kt,req->user,req->group,req->treshold,req->tcfs_key);

		case TCFS_RM_GIDKEY:
			return tcfs_keytab_rm_gid(mp->tcfs_gid_kt,req->user,req->group);

	}
	return 0;
}
	
void *tcfs_getukey(struct ucred *c, struct proc *p, struct vnode *vp)
{
	tcfs_keytab_node *n;

	n=tcfs_keytab_fetch_uid(TCFS_VP2UKT(vp),c->cr_uid);

	if(n)
		return n->kn_key;
	else
		{
		return (void*)NULL;
		}
}

void *tcfs_getpkey(struct ucred *c, struct proc *p, struct vnode *vp)
{
	tcfs_keytab_node *n;
	struct proc *cp;

	if(!p)
		cp=curproc;
	else
		cp=p;
	
	n=tcfs_keytab_fetch_pid(TCFS_VP2UKT(vp),c->cr_uid,cp->p_pid);

	if(n)
		return n->kn_key;
	else
		return (void*)NULL;
}

void *tcfs_getgkey(struct ucred *c, struct proc *p, struct vnode *vp)
{
	tcfs_keytab_node *n;

	n=tcfs_keytab_fetch_gid(TCFS_VP2GKT(vp),c->cr_gid);

	if(n)
		return n->kn_key;
	else
		return (void*)NULL;
}

