/*
 *	$Source: /usr2/luicat/tcfs/RCS/tcfs_vnops.c,v $
 *	$State: Exp $
 *	$Revision: 1.1 $
 *	$Author: luicat $
 *	$Date: 1998/07/12 11:54:14 $
 *	$Locker:  $
 */
/* RCSHEADERENDSHERE */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/vnode.h>
#include <sys/mount.h>
#include <sys/namei.h>
#include <sys/malloc.h>
#include <sys/buf.h>
#include <miscfs/tcfs/tcfs.h>
#include "kdes.h"


int tcfs_bug_bypass = 0;   /* for debugging: enables bypass printf'ing */

int	tcfs_bypass __P((void *));
int	tcfs_getattr __P((void *));
int	tcfs_setattr __P((void *));
int	tcfs_inactive __P((void *));
int	tcfs_reclaim __P((void *));
int	tcfs_print __P((void *));
int	tcfs_strategy __P((void *));
int	tcfs_bwrite __P((void *));
int	tcfs_lock __P((void *));
int	tcfs_unlock __P((void *));
int	tcfs_islocked __P((void *));
int	tcfs_read __P((void *));
int	tcfs_readdir __P((void *));
int	tcfs_write __P((void *));
int	tcfs_create __P((void *));
int	tcfs_mknod __P((void *));
int	tcfs_mkdir __P((void *));
int	tcfs_link __P((void *));
int	tcfs_symlink __P((void *));
int	tcfs_rename __P((void *));
int	tcfs_lookup __P((void *));

int
tcfs_bypass(v)
	void *v;
{
	struct vop_generic_args /* {
		struct vnodeop_desc *a_desc;
		<other random data follows, presumably>
	} */ *ap = v;
	register struct vnode **this_vp_p;
	int error;
	struct vnode *old_vps[VDESC_MAX_VPS];
	struct vnode **vps_p[VDESC_MAX_VPS];
	struct vnode ***vppp;
	struct vnodeop_desc *descp = ap->a_desc;
	int reles, i;

	if (tcfs_bug_bypass)
		printf ("tcfs_bypass: %s\n", descp->vdesc_name);

#ifdef SAFETY
	/*
	 * We require at least one vp.
	 */
	if (descp->vdesc_vp_offsets == NULL ||
	    descp->vdesc_vp_offsets[0] == VDESC_NO_OFFSET)
		panic ("tcfs_bypass: no vp's in map.\n");
#endif

	/*
	 * Map the vnodes going in.
	 * Later, we'll invoke the operation based on
	 * the first mapped vnode's operation vector.
	 */
	reles = descp->vdesc_flags;
	for (i = 0; i < VDESC_MAX_VPS; reles >>= 1, i++) {
		if (descp->vdesc_vp_offsets[i] == VDESC_NO_OFFSET)
			break;   /* bail out at end of list */
		vps_p[i] = this_vp_p = 
			VOPARG_OFFSETTO(struct vnode**,descp->vdesc_vp_offsets[i],ap);
		/*
		 * We're not guaranteed that any but the first vnode
		 * are of our type.  Check for and don't map any
		 * that aren't.  (We must always map first vp or vclean fails.)
		 */
		if (i && (*this_vp_p == NULLVP ||
		    (*this_vp_p)->v_op != tcfs_vnodeop_p)) {
			old_vps[i] = NULLVP;
		} else {
			old_vps[i] = *this_vp_p;
			*(vps_p[i]) = TCFSVPTOLOWERVP(*this_vp_p);
			/*
			 * XXX - Several operations have the side effect
			 * of vrele'ing their vp's.  We must account for
			 * that.  (This should go away in the future.)
			 */
			if (reles & 1)
				VREF(*this_vp_p);
		}
			
	}

	/*
	 * Call the operation on the lower layer
	 * with the modified argument structure.
	 */
	error = VCALL(*(vps_p[0]), descp->vdesc_offset, ap);

	/*
	 * Maintain the illusion of call-by-value
	 * by restoring vnodes in the argument structure
	 * to their original value.
	 */
	reles = descp->vdesc_flags;
	for (i = 0; i < VDESC_MAX_VPS; reles >>= 1, i++) {
		if (descp->vdesc_vp_offsets[i] == VDESC_NO_OFFSET)
			break;   /* bail out at end of list */
		if (old_vps[i] != NULLVP) {
			*(vps_p[i]) = old_vps[i];
			if (reles & 1) {
				/* they really vput them, so we must drop
				   our locks (but mark underneath as
				   unlocked first).
				   Beware of vnode duplication--put it once,
				   and rele the rest.  Check this 
				   by looking at our upper flag. */
			    if (VTOTCFS(*(vps_p[i]))->tcfs_flags & TCFS_LOCKED) {
				    VTOTCFS(*(vps_p[i]))->tcfs_flags &= ~TCFS_LLOCK;
				    vput(*(vps_p[i]));
			    } else
				    vrele(*(vps_p[i]));
			}
		}
	}

	/*
	 * Map the possible out-going vpp
	 * (Assumes that the lower layer always returns
	 * a VREF'ed vpp unless it gets an error.)
	 */
	if (descp->vdesc_vpp_offset != VDESC_NO_OFFSET &&
	    !(descp->vdesc_flags & VDESC_NOMAP_VPP) &&
	    !error) {
		/*
		 * XXX - even though some ops have vpp returned vp's,
		 * several ops actually vrele this before returning.
		 * We must avoid these ops.
		 * (This should go away when these ops are regularized.)
		 */
		if (descp->vdesc_flags & VDESC_VPP_WILLRELE)
			goto out;
		vppp = VOPARG_OFFSETTO(struct vnode***,
				 descp->vdesc_vpp_offset,ap);
		/*
		 * This assumes that **vppp is a locked vnode (it is always
		 * so as of this writing, NetBSD-current 1995/02/16)
		 */
		/*
		 * (don't want to lock it if being called on behalf
		 * of lookup--it plays weird locking games depending
		 * on whether or not it's looking up ".", "..", etc.
		 */
		error = tcfs_node_create(old_vps[0]->v_mount, **vppp, *vppp,
					 descp == &vop_lookup_desc ? 0 : 1);
	}

 out:
	return (error);
}



int
tcfs_inactive(v)
	void *v;
{
	/*
	 * Do nothing (and _don't_ bypass).
	 * Wait to vrele lowervp until reclaim,
	 * so that until then our tcfs_node is in the
	 * cache and reusable.
	 *
	 * NEEDSWORK: Someday, consider inactive'ing
	 * the lowervp and then trying to reactivate it
	 * with capabilities (v_id)
	 * like they do in the name lookup cache code.
	 * That's too much work for now.
	 */
	return (0);
}

int
tcfs_reclaim(v)
	void *v;
{
	struct vop_reclaim_args /* {
		struct vnode *a_vp;
	} */ *ap = v;
	struct vnode *vp = ap->a_vp;
	struct tcfs_node *xp = VTOTCFS(vp);
	struct vnode *lowervp = xp->tcfs_lowervp;

	/*
	 * Note: in vop_reclaim, vp->v_op == dead_vnodeop_p,
	 * so we can't call VOPs on ourself.
	 */
	/* After this assignment, this node will not be re-used. */
	xp->tcfs_lowervp = NULL;
	LIST_REMOVE(xp, tcfs_hash);
	FREE(vp->v_data, M_TEMP);
	vp->v_data = NULL;
	vrele (lowervp);
	return (0);
}


int
tcfs_print(v)
	void *v;
{
	struct vop_print_args /* {
		struct vnode *a_vp;
	} */ *ap = v;
	register struct vnode *vp = ap->a_vp;
	register struct tcfs_node *nn = VTOTCFS(vp);

	printf ("\ttag VT_TCFS, vp=%p, lowervp=%p\n", vp, TCFSVPTOLOWERVP(vp));
#ifdef DIAGNOSTIC
	printf("%s%s owner pid %d retpc %p retret %p\n",
	    (nn->tcfs_flags & TCFS_LOCKED) ? "(LOCKED) " : "",
	    (nn->tcfs_flags & TCFS_LLOCK) ? "(LLOCK) " : "",
	    nn->tcfs_pid, nn->tcfs_lockpc, nn->tcfs_lockpc2);
#else
	printf("%s%s\n",
	    (nn->tcfs_flags & TCFS_LOCKED) ? "(LOCKED) " : "",
	    (nn->tcfs_flags & TCFS_LLOCK) ? "(LLOCK) " : "");
#endif
	vprint("tcfs lowervp", TCFSVPTOLOWERVP(vp));
	return (0);
}


/*
 * XXX - vop_strategy must be hand coded because it has no
 * vnode in its arguments.
 * This goes away with a merged VM/buffer cache.
 */
int
tcfs_strategy(v)
	void *v;
{
	struct vop_strategy_args /* {
		struct buf *a_bp;
	} */ *ap = v;
	struct buf *bp = ap->a_bp;
	int error;
	struct vnode *savedvp;

	savedvp = bp->b_vp;
	bp->b_vp = TCFSVPTOLOWERVP(bp->b_vp);

	error = VOP_STRATEGY(bp);

	bp->b_vp = savedvp;

	return (error);
}


/*
 * XXX - like vop_strategy, vop_bwrite must be hand coded because it has no
 * vnode in its arguments.
 * This goes away with a merged VM/buffer cache.
 */
int
tcfs_bwrite(v)
	void *v;
{
	struct vop_bwrite_args /* {
		struct buf *a_bp;
	} */ *ap = v;
	struct buf *bp = ap->a_bp;
	int error;
	struct vnode *savedvp;

	savedvp = bp->b_vp;
	bp->b_vp = TCFSVPTOLOWERVP(bp->b_vp);

	error = VOP_BWRITE(bp);

	bp->b_vp = savedvp;

	return (error);
}

/*
 * We need a separate tcfs lock routine, to avoid deadlocks at reclaim time.
 * If a process holds the lower-vnode locked when it tries to reclaim
 * the tcfs upper-vnode, _and_ tcfs_bypass is used as the locking operation,
 * then a process can end up locking against itself.
 * This has been observed when a tcfs mount is set up to "tunnel" beneath a
 * union mount (that setup is useful if you still wish to be able to access
 * the non-union version of either the above or below union layer)
 */
int
tcfs_lock(v)
	void *v;
{
	struct vop_lock_args *ap = v;
	struct vnode *vp = ap->a_vp;
	struct tcfs_node *nn;

#ifdef TCFS_DIAGNOSTIC
	vprint("tcfs_lock_e", ap->a_vp);
	printf("retpc=%p, retretpc=%p\n", RETURN_PC(0), RETURN_PC(1));
#endif
start:
	while (vp->v_flag & VXLOCK) {
		vp->v_flag |= VXWANT;
		tsleep((caddr_t)vp, PINOD, "tcfslock1", 0);
	}

	nn = VTOTCFS(vp);

	if ((nn->tcfs_flags & TCFS_LLOCK) == 0 &&
	    (vp->v_usecount != 0)) {
		/*
		 * only lock underlying node if we haven't locked it yet
		 * for tcfs ops, and our refcount is nonzero.  If usecount
		 * is zero, we are probably being reclaimed so we need to
		 * keep our hands off the lower node.
		 */
		VOP_LOCK(nn->tcfs_lowervp);
		nn->tcfs_flags |= TCFS_LLOCK;
	}

	if (nn->tcfs_flags & TCFS_LOCKED) {
#ifdef DIAGNOSTIC
		if (curproc && nn->tcfs_pid == curproc->p_pid &&
		    nn->tcfs_pid > -1 && curproc->p_pid > -1) {
			vprint("self-lock", vp);
			panic("tcfs: locking against myself");
		}
#endif
		nn->tcfs_flags |= TCFS_WANTED;
		tsleep((caddr_t)nn, PINOD, "tcfslock2", 0);
		goto start;
	}

#ifdef DIAGNOSTIC
	if (curproc)
		nn->tcfs_pid = curproc->p_pid;
	else
		nn->tcfs_pid = -1;
	nn->tcfs_lockpc = RETURN_PC(0);
	nn->tcfs_lockpc2 = RETURN_PC(1);
#endif

	nn->tcfs_flags |= TCFS_LOCKED;
	return (0);
}

int
tcfs_unlock(v)
	void *v;
{
	struct vop_lock_args *ap = v;
	struct tcfs_node *nn = VTOTCFS(ap->a_vp);

#ifdef TCFS_DIAGNOSTIC
	vprint("tcfs_unlock_e", ap->a_vp);
#endif
#ifdef DIAGNOSTIC
	if ((nn->tcfs_flags & TCFS_LOCKED) == 0) {
		vprint("tcfs_unlock", ap->a_vp);
		panic("tcfs: unlocking unlocked node");
	}
	if (curproc && nn->tcfs_pid != curproc->p_pid &&
	    curproc->p_pid > -1 && nn->tcfs_pid > -1) {
		vprint("tcfs_unlock", ap->a_vp);
		panic("tcfs: unlocking other process's tcfs node");
	}
#endif
	nn->tcfs_flags &= ~TCFS_LOCKED;

	if ((nn->tcfs_flags & TCFS_LLOCK) != 0)
		VOP_UNLOCK(nn->tcfs_lowervp);

	nn->tcfs_flags &= ~TCFS_LLOCK;
    
	if (nn->tcfs_flags & TCFS_WANTED) {
		nn->tcfs_flags &= ~TCFS_WANTED;
		wakeup((caddr_t)nn);
	}
#ifdef DIAGNOSTIC
	nn->tcfs_pid = 0;
	nn->tcfs_lockpc = nn->tcfs_lockpc2 = 0;
#endif
	return (0);
}

int
tcfs_islocked(v)
	void *v;
{
	struct vop_islocked_args *ap = v;
	return ((VTOTCFS(ap->a_vp)->tcfs_flags & TCFS_LOCKED) ? 1 : 0);
}

/*
 * Global vfs data structures
 */
int (**tcfs_vnodeop_p) __P((void *));
struct vnodeopv_entry_desc tcfs_vnodeop_entries[] = {
	{ &vop_default_desc,	tcfs_bypass },

	{ &vop_getattr_desc,	tcfs_getattr },
	{ &vop_setattr_desc,	tcfs_setattr }, 
	{ &vop_inactive_desc,	tcfs_inactive },
	{ &vop_reclaim_desc,	tcfs_reclaim },
	{ &vop_print_desc,	tcfs_print },

	{ &vop_lock_desc,	tcfs_lock },
	{ &vop_unlock_desc,	tcfs_unlock },
	{ &vop_islocked_desc,	tcfs_islocked },
	{ &vop_lookup_desc,	tcfs_lookup }, /* special locking frob */

	{ &vop_strategy_desc,	tcfs_strategy },
	{ &vop_bwrite_desc,	tcfs_bwrite },
	{ &vop_read_desc,	tcfs_read },
	{ &vop_readdir_desc,	tcfs_readdir },
	{ &vop_write_desc,	tcfs_write },
	{ &vop_create_desc,	tcfs_create },
	{ &vop_mknod_desc,	tcfs_mknod },
	{ &vop_mkdir_desc,	tcfs_mkdir },
	{ &vop_link_desc,	tcfs_link },
	{ &vop_rename_desc,	tcfs_rename },
	{ &vop_symlink_desc,	tcfs_symlink },
	{ (struct vnodeop_desc*)NULL,	(int(*) __P((void *)))NULL }
};
struct vnodeopv_desc tcfs_vnodeop_opv_desc =
	{ &tcfs_vnodeop_p, tcfs_vnodeop_entries };
