/*	Gestione informazioni sui files cifrati
*/


typedef struct {	
		 union {
			unsigned long flag;
			struct {
				unsigned reserved:4;
				unsigned mb:1;
				unsigned spure:3;
				unsigned gshar:1;
				unsigned unused:7;
				unsigned reserved2:4;
				unsigned unused2:12;
			       } bf;
			} c;
		 unsigned int end_of_file;
		} tcfs_fileinfo;

#define	FI_CFLAG(x)	((x)->c.bf.mb)
#define FI_SPURE(x)	((x)->c.bf.spure)
#define	FI_GSHAR(x)	((x)->c.bf.gshar)
#define FI_ENDOF(x)	((x)->end_of_file)

#define	FI_SET_CF(x,y)	(((x)->c.bf.mb)=(y))
#define FI_SET_SP(x,y)	(((x)->c.bf.spure)=(y))
#define	FI_SET_GS(x,y)	(((x)->c.bf.gshar)=(y))

/*	prototipi	*/

tcfs_fileinfo 	tcfs_get_fileinfo(void *);
tcfs_fileinfo 	tcfs_xgetflags(struct vnode *,struct proc *,struct ucred*);
int 		tcfs_set_fileinfo(void *, tcfs_fileinfo *);
int 		tcfs_xsetflags(struct vnode *, struct proc *, struct ucred *, tcfs_fileinfo *);

