/*
 *	$Source: /usr2/luicat/tcfs/RCS/tcfs.h,v $
 *	$State: Exp $
 *	$Revision: 1.1 $
 *	$Author: luicat $
 *	$Date: 1998/07/12 11:54:14 $
 *	$Locker:  $
 */
/* RCSHEADERENDSHERE */

#ifndef _DES_H_
#include <miscfs/tcfs/kdes.h>
#endif
#ifndef _TCFS_KEYTAB_H_
#include "tcfs_keytab.h"
#endif

struct tcfs_args {
	char		*target;	/* Target of loopback   */
	char 		*des_key;	/* chiave 		*/
	int		cmd;		/* direttiva		*/
	uid_t		user;		/* utente		*/
	pid_t		proc;		/* processo		*/
	gid_t		group;		/* gruppo		*/
	int		treshold;	/* soglia grpkey	*/
};

struct tcfs_mount {
	struct mount	*tcfsm_vfs;
	struct vnode	*tcfsm_rootvp;	/* Reference to root tcfs_node */
	des_key_schedule ks;
	tcfs_keytab *tcfs_uid_kt;
	tcfs_keytab *tcfs_gid_kt;
};

#ifdef _KERNEL
/*
 * A cache of vnode references
 */
struct tcfs_node {
	LIST_ENTRY(tcfs_node)	tcfs_hash;	/* Hash list */
	struct vnode	        *tcfs_lowervp;	/* VREFed once */
	struct vnode		*tcfs_vnode;	/* Back pointer */
	unsigned int		tcfs_flags;	/* locking, etc. */
#ifdef DIAGNOSTIC
	pid_t			tcfs_pid;	/* who's locking it? */
	caddr_t			tcfs_lockpc; /* their return addr */
	caddr_t			tcfs_lockpc2; /* their return addr^2 */
#endif
};

#if defined(__alpha__) || !defined(__GNUC__) || __GNUC__ < 2 || \
	(__GNUC__ == 2 && __GNUC_MINOR__ < 5)
#define RETURN_PC(frameno) (void *)0
#else
#define RETURN_PC(frameno) __builtin_return_address(frameno)
#endif

#define TCFS_WANTED	0x01
#define TCFS_LOCKED	0x02
#define TCFS_LLOCK	0x04

extern int tcfs_node_create __P((struct mount *mp, struct vnode *target, struct vnode **vpp, int lockit));

#define	MOUNTTOTCFSMOUNT(mp) ((struct tcfs_mount *)((mp)->mnt_data))
#define	VTOTCFS(vp) ((struct tcfs_node *)(vp)->v_data)
#define	TCFSTOV(xp) ((xp)->tcfs_vnode)
#ifdef TCFS_DIAGNOSTIC
extern struct vnode *tcfs_checkvp __P((struct vnode *vp, char *fil, int lno));
#define	TCFSVPTOLOWERVP(vp) tcfs_checkvp((vp), __FILE__, __LINE__)
#else
#define	TCFSVPTOLOWERVP(vp) (VTOTCFS(vp)->tcfs_lowervp)
#endif
#define TCFS_VP2UKT(vp) ((MOUNTTOTCFSMOUNT(((vp)->v_mount)))->tcfs_uid_kt)
#define TCFS_VP2GKT(vp) ((MOUNTTOTCFSMOUNT(((vp)->v_mount)))->tcfs_gid_kt)

extern int (**tcfs_vnodeop_p) __P((void *));
extern struct vfsops tcfs_vfsops;

void tcfs_init __P((void));



#define BLOCKSIZE	1024
#define SBLOCKSIZE	   8
	
#define MIN(a,b)        ((a)<(b)?(a):(b))
#define MAX(a,b)        ((a)>(b)?(a):(b))
#define ABS(a)		((a)>=0?(a):(-a))

/*	variabili esterne	*/


/*	prototyphes		*/

int	tcfs_bypass __P((void *));
int	tcfs_getattr __P((void *));
int	tcfs_setattr __P((void *));
int	tcfs_inactive __P((void *));
int	tcfs_reclaim __P((void *));
int	tcfs_print __P((void *));
int	tcfs_strategy __P((void *));
int	tcfs_bwrite __P((void *));
int	tcfs_lock __P((void *));
int	tcfs_unlock __P((void *));
int	tcfs_islocked __P((void *));
int	tcfs_read __P((void *));
int	tcfs_readdir __P((void *));
int	tcfs_write __P((void *));
int	tcfs_create __P((void *));
int	tcfs_mknod __P((void *));
int	tcfs_mkdir __P((void *));
int	tcfs_link __P((void *));
int	tcfs_symlink __P((void *));
int	tcfs_rename __P((void *));
int	tcfs_lookup __P((void *));

des_key_schedule *tcfs_getukey(struct ucred *, struct proc *, struct vnode *);
des_key_schedule *tcfs_getpkey(struct ucred *, struct proc *, struct vnode *);
des_key_schedule *tcfs_getgkey(struct ucred *, struct proc *, struct vnode *);
int	tcfs_exec_cmd(struct tcfs_mount*, struct tcfs_args *);
#endif /* _KERNEL */
