/*
**	ssh_smsg.h	-- header file for coding server messages
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_SMSG_H
#define __SSH_SMSG_H

#include "ssh_msg.h"

/*
**	Sizes for parsing SSH_SMSG_PUBLIC_KEY
*/
#define SSH_SMSG_PUBLIC_KEY_MIN		40	/* *way* lower bound */
#define SSH_SERVER_KEY_SIZE		4	/* bytes for server key */
#define SSH_HOST_KEY_SIZE		4	/* bytes for host key */
#define SSH_PROTO_SIZE			4	/* size for protocol flags */
#define SSH_CIPHER_SIZE			4	/* size of cipher mask */
#define SSH_AUTH_SIZE			4	/* size of auth mask */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	decode an SSH_SMSG_PUBLIC_KEY message
*/
int ssh_smsg_public_key_decode(const uint8_t * data, uint32_t data_len,
	uint8_t * cookie,
	uint32_t * server_key_bits,
	MP_Int * server_key_public_exponent,
	MP_Int * server_key_public_modulus,
	uint32_t * host_key_bits,
	MP_Int * host_key_public_exponent,
	MP_Int * host_key_public_modulus,
	uint32_t * protocol_flags,
	uint32_t * supported_cipher_mask,
	uint32_t * supported_authentications_mask);

/*
**	decode an SSH_SMSG_{STDOUT,STDERR}_DATA message
*/
int ssh_smsg_merge_data_decode(const uint8_t * data, uint32_t data_len,
	uint8_t * str, int str_size);
int ssh_smsg_stdout_data_decode(const uint8_t * data, uint32_t data_len,
	uint8_t * str, int str_size);
int ssh_smsg_stderr_data_decode(const uint8_t * data, uint32_t data_len,
	uint8_t * str, int str_size);

/*
**	decode an SSH_SMSG_RSA_CHALLENGE
*/
int ssh_smsg_auth_rsa_challenge_decode(const uint8_t * data, uint32_t data_len,
	MP_Int * challenge);

/*
**	decode an SSH_SMSG_EXITSTATUS
*/
int ssh_smsg_exitstatus_decode(const uint8_t * data, uint32_t data_len,
	uint32_t * exit_status);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_SMSG_H */

