/******************************************************************************
**
**     File/Function name:	ssh_final.c
**
**                              Copyright 1998 Tadayoshi Kohno.
**				All rights reserved.
**                              See the LICENSE file.
**
**     Purpose:			handle post-connection needs
**
**     Author/Date:		Tadayoshi Kohno, 18 April 1998
**
**     Notes:
**	The main purpose of these functions is to finalize a connection.
**	Typically, these functions are to be called after a connection
**	closes (and before another one opens)
**
**     Functions:
**	ssh_final_client	finalize client after a connection
**
******************************************************************************/

#ifndef lint
static char *RCSid="$Header: /home/kohno/LibSSH/libssh.0.0.1beta/libssh/RCS/ssh_final.c,v 1.1 1998/04/18 17:03:02 kohno Exp $";
#endif

#include "ssh_final.h"

/******************************************************************************
**
**     File/Function name:	ssh_final_client
**
**     Purpose:			cleanup after a connection
**
**     Preconditions:		ssh_info valid pointer
**				connection established and then terminated
**
**     Parameters:		ssh_info	ssh connection information
**
**     Exit (post) conditions:	S_GOOD
**
**     Error conditions:	S_BAD		error
**
**     Side effects:		compression turned off and memory freed
**
**     Author/Date:		Tadayoshi Kohno, 18 April 1998
**
**     Notes:
**	This function should be called after every connection.  If multiple
**	connections are to happen within the client (connect - disconnect -
**	connect again), then this function needs to be called after
**	each connection closes.  We should not need to call ssh_presetup_client
**	again -- this should be enough.
**
******************************************************************************/

int ssh_final_client
(
	struct ssh_struct * ssh_info	/* connection information */
)
{
	if (ssh_info == (struct ssh_struct *) NULL)
	{
		ssh_errno_set(SSH_ERRNO_NULL_POINTER);

		return(S_BAD);
	}

/*
**	if compression is on, turn it off and free memory
*/
	if (ssh_compression_active(ssh_info))
	{
		ssh_debugger_new(&(ssh_info->debug_info),
			"deactivating compression",
			"ssh_final_client");

		if (ssh_compression_unset(ssh_info) == S_BAD)
		{
			/* propagate ssh_errno */
			return(S_BAD);
		}
	}

	return(S_GOOD);
}

