/*
**	ssh_connect.h	-- connect with remote host stuff meeting
**		specifications in internet draft-ylonen-ssh-protocol-00.txt
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_CONNECT_H
#define __SSH_CONNECT_H

#include "ssh.h"
#include "ssh_types.h"

#define SSH_NEED_AUTH		1	/* server needs to auth client */
#define SSH_NO_NEED_AUTH	0	/* server doesn't need to " */
#define SSH_USER_ERR		-1	/* error on connect user */

#define SSH_AUTHENTICATED	1	/* authenticated */
#define SSH_NOT_AUTHENTICATED	0	/* not authenticated */
#define SSH_AUTH_ERR		-1	/* error on authentication */

#ifdef __cplusplus
extern "C" {
#endif

int ssh_connect_client(socket_type sockfd,	/* connect client */
	struct ssh_struct * ssh_info, const char * applic_ver,
	const char * user, int auth_mode, const char * passwd,
	uint8_t cipher_choice, const char * identity_file);

int ssh_disconnect_client_confirm(socket_type sockfd,
	struct ssh_struct * ssh_info);	/* confirm disconnect*/

int ssh_disconnect_client_active(socket_type sockfd, /* disconnect active */
	struct ssh_struct * ssh_info, const char * msg);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_CONNECT_H */

