/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)es_ras.c	1.11 96/10/14 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

#include <xview/notify.h>
#include <xview/seln.h>
#include <xview/icon.h>
#include <xview/cms.h>
#include <xview/win_screen.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <rasterfile.h>

#include <skip_conf.h>

#include "es_ras.h"

extern char	*progname;

extern char *directory();

char *
es_path(char *name)
{
	struct stat		st;
	static char		path[256], prog[256];

	sprintf(path, "./%s", name);
	if (stat(path, &st) == 0) {
		return (path);
	}

	strcpy(prog, progname);
	strcpy(path, directory(prog));
	strcat(path, "/");
	strcat(path, name);

	if (stat(path, &st) == 0) {
		return (path);
	}

	strcpy(path, SKIP_BIN);
	strcat(path, "/");
	strcat(path, name);
	if (stat(path, &st) == 0) {
		return (path);
	}
	return (NULL);
}

/* 
 * transform Sun rasterfile into xview server image
 */
Server_image
es_readras(char *filename, int *width, int *height, int *depth)
{
	int			rc = 0;
	int			idx = 0;
	int			color_size = 0;

	FILE			*fd = NULL;
	char			*rasfile = NULL;
	char			*color_map = NULL;
	char			*raster_image = NULL;

	struct rasterfile	raster_info = { 0 };
	Xv_singlecolor		*image_colors = NULL;
	Server_image		image_server = XV_NULL;
	Cms			image_cms = XV_NULL;
	extern int		es_display_depth;

	/*
	 * Get the full path name of the raster file
	 */
	rasfile = es_path(filename);

	if (rasfile == NULL) {
		return(XV_NULL);
	}

	fd = fopen(rasfile, "r");

	if (fd == NULL) {
		fprintf(stderr, "can't open raster file %s.\n", rasfile);
		return(XV_NULL);
	}


	/*
	 *  Get the header part of the raster file
	 */
	rc = fread(&raster_info, sizeof(raster_info), 1, fd);

	if (rc == 0) {
		fprintf(stderr,
			"Invalid header section in raster file %s.\n", rasfile);
		fclose(fd);
		return(XV_NULL);
	}

	/*
	 * We need to convert values for x.86
	 */
	raster_info.ras_magic		= ntohl(raster_info.ras_magic);
	raster_info.ras_width		= ntohl(raster_info.ras_width);
	raster_info.ras_height		= ntohl(raster_info.ras_height);
	raster_info.ras_depth		= ntohl(raster_info.ras_depth);
	raster_info.ras_length		= ntohl(raster_info.ras_length);
	raster_info.ras_type		= ntohl(raster_info.ras_type);
	raster_info.ras_maptype		= ntohl(raster_info.ras_maptype);
	raster_info.ras_maplength	= ntohl(raster_info.ras_maplength);

	if (raster_info.ras_depth != es_display_depth) {
		fclose(fd);
		return (XV_NULL);
	}

	/*
	 * Set the XView server image parameters
	 */
	*width	= raster_info.ras_width;
	*height	= raster_info.ras_height;
	*depth	= raster_info.ras_depth;

	/*
	 * Sanity checking...
	 */

	if (raster_info.ras_magic != RAS_MAGIC) {
		fprintf(stderr,
			"Invalid RAS_MAGIC (%x) in raster file %s.\n",
					raster_info.ras_magic, rasfile);
		fclose(fd);
		return(XV_NULL);
	}

	if (raster_info.ras_depth != 8) {
		fprintf(stderr,
			"Invalid ras_depth in raster file %s.\n", rasfile);
		fclose(fd);
		return(XV_NULL);
	}

	if (raster_info.ras_type != RT_STANDARD) {
		fprintf(stderr,
			"Invalid ras_type in raster file %s.\n", rasfile);
		fclose(fd);
		return(XV_NULL);
	}

	if (raster_info.ras_maptype != RMT_EQUAL_RGB) {
		fprintf(stderr,
			"Invalid ras_maptype in raster file %s.\n", rasfile);
		fclose(fd);
		return(XV_NULL);
	}

	if (raster_info.ras_maplength % 3) {
		fprintf(stderr,
			"Invalid ras_maplength in raster file %s.\n", rasfile);
		fclose(fd);
		return(XV_NULL);
	}

	/*
	 * Prepare to load the colormap
	 */
	color_size	= raster_info.ras_maplength / 3;
	color_map	= (char *) malloc(raster_info.ras_maplength);

	if (color_map == NULL) {
		fprintf(stderr,
			"alloc failed for colormap for in raster file %s.\n",
			rasfile);
		free(color_map);
		fclose(fd);
		return(XV_NULL);
	}

	/*
	 *  Load the colormap
	 */
	rc = fread(color_map, raster_info.ras_maplength, 1, fd);

	if (rc == 0) {
		fprintf(stderr, "Can't load colormap in raster file %s.\n",
								rasfile);
		free(color_map);
		fclose(fd);
		return(XV_NULL);
	}

	/*
	 * Convert the colormap into Xview array of colors
	 */
	image_colors = (Xv_singlecolor *) malloc(
				sizeof(Xv_singlecolor) * color_size);
	
	for (idx = 0; idx < color_size; idx++) {
		image_colors[idx].red 	= color_map[idx];
		image_colors[idx].green	= color_map[idx + color_size];
		image_colors[idx].blue 	= color_map[idx + color_size * 2];
	}

	free(color_map);

	/*
	 * Prepare to load the image
	 */
	raster_image = (char *) malloc(raster_info.ras_length);

	if (raster_image == NULL) {
		fprintf(stderr,
			"alloc failed for image buffer for raster file %s.\n",
			rasfile);
		free(image_colors);
		fclose(fd);
		return(XV_NULL);

	}

	/*
	 *  Load the image
	 */
	rc = fread((void *)raster_image, raster_info.ras_length, 1, fd);

	if (rc == 0) {
		fprintf(stderr, "Can't load image from raster file %s.\n",
								rasfile);
		free(raster_image);
		free(image_colors);
		fclose(fd);
		return(XV_NULL);
	}

	fclose(fd);

	/*
	 * Create the XView colormap segment
	 */
	image_cms = (Cms) xv_create(XV_NULL, CMS,
				CMS_SIZE, color_size,
				CMS_COLORS, image_colors,
				NULL);

	if (image_cms == XV_NULL) {
		fprintf(stderr, "Can't create Coloramap segment "
				"for raster file %s.\n", rasfile);
		free(raster_image);
		free(image_colors);
		return(XV_NULL);
	}


	/*
	 * Now, create the XView server image
	 */
	image_server = (Server_image) xv_create(XV_NULL, SERVER_IMAGE,
				XV_WIDTH, *width,
				XV_HEIGHT, *height,
				SERVER_IMAGE_DEPTH, *depth,
				SERVER_IMAGE_CMS, image_cms,
				SERVER_IMAGE_BITS, raster_image,
				NULL);

	if (image_server == XV_NULL) {
		fprintf(stderr, "Can't create Server_image "
				"for raster file %s.\n", rasfile);
		free(image_colors);
		free(raster_image);
		return(XV_NULL);
	}

	free(image_colors);
	free(raster_image);

	/*
	 * Return is OK.
	 */
	return(image_server);
}

char *
directory( s )
char	*s;
{
		register char   *p;

		if( !s  ||  !*s )
		        return  ".";

		p = s + strlen( s );
		while( p != s  &&  *--p == '/' )
		        ;

		if ( p == s && *p == '/' )
		        return "/";

		while( p != s )
		        if( *--p == '/' ) {
		                while ( *p == '/' )
		                        p--;
		                *++p = '\0';
		                return  s;
		        }

		return  ".";
}
