/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)es_glue.c	1.51 96/10/15 Sun Microsystems"

/*
 * System includes
 */
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/notice.h>
#include <xview/xv_xrect.h>

/*
 * SKIP includes
 */
/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_ioctl.h>
#include <skip_acl.h>
#include <skip_lib.h>

#include "skiptool_ui.h"
#include "es_glue.h"
#include "es_ras.h"
#include "es_systems.h"
#include "es_timers.h"
#include "es_interactive.h"

es_acl_t 		*add_hostwin, *add_netwin, *add_hostwin_v1,
			*add_netwin_v1, *add_nomwin_v1, *add_hostwin_v2,
			*add_netwin_v2, *add_nomwin_v2, *add_hostwin_raw,
			*add_netwin_raw, *add_xhostwin, *add_xnetwin,
			*add_xnomwin_v1, *add_xnomwin_v2;
extern void		frame_get_rect(Frame frame, Rect *rect);
extern void		frame_set_rect(Frame frame, Rect *rect);
static Server_image	unknown, none, icon_v1, icon_v2, 
			nomadic, skip;
char			ifname[STRSZ], hostname[STRSZ],
			*progname, *displayname;
int			es_display_depth = 0;
Display			*display = NULL;
Xv_Screen		screen;
static Xv_opaque	alist = XV_NULL, xlist = XV_NULL;
es_system_t		*skip_acl = NULL;
static void		(*done_checking_func)();
static boolean_t	no_req_systems_check = B_FALSE;

static void
usage(char *prog)
{
	fprintf(stderr, "usage: %s [-n] [<device>]\n", prog);
	fprintf(stderr, "\t-n suppress checking for required systems\n");
	exit(1);
}


/*
 * display simple alert
 */
void
alert(Panel_item owner, char *s, int bell)
{
	Panel				panel;
	Xv_notice			notice; 

	if (owner == XV_NULL) {
		panel = Skiptool_base_window->base_window;
	} else {
		panel = xv_get(owner, PANEL_PARENT_PANEL);
	}
	notice = xv_create(panel,
			NOTICE,
			XV_SHOW, TRUE,
			NOTICE_LOCK_SCREEN, TRUE,
			NOTICE_NO_BEEPING, bell ? FALSE : TRUE,
			NOTICE_MESSAGE_STRING, s, NULL,
			NULL);
	xv_destroy_safe(notice);
}

/*
 * clear left footer
 */
static void
clear_footer()
{

	(void) xv_set(Skiptool_base_window->base_window,
		FRAME_LEFT_FOOTER, "",
		NULL);
}

/*
 * set the frame left footer message
 */
void
set_footer(char *s, boolean_t bell)
{
	if (bell) {
		window_bell(Skiptool_base_window->base_window);
	}

	(void) xv_set(Skiptool_base_window->base_window,
		FRAME_LEFT_FOOTER, s,
		NULL);
	(void) start_timer("footer",  SKIP_MSG_WAIT, clear_footer, 0);
}

/*
 * return human readable ACL string
 */
static char *
acl_of(skip_param_t *params)
{
	static char		acl[STRSZ];

	(void) skip_acl_to_name(params, acl, B_FALSE);
	return (acl);
}

/*
 * return a glyph corresponding to access control entry
 */
static Xv_opaque
glyph_of(int version, boolean_t nom)
{
	if (nom) {
		return (nomadic);
	}

	switch (version) {
	case SKIP_NONE:
		return (none);

	case SKIP_V1:
		return (icon_v1);

	case SKIP_V2:
		return (icon_v2);
	}
	return (unknown);
}

/*
 * set an algorithm choice item to the specified value
 */
int
set_alg_selector(Xv_opaque item, char *algname)
{
	register int		i;
	register char		*setting;

	for (i = 0; i < skip_max_algs; i++) {
		setting = (char *) xv_get(item, PANEL_CHOICE_STRING, i);
		if (setting && !strcmp(setting, algname)) {
			xv_set(item, PANEL_VALUE, i, NULL);
			return (i);
		}
	}
	return (-1);
}

/*
 * build menu of name space identifiers
 */
static void
build_nsid_menu(Xv_opaque x_nsid, boolean_t nsid_zero)
{
	register int	nsid, item = 0;

	for (nsid = nsid_zero ? 0 : 1; nsid < skip_max_nsids; nsid++) {
		if (skip_supported_nsids[nsid]) {
			(void) xv_set(x_nsid,
				PANEL_CHOICE_STRING, item,
						skip_nsids[nsid].name,
				NULL);
			item++;
		}
	}
}

/*
 * build menu of sender name space identifiers, optionally set to the
 * specified nsid
 */
static void
build_s_nsid_menu(Xv_opaque x_nsid, unsigned char s_nsid)
{
	register int			nsid, setting = 0, item = 0;
	skip_keyid_list_t		*p_keyid_lst;
	ioctl_keyid_t			keyid_list;
	

	if (skip_get_list_keyids(ifname, &keyid_list) < 0) {
		alert(XV_NULL, SKIP_BADKEYGET, B_TRUE);
		return;
	}

	p_keyid_lst = keyid_list.keyid_lst;

	for (nsid = 0; nsid < skip_max_nsids; nsid++) {

		if (nsid == s_nsid) {
			setting = item;
		}

		if (nsid && (p_keyid_lst->count == 0)) {
			p_keyid_lst++;
			continue;
		}

		(void) xv_set(x_nsid,
			PANEL_CHOICE_STRING, item++, skip_nsids[nsid].name,
			NULL);

		p_keyid_lst++;
	}
	(void) xv_set(x_nsid, PANEL_VALUE, setting, NULL);
}

/*
 * build menu of sender master key ids for a given nsid, optionally
 * set to the specified value.
 */
static void
build_s_mkeyid_menu(Xv_opaque local_keyid, unsigned char s_nsid,
							char *s_mkeyidstr)
{
	register int			key_idx, setting = 0, item = 0;
	skip_keyid_list_t		*p_keyid_lst;
	ioctl_keyid_t			keyid_list;
	char				keyidstr[STRSZ];

	if (s_nsid == SKIP_NSID_NONE) {
		(void) xv_set(local_keyid,
				PANEL_CHOICE_STRING, item, SKIP_DEFKEY,
				NULL);
		return;
	}

	if (skip_get_list_keyids(ifname, &keyid_list) < 0) {
		alert(local_keyid, SKIP_BADKEYGET, B_TRUE);
		return;
	}

	p_keyid_lst = &keyid_list.keyid_lst[s_nsid];

	for (key_idx = 0; key_idx < p_keyid_lst->count; key_idx++) {

		if (skip_keyid_to_s(&p_keyid_lst->mkeyid[key_idx],
						s_nsid, keyidstr) < 0) {

			sprintf(keyidstr, SKIP_BADLOCALKEY, key_idx, s_nsid);

			alert(local_keyid, keyidstr, B_TRUE);
		} else {
			(void) xv_set(local_keyid,
				PANEL_CHOICE_STRING, item, keyidstr,
				NULL);
		}

		if (s_mkeyidstr && !strcmp(keyidstr, s_mkeyidstr)) {
			setting = item;
		}
		item++;
	}
	xv_set(local_keyid, PANEL_VALUE, setting, NULL);
}

/* es_local_keys()
 *
 * Return how many local keys are installed on the system
 */
static int
es_local_keys()
{
	skip_keyid_list_t		*p_keyid_lst;
	ioctl_keyid_t			keyid_list;
	int				nsid, count = 0;

	if (skip_get_list_keyids(ifname, &keyid_list) < 0) {
		return(-1);
	}

	p_keyid_lst = keyid_list.keyid_lst;

	for (nsid = 0; nsid < skip_max_nsids; nsid++) {
		count += p_keyid_lst->count;
		p_keyid_lst++;
	}
	return (count);
}

/*
 * return current nsid value from selector
 */
int
get_nsid_selector(Xv_opaque x_nsid)
{
	int				n;
	char				*s;

	s = (char *) xv_get(x_nsid,
		PANEL_CHOICE_STRING, xv_get(x_nsid, PANEL_VALUE));

	for (n = 0; n < skip_max_nsids; n++) {
		if (s && !strcmp(s, skip_nsids[n].name)) {
			break;
		}
	}
	if (n == skip_max_nsids) {
		alert(x_nsid, SKIP_BAD_NSID, B_TRUE);
		return (-1);
	}
	return (n);
}

/*
 * set nsid value on selector
 */
void
set_nsid_selector(Xv_opaque x_nsid, unsigned char nsid)
{
	int				n;
	char				*s;

	for (n = 0; n < skip_max_nsids; n++) {
		s = (char *) xv_get(x_nsid, PANEL_CHOICE_STRING, n);
		if (s && !strcmp(s, skip_nsids[nsid].name)) {
			break;
		}
	}
	if (n == skip_max_nsids) {
		alert(x_nsid, SKIP_BAD_NSID, B_TRUE);
		return;
	}
	(void) xv_set(x_nsid, PANEL_VALUE, n, NULL);
}

/*
 * set sender master key information to reflect parameters
 */
void
set_s_mkeyid_info(Xv_opaque s_nsid, Xv_opaque local_keyid, skip_param_t *params)
{
	char				keyidstr[STRSZ];

	if (skip_keyid_to_s(&params->s_mkeyid, params->s_nsid, keyidstr) < 0) {
		sprintf(keyidstr, SKIP_BADLOCALKEY, 1, params->s_nsid);
		alert(s_nsid, keyidstr, B_TRUE);
		return;
	}

	switch (params->version) {
	case SKIP_V1:
		build_s_mkeyid_menu(local_keyid, params->s_nsid, keyidstr);
		break;

	case SKIP_V2:
		build_s_nsid_menu(s_nsid, params->s_nsid);
		build_s_mkeyid_menu(local_keyid, params->s_nsid, keyidstr);
		break;
	
	case SKIP_RAW:
		xv_set(local_keyid, PANEL_VALUE, keyidstr, NULL);
		return;
	}

}

/*
 * set receiver master key information to reflect parameters
 */
void
set_r_mkeyid_info(Xv_opaque r_nsid, Xv_opaque keyid, skip_param_t *params)
{
	char				keyidstr[STRSZ];

	if (skip_keyid_to_s(&params->r_mkeyid, params->r_nsid, keyidstr) < 0) {
		sprintf(keyidstr, SKIP_BADREMOTEKEY, params->r_nsid);
		alert(r_nsid, keyidstr, B_TRUE);
		return;
	}
	if (r_nsid) {
		set_nsid_selector(r_nsid, params->r_nsid);
	}
	xv_set(keyid, PANEL_VALUE, keyidstr, NULL);
}

/*
 * callback for hostwin v2 s_nsid menu selector
 */
void
s_nsid_hostwin_v2_callback(skiptool_hostwin_v2_objects *ip)
{
	int				nsid;
	es_acl_t			*access;

	access = (es_acl_t *) xv_get(ip->hostwin_v2, WIN_CLIENT_DATA);
	nsid = get_nsid_selector(access->s_nsid);
	if (nsid < 0) {
		return;
	}
	
	xv_set(ip->local_keyid, XV_SHOW, FALSE, NULL);
	xv_destroy_safe(ip->local_keyid);
	ip->local_keyid = XV_NULL;
	(void) skiptool_hostwin_v2_objects_initialize(ip,
					Skiptool_base_window->base_window);
	if (ip->local_keyid == XV_NULL) {
		alert(XV_NULL, SKIP_MSG_NOMEM, B_TRUE);
		return;
	}
	S_MKEYID(access, ip->local_keyid);
	build_s_mkeyid_menu(ip->local_keyid, nsid, NULL);
}

/*
 * callback for netwin v2 s_nsid menu selector
 */
void
s_nsid_netwin_v2_callback(skiptool_netwin_v2_objects *ip)
{
	int				nsid;
	es_acl_t			*access;

	access = (es_acl_t *) xv_get(ip->netwin_v2, WIN_CLIENT_DATA);
	nsid = get_nsid_selector(access->s_nsid);
	if (nsid < 0) {
		return;
	}
	
	xv_set(ip->local_keyid, XV_SHOW, FALSE, NULL);
	xv_destroy_safe(ip->local_keyid);
	ip->local_keyid = XV_NULL;
	(void) skiptool_netwin_v2_objects_initialize(ip,
					Skiptool_base_window->base_window);
	if (ip->local_keyid == XV_NULL) {
		alert(XV_NULL, SKIP_MSG_NOMEM, B_TRUE);
		return;
	}
	S_MKEYID(access, ip->local_keyid);
	build_s_mkeyid_menu(ip->local_keyid, nsid, NULL);
}

/*
 * callback for nomwin v2 s_nsid menu selector
 */
void
s_nsid_nomwin_v2_callback(skiptool_nomwin_v2_objects *ip)
{
	int				nsid;
	es_acl_t			*access;

	access = (es_acl_t *) xv_get(ip->nomwin_v2, WIN_CLIENT_DATA);
	nsid = get_nsid_selector(access->s_nsid);
	if (nsid < 0) {
		return;
	}
	
	xv_set(ip->local_keyid, XV_SHOW, FALSE, NULL);
	xv_destroy_safe(ip->local_keyid);
	ip->local_keyid = XV_NULL;
	(void) skiptool_nomwin_v2_objects_initialize(ip,
					Skiptool_base_window->base_window);
	if (ip->local_keyid == XV_NULL) {
		alert(XV_NULL, SKIP_MSG_NOMEM, B_TRUE);
		return;
	}
	S_MKEYID(access, ip->local_keyid);
	build_s_mkeyid_menu(ip->local_keyid, nsid, NULL);
}

/*
 * build menu of available V1 key/traffic algorithms
 */
void
build_v1_alg_menus(es_acl_t *access)
{
	register int		alg, kij_item = 0, kp_item = 0;

	/*
	 * create V1 alg menus
	 */
	for (alg = 0; alg < skip_max_algs; alg++) {
		if (skip_supported_kij_alg(alg, SKIP_V1)) {
			(void) xv_set(access->kij_alg,
				PANEL_CHOICE_STRING, kij_item,
				skip_kij_alg_to_name(alg, SKIP_V1),
				NULL);
			kij_item++;
		}
		if (skip_supported_kp_alg(alg, SKIP_V1)) {
			(void) xv_set(access->kp_alg,
				PANEL_CHOICE_STRING, kp_item,
				skip_kp_alg_to_name(alg, SKIP_V1),
				NULL);
			kp_item++;
		}
	}

}

/*
 * build menu of available V2 key/traffic algorithms
 */
void
build_v2_alg_menus(es_acl_t *access)
{
	register int		alg, kij_item = 0, kp_item = 0, mac_item = 0;

	/*
	 * create V2 alg menus
	 */
	kij_item = kp_item = mac_item = 0;
	for (alg = 0; alg < skip_max_algs; alg++) {
		if (skip_supported_kij_alg(alg, SKIP_V2)) {
			(void) xv_set(access->kij_alg,
				PANEL_CHOICE_STRING, kij_item,
				skip_kij_alg_to_name(alg, SKIP_V2),
				NULL);
			kij_item++;
		}
		if (skip_supported_kp_alg(alg, SKIP_V2)) {
			(void) xv_set(access->kp_alg,
				PANEL_CHOICE_STRING, kp_item,
				skip_kp_alg_to_name(alg, SKIP_V2),
				NULL);
			kp_item++;
		}
		if (skip_supported_mac_alg(alg, SKIP_V2)) {
			(void) xv_set(access->mac_alg,
				PANEL_CHOICE_STRING, mac_item,
				skip_mac_alg_to_name(alg, SKIP_V2),
				NULL);
			mac_item++;
		}
	}
}

/*
 * build menu of available Raw key/traffic algorithms
 */
void
build_raw_alg_menus(es_acl_t *access)
{
	register int		alg, kp_item = 0, mac_item = 0;

	/*
	 * create Raw alg menus
	 */
	kp_item = mac_item = 0;
	for (alg = 0; alg < skip_max_algs; alg++) {
		if (skip_supported_kp_alg(alg, SKIP_V2)) {
			(void) xv_set(access->kp_alg,
				PANEL_CHOICE_STRING, kp_item,
				skip_kp_alg_to_name(alg, SKIP_V2),
				NULL);
			kp_item++;
		}
		if (skip_supported_mac_alg(alg, SKIP_V2)) {
			(void) xv_set(access->mac_alg,
				PANEL_CHOICE_STRING, mac_item,
				skip_mac_alg_to_name(alg, SKIP_V2),
				NULL);
			mac_item++;
		}
	}
}

/* es_close_win()
 *
 */
void
es_close_win(es_acl_t *access)
{
	xv_set(access->win, FRAME_CMD_PUSHPIN_IN, FALSE, XV_SHOW, FALSE, NULL);
}

/* es_win_done()
 *
 * Handle the closure of an edit window
 */
void
es_win_done(Frame subframe)
{
	void			es_win_cancel();
	es_acl_t		*access;

	access = (es_acl_t *) xv_get(subframe, WIN_CLIENT_DATA);
	es_win_cancel(access);
}

/* es_win_type()
 *
 */
static int
es_win_type(skip_param_t *params)
{
	if (params->flags & SKIP_NOMADIC) {
		return (nomwin);
	}
	if (SKIP_IS_NETACL(params)) {
		return (netwin);
	}
	return (hostwin);
}

/* es_set_win()
 *
 */
static void
es_set_win(es_acl_t *access, boolean_t read_only)
{
	char			msg[STRSZ], *aname;
	skip_param_t		*params = &access->params;
	boolean_t		trans, nom = B_FALSE;

	if (access->win == XV_NULL) {
		return;
	}

	switch (es_win_type(params)) {

	case hostwin:
		if (skip_addr_to_host(&params->ip_addr, msg) < 0) {
			strcpy(msg, inet_ntoa(params->ip_addr));
		}
		xv_set(access->addr, PANEL_VALUE, msg,
				PANEL_READ_ONLY, read_only,
				PANEL_VALUE_UNDERLINED, !read_only,
				NULL);
		break;

	case netwin:
		xv_set(access->addr, PANEL_VALUE, inet_ntoa(params->ip_addr),
				PANEL_READ_ONLY, read_only,
				PANEL_VALUE_UNDERLINED, !read_only,
				NULL);
		xv_set(access->mask, PANEL_VALUE, inet_ntoa(params->mask),
				PANEL_READ_ONLY, read_only,
				PANEL_VALUE_UNDERLINED, !read_only,
				NULL);
		break;

	case nomwin:
		if (access->r_nsid) {
			xv_set(access->r_nsid, 
				PANEL_INACTIVE, read_only,
				NULL);
		}
		xv_set(access->keyid, 
				PANEL_READ_ONLY, read_only,
				PANEL_VALUE_UNDERLINED, !read_only,
				NULL);
		if (skip_addr_to_host(&params->ip_addr, msg) < 0) {
			strcpy(msg, inet_ntoa(params->ip_addr));
		}
		xv_set(access->addr, PANEL_VALUE, msg, NULL);
		nom = B_TRUE;
		break;

	}

	switch (params->version) {
	case SKIP_NONE:
		break;

	case SKIP_V1:
		set_s_mkeyid_info(access->s_nsid, access->local_keyid, params);
		set_r_mkeyid_info(access->r_nsid, access->keyid, params);

		aname = skip_kij_alg_to_name(params->kij_alg, params->version);
		(void) set_alg_selector(access->kij_alg, aname);
		aname = skip_kp_alg_to_name(params->kp_alg, params->version);
		(void) set_alg_selector(access->kp_alg, aname);
		if (skip_addr_to_host(&params->tunnel_addr, msg) < 0) {
			strcpy(msg, inet_ntoa(params->tunnel_addr));
		}
		xv_set(access->tunnel_addr, PANEL_VALUE, msg, NULL);
		break;

	case SKIP_V2:
		set_s_mkeyid_info(access->s_nsid, access->local_keyid, params);
		set_r_mkeyid_info(access->r_nsid, access->keyid, params);

		aname = skip_kij_alg_to_name(params->kij_alg, params->version);
		(void) set_alg_selector(access->kij_alg, aname);
		aname = skip_kp_alg_to_name(params->kp_alg, params->version);
		(void) set_alg_selector(access->kp_alg, aname);
		aname = skip_mac_alg_to_name(params->mac_alg, params->version);
		(void) set_alg_selector(access->mac_alg, aname);

		trans = (params->ip_mode == SKIP_TRS_ON);
		xv_set(access->skip_mode, PANEL_VALUE, trans ? 1 : 0, NULL);

		if (!nom) {
			xv_set(access->tunnel_addr, PANEL_INACTIVE,
								trans,
								NULL);
			xv_set(access->tunnel_label, PANEL_INACTIVE,
								trans,
								NULL);
		}
		if (skip_addr_to_host(&params->tunnel_addr, msg) < 0) {
			strcpy(msg, inet_ntoa(params->tunnel_addr));
		}
		xv_set(access->tunnel_addr, PANEL_VALUE, msg, NULL);
		break;

	case SKIP_RAW:
		set_s_mkeyid_info(access->s_nsid, access->local_keyid, params);
		set_r_mkeyid_info(access->r_nsid, access->keyid, params);

		aname = skip_kp_alg_to_name(params->kp_alg, params->version);
		(void) set_alg_selector(access->kp_alg, aname);
		aname = skip_mac_alg_to_name(params->mac_alg, params->version);
		(void) set_alg_selector(access->mac_alg, aname);

		trans = (params->ip_mode == SKIP_TRS_ON);
		xv_set(access->skip_mode, PANEL_VALUE, trans ? 1 : 0, NULL);
		xv_set(access->tunnel_addr, PANEL_INACTIVE, trans, NULL);
		xv_set(access->tunnel_label, PANEL_INACTIVE, trans, NULL);
		if (skip_addr_to_host(&params->tunnel_addr, msg) < 0) {
			strcpy(msg, inet_ntoa(params->tunnel_addr));
		}
		xv_set(access->tunnel_addr, PANEL_VALUE, msg, NULL);
		break;
	}
	(void) xv_set(access->win, FRAME_DONE_PROC, es_win_done, NULL);
}

/* es_make_add()
 *
 * make an add system window
 */
static void
es_make_add(es_acl_t *access)
{
	char		*title, newtitle[STRSZ];

	title = (char *) xv_get(access->win, XV_LABEL);
	sprintf(newtitle, "Add %s", title);
	xv_set(access->win, XV_LABEL, newtitle, NULL);
	access->is_add_win = B_TRUE;
}

/* es_make_exc()
 *
 * make an excluded system window
 */
static void
es_make_exc(es_acl_t *access)
{
	char		*title, newtitle[STRSZ];

	title = (char *) xv_get(access->win, XV_LABEL);
	sprintf(newtitle, "[Excluded] %s", title);
	xv_set(access->win, XV_LABEL, newtitle, NULL);
	access->params.flags |= SKIP_EXCL;
}

/* es_new_access()
 *
 * create new access control info
 */
static es_acl_t *
es_new_access(Xv_opaque list, int version, int win_type)
{
	register es_acl_t	*access;

	access = (es_acl_t *) calloc(1, sizeof (*access));
	if (access == NULL) {
		alert(XV_NULL, SKIP_BADNEWWIN, B_TRUE);
		return (NULL);
	}

	access->list = list;
	access->params.version = version;

	if (win_type == nomwin) {
		access->params.flags |= SKIP_NOMADIC;
	}
	return (access);
}

/* es_new_win()
 *
 * create a window of the type specified
 *
 * Returns: B_TRUE on success, B_FALSE otherwise
 */
static boolean_t
es_new_win(es_acl_t *access, int version, int win_type)
{
	register boolean_t	nom = B_FALSE;

	if (access == NULL) {
		return (B_FALSE);
	}

	nom = win_type == nomwin;

	switch (version) {
	case SKIP_NONE:
		switch (win_type) {
		case nomwin:
			alert(XV_NULL, SKIP_V0_NOMADIC, B_TRUE);
			return (B_FALSE);

		case hostwin:
			access->w.win =
				skiptool_hostwin_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.hostwin->skip_icon, version, nom);
			WIN(access, access->w.hostwin->hostwin);
			ADDR(access, access->w.hostwin->addr);
			break;

		case netwin:
			access->w.win =
				skiptool_netwin_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.netwin->skip_icon, version, nom);
			WIN(access, access->w.netwin->netwin);
			ADDR(access, access->w.netwin->addr);
			MASK(access, access->w.netwin->mask);
		}
		break;
		
	case SKIP_V1:
		switch (win_type) {
		case hostwin:
			access->w.win =
				skiptool_hostwin_v1_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.hostwin_v1->skip_icon, version, nom);
			WIN(access, access->w.hostwin_v1->hostwin_v1);
			ADDR(access, access->w.hostwin_v1->addr);
			R_MKEYID(access, access->w.hostwin_v1->keyid);
			S_MKEYID(access, access->w.hostwin_v1->local_keyid);
			KIJ_ALG(access, access->w.hostwin_v1->kij_alg);
			KP_ALG(access, access->w.hostwin_v1->kp_alg);
			TUNNEL_ADDR(access, access->w.hostwin_v1->tunnel_addr);
			TUNNEL_LABEL(access,
					access->w.hostwin_v1->tunnel_label);
			build_v1_alg_menus(access);
			build_s_mkeyid_menu(access->local_keyid,
						SKIP_NSID_IPV4,
						NULL);
			break;

		case netwin:
			access->w.win =
				skiptool_netwin_v1_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.netwin_v1->skip_icon, version, nom);
			WIN(access, access->w.netwin_v1->netwin_v1);
			ADDR(access, access->w.netwin_v1->addr);
			MASK(access, access->w.netwin_v1->mask);
			R_MKEYID(access, access->w.netwin_v1->keyid);
			S_MKEYID(access, access->w.netwin_v1->local_keyid);
			KIJ_ALG(access, access->w.netwin_v1->kij_alg);
			KP_ALG(access, access->w.netwin_v1->kp_alg);
			TUNNEL_ADDR(access, access->w.netwin_v1->tunnel_addr);
			TUNNEL_LABEL(access, access->w.netwin_v1->tunnel_label);
			build_v1_alg_menus(access);
			build_s_mkeyid_menu(access->local_keyid,
						SKIP_NSID_IPV4,
						NULL);
			break;

		case nomwin:
			access->w.win =
				skiptool_nomwin_v1_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.nomwin_v1->skip_icon, version, nom);
			WIN(access, access->w.nomwin_v1->nomwin_v1);
			ADDR(access, access->w.nomwin_v1->current_addr);
			R_MKEYID(access, access->w.nomwin_v1->keyid);
			S_MKEYID(access, access->w.nomwin_v1->local_keyid);
			KIJ_ALG(access, access->w.nomwin_v1->kij_alg);
			KP_ALG(access, access->w.nomwin_v1->kp_alg);
			TUNNEL_ADDR(access, access->w.nomwin_v1->tunnel_addr);
			TUNNEL_LABEL(access, access->w.nomwin_v1->tunnel_label);
			build_v1_alg_menus(access);
			build_s_mkeyid_menu(access->local_keyid,
						SKIP_NSID_IPV4,
						NULL);
		}
		set_alg_selector(access->kij_alg, SKIP_DEFAULT_KIJ_ALG_EX);
		set_alg_selector(access->kij_alg, SKIP_DEFAULT_KIJ_ALG);
		set_alg_selector(access->kp_alg, SKIP_DEFAULT_KP_ALG_EX);
		set_alg_selector(access->kp_alg, SKIP_DEFAULT_KP_ALG);
		break;
		
	case SKIP_V2:
		switch (win_type) {
		case hostwin:
			access->w.win =
				skiptool_hostwin_v2_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.hostwin_v2->skip_icon, version, nom);
			WIN(access, access->w.hostwin_v2->hostwin_v2);
			ADDR(access, access->w.hostwin_v2->addr);
			R_NSID(access, access->w.hostwin_v2->r_nsid);
			R_MKEYID(access, access->w.hostwin_v2->keyid);
			S_NSID(access, access->w.hostwin_v2->s_nsid);
			S_MKEYID(access, access->w.hostwin_v2->local_keyid);
			KIJ_ALG(access, access->w.hostwin_v2->kij_alg);
			KP_ALG(access, access->w.hostwin_v2->kp_alg);
			MAC_ALG(access, access->w.hostwin_v2->mac_alg);
			SKIP_MODE(access, access->w.hostwin_v2->skip_mode);
			TUNNEL_ADDR(access, access->w.hostwin_v2->tunnel_addr);
			TUNNEL_LABEL(access,
					access->w.hostwin_v2->tunnel_label);
			build_v2_alg_menus(access);
			build_nsid_menu(access->r_nsid, B_TRUE);
			build_s_nsid_menu(access->s_nsid, SKIP_NSID_NONE);
			break;

		case netwin:
			access->w.win =
				skiptool_netwin_v2_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.netwin_v2->skip_icon, version, nom);
			WIN(access, access->w.netwin_v2->netwin_v2);
			ADDR(access, access->w.netwin_v2->addr);
			MASK(access, access->w.netwin_v2->mask);
			R_NSID(access, access->w.netwin_v2->r_nsid);
			R_MKEYID(access, access->w.netwin_v2->keyid);
			S_NSID(access, access->w.netwin_v2->s_nsid);
			S_MKEYID(access, access->w.netwin_v2->local_keyid);
			KIJ_ALG(access, access->w.netwin_v2->kij_alg);
			KP_ALG(access, access->w.netwin_v2->kp_alg);
			MAC_ALG(access, access->w.netwin_v2->mac_alg);
			SKIP_MODE(access, access->w.netwin_v2->skip_mode);
			TUNNEL_ADDR(access, access->w.netwin_v2->tunnel_addr);
			TUNNEL_LABEL(access, access->w.netwin_v2->tunnel_label);
			build_v2_alg_menus(access);
			build_nsid_menu(access->r_nsid, B_TRUE);
			build_s_nsid_menu(access->s_nsid, SKIP_NSID_NONE);
			break;

		case nomwin:
			access->w.win =
				skiptool_nomwin_v2_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.nomwin_v2->skip_icon, version, nom);
			WIN(access, access->w.nomwin_v2->nomwin_v2);
			ADDR(access, access->w.nomwin_v2->current_addr);
			R_NSID(access, access->w.nomwin_v2->r_nsid);
			R_MKEYID(access, access->w.nomwin_v2->keyid);
			S_NSID(access, access->w.nomwin_v2->s_nsid);
			S_MKEYID(access, access->w.nomwin_v2->local_keyid);
			KIJ_ALG(access, access->w.nomwin_v2->kij_alg);
			KP_ALG(access, access->w.nomwin_v2->kp_alg);
			MAC_ALG(access, access->w.nomwin_v2->mac_alg);
			SKIP_MODE(access, access->w.nomwin_v2->skip_mode);
			TUNNEL_ADDR(access, access->w.nomwin_v2->tunnel_addr);
			TUNNEL_LABEL(access, access->w.nomwin_v2->tunnel_label);
			build_v2_alg_menus(access);
			build_nsid_menu(access->r_nsid, B_FALSE);
			build_s_nsid_menu(access->s_nsid, SKIP_NSID_NONE);
		}
		set_alg_selector(access->kij_alg, SKIP_DEFAULT_KIJ_ALG_EX);
		set_alg_selector(access->kij_alg, SKIP_DEFAULT_KIJ_ALG);
		set_alg_selector(access->kp_alg, SKIP_DEFAULT_KP_ALG_EX);
		set_alg_selector(access->kp_alg, SKIP_DEFAULT_KP_ALG);
		set_alg_selector(access->mac_alg, SKIP_DEFAULT_MAC_ALG);
		break;

	case SKIP_RAW:
		switch (win_type) {
		case nomwin:
			alert(XV_NULL, SKIP_RAW_NOMADIC, B_TRUE);
			return (B_FALSE);

		case hostwin:
			access->w.win =
				skiptool_hostwin_raw_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.hostwin_raw->skip_icon,
								version, nom);
			WIN(access, access->w.hostwin_raw->hostwin_raw);
			ADDR(access, access->w.hostwin_raw->addr);
			R_MKEYID(access, access->w.hostwin_raw->keyid);
			S_MKEYID(access, access->w.hostwin_raw->local_keyid);
			KP_ALG(access, access->w.hostwin_raw->kp_alg);
			MAC_ALG(access, access->w.hostwin_raw->mac_alg);
			SKIP_MODE(access, access->w.hostwin_raw->skip_mode);
			TUNNEL_ADDR(access, access->w.hostwin_raw->tunnel_addr);
			TUNNEL_LABEL(access,
					access->w.hostwin_raw->tunnel_label);
			build_raw_alg_menus(access);
			break;

		case netwin:
			access->w.win =
				skiptool_netwin_raw_objects_initialize(NULL,
					Skiptool_base_window->base_window);
			ALLOC_CHECK(access->w.win);
			SET_ICON(access->w.netwin_raw->skip_icon, version, nom);
			WIN(access, access->w.netwin_raw->netwin_raw);
			ADDR(access, access->w.netwin_raw->addr);
			MASK(access, access->w.netwin_raw->mask);
			R_MKEYID(access, access->w.netwin_raw->keyid);
			S_MKEYID(access, access->w.netwin_raw->local_keyid);
			KP_ALG(access, access->w.netwin_raw->kp_alg);
			MAC_ALG(access, access->w.netwin_raw->mac_alg);
			SKIP_MODE(access, access->w.netwin_raw->skip_mode);
			TUNNEL_ADDR(access, access->w.netwin_raw->tunnel_addr);
			TUNNEL_LABEL(access,
					access->w.netwin_raw->tunnel_label);
			build_raw_alg_menus(access);
		}
		set_alg_selector(access->kp_alg, SKIP_DEFAULT_KP_ALG_EX);
		set_alg_selector(access->kp_alg, SKIP_DEFAULT_KP_ALG);
		set_alg_selector(access->mac_alg, SKIP_DEFAULT_MAC_ALG);
		break;
	}

	(void) xv_set(access->win, WIN_CLIENT_DATA, access, NULL);
	return (B_TRUE);
}

/* es_new_add()
 *
 * Make new add window
 */
static es_acl_t *
es_new_add(Xv_opaque list, int version, int win_type)
{
	es_acl_t	*access;

	access = es_new_access(list, version, win_type);
	if (access == NULL) {
		return (NULL);
	}
	if (!es_new_win(access, version, win_type)) {
		free(access);
		return (NULL);
	}
	es_make_add(access);
	return (access);
}

/* es_destroy_win()
 *
 */
static void
es_destroy_win(es_acl_t *access)
{
	if (access->win) {
		xv_destroy_safe(access->win);
	}
	free(access);
}

/* es_update_win_type()
 *
 * Determine if system has changed version or mode
 */
static boolean_t
es_update_win_type(es_acl_t *access, skip_param_t *new_params)
{
	if ((access->params.version == new_params->version) &&
		(es_win_type(&access->params) == es_win_type(new_params))) {
		/*
		 * nothing to do
		 */
		return (B_FALSE);
	}
	return (B_TRUE);
}

/*ARGSUSED*/
static void
null(es_acl_t *access)
{
}

/* systems_count()
 *
 * count the number of systems authorised to connect
 */
static int
systems_count()
{
	return (skip_acl_list(ifname, null));
}

static void
show_secure_icon()
{
	char				msg[STRSZ];
	Icon				icon;

	icon = xv_get(Skiptool_base_window->base_window, FRAME_ICON);
	if (icon) {
		sprintf(msg, "%s : on", ifname);
		xv_set(icon, ICON_TRANSPARENT_LABEL, msg, NULL);
	}
}

static void
show_unsecure_icon()
{
	char				msg[STRSZ];
	Icon				icon;

	icon = xv_get(Skiptool_base_window->base_window, FRAME_ICON);
	if (icon) {
		sprintf(msg, "%s : off", ifname);
		xv_set(icon, ICON_TRANSPARENT_LABEL, msg, NULL);
	}
}

/*
 * show current operating mode
 */
void
show_mode()
{
	int				n, mode = skip_get_mode(ifname);
	char				msg[STRSZ];
	extern int			skip_fd;

	n = systems_count();

	if (n < 0) {
		alert(XV_NULL, skip_errmsg, B_TRUE);
		return;
	}
	switch (mode) {

	case SkipAccessControlOff:
		show_unsecure_icon();
		set_footer("Access control disabled", B_FALSE);
		xv_set(Skiptool_base_window->access_ctrl,	
			PANEL_VALUE, 0,
			NULL);
		break;

	case SkipAccessControlOn:
		show_secure_icon();
		if (n == 1) {
			sprintf(msg, "Access control enabled, 1 entry.");
		} else {
			sprintf(msg, "Access control enabled, %d entries.", n);
		}
		set_footer(msg, B_FALSE);
		xv_set(Skiptool_base_window->access_ctrl,	
			PANEL_VALUE, skip_fd == -1 ? 1 : 2,
			NULL);
		break;

	default:
		show_unsecure_icon();
		set_footer("Access control failed", B_FALSE);
	}
}

/* es_pin_win()
 *
 * Make a window stay around
 */
static void
es_pin_win(Xv_opaque win)
{
	xv_set(win, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
}

/* es_getxy()
 *
 * Get current pointer position
 */
static void
es_getxy(int *x, int *y)
{
	int	     win_x, win_y, keys_buttons;
	Window		root, child;

	(void) XQueryPointer(display,
		RootWindow(display, DefaultScreen(display)),
		&root,
		&child,
		x, y,
		&win_x, &win_y,
		&keys_buttons);
}

/* es_set_defaults()
 *
 * Return an add window to its default state
 *
 * Returns: 0 on success, -1 otherwise
 */
static void
es_set_defaults(es_acl_t *access)
{
	if (access->mask) {
		xv_set(access->mask, PANEL_VALUE, SKIP_DEFMASK, NULL);
	}

	if (access->params.flags & SKIP_NOMADIC) {
		if (access->r_nsid) {
			xv_set(access->r_nsid, PANEL_VALUE, 0, NULL);
		}
		xv_set(access->keyid, PANEL_VALUE, "", NULL);
	} else {
		xv_set(access->addr, PANEL_VALUE, "", NULL);
	}
}

/* es_get_addrinfo()
 *
 * get addressing paramters
 */
static int
es_get_addrinfo(es_acl_t *access, skip_param_t *params, boolean_t ignore_errs)
{
	char					*addrstr, *maskstr, *tunnelstr,
						msg[STRSZ];

	if (access->addr) {
		addrstr = (char *) xv_get(access->addr, PANEL_VALUE);
		if (strcmp(addrstr, UNKNOWN) == 0) {
			params->ip_addr.s_addr = SKIP_UNKNOWNIP;
		} else {
			if (skip_host_to_addr(addrstr, &params->ip_addr) < 0) {
				if (!ignore_errs) {
					es_pin_win(access->win);
					alert(access->addr, skip_errmsg,B_TRUE);
				}
				return (-1);
			}
		}
	} else {
		params->ip_addr.s_addr = SKIP_UNKNOWNIP;
	}

	if (access->mask) {
		maskstr = (char *) xv_get(access->mask, PANEL_VALUE);
		params->mask.s_addr = inet_addr(maskstr);
		if (params->mask.s_addr == 0) {
			if (!ignore_errs) {
				es_pin_win(access->win);
				sprintf(msg, SKIP_BAD_NETMASK, maskstr);
				alert(access->addr, msg, B_TRUE);
			}
			return (-1);
		}
	} else {
		params->mask.s_addr = SKIP_HOSTMASK;
	}

	if (access->tunnel_addr) {
		tunnelstr = (char *) xv_get(access->tunnel_addr, PANEL_VALUE);
		if (strlen(tunnelstr) == 0) {
			tunnelstr = inet_ntoa(params->ip_addr);
		}
		if (skip_host_to_addr(tunnelstr, &params->tunnel_addr) < 0) {
			if (!ignore_errs) {
				es_pin_win(access->win);
				alert(access->addr, skip_errmsg, B_TRUE);
			}
			return (-1);
		}
	} else {
		params->tunnel_addr = params->ip_addr;
	}
	return(0);
}

/* es_get_params()
 *
 * Collect and validate window parameters
 *
 * Returns: 0 on success, -1 otherwise
 */
static int
es_get_params(es_acl_t *access, skip_param_t *params, boolean_t ignore_errs)
{
	char					*tunnelstr,
						*kij_algname, *kp_algname,
						*mac_algname,
						*r_mkeyidstr,
						*s_mkeyidstr,
						msg[STRSZ];
	boolean_t				nom;

	memset(params, 0, sizeof(*params));

	/*
	 * host information
	 */
	nom = (access->params.flags & SKIP_NOMADIC) != 0;

	if (access->is_add_win) {
		if (es_get_addrinfo(access, params, ignore_errs)) {
			return (-1);
		}
	} else {
		params->ip_addr = access->params.ip_addr;
		params->mask = access->params.mask;
	}

	if (access->tunnel_addr) {
		tunnelstr = (char *) xv_get(access->tunnel_addr, PANEL_VALUE);
		if (strlen(tunnelstr) == 0) {
			tunnelstr = (nom ? "*" : inet_ntoa(params->ip_addr));
		}
		if (skip_host_to_addr(tunnelstr, &params->tunnel_addr) < 0) {
			if (!ignore_errs) {
				es_pin_win(access->win);
				alert(access->addr, skip_errmsg, B_TRUE);
			}
			return (-1);
		}
	} else {
		params->tunnel_addr = params->ip_addr;
	}

	/*
	 * tunnel or transport mode
	 */
	if (access->skip_mode) {
	       switch (xv_get(access->skip_mode, PANEL_VALUE)) {
	       case 0:
		       params->ip_mode = SKIP_TRS_OFF;
		       break;
	       case 1:
		       params->ip_mode = SKIP_TRS_ON;
			params->tunnel_addr = params->ip_addr;
		       break;
		}
	}

	/*
	 * remote keying information
	 */
	switch (access->params.version) {
	case SKIP_NONE:
		params->r_nsid = SKIP_NSID_NONE;
		break;

	case SKIP_V1:
	case SKIP_RAW:
		params->r_nsid = SKIP_NSID_IPV4;
		break;

	case SKIP_V2:
		params->r_nsid = get_nsid_selector(access->r_nsid);
	}

	if (params->r_nsid) {
		r_mkeyidstr = (char *) xv_get(access->keyid, PANEL_VALUE);
		if (params->r_nsid && (strlen(r_mkeyidstr) == 0)) {

			if (nom) {
				/*
				 * must have a keyid in nomadic mode
				 */
				if (!ignore_errs) {
					es_pin_win(access->win);
					alert(access->keyid,
						SKIP_MISSING_KEYID, B_TRUE);
				}
				return (-1);
			}

			/*
			 * don't let the window go without a remote key id
			 * - unless its NSID IPv4 where we insert a default
			 */
			if (params->r_nsid == SKIP_NSID_IPV4) {
				r_mkeyidstr = inet_ntoa(params->ip_addr);
			} else {
				if (!ignore_errs) {
					es_pin_win(access->win);
					alert(access->keyid,
						SKIP_MISSING_KEYID, B_TRUE);
				}
				return (-1);
			}
		}
		if (skip_s_to_keyid(r_mkeyidstr, params->r_nsid,
						&params->r_mkeyid)) {
			if (!ignore_errs) {
				sprintf(msg, SKIP_BAD_THING,
				skip_nsids[params->r_nsid].name, r_mkeyidstr);
				es_pin_win(access->win);
				alert(access->keyid, msg, B_TRUE);
			}
			return (-1);
		}
	}

	/*
	 * local keying information
	 */
	switch (access->params.version) {
	case SKIP_NONE:
		params->s_nsid = SKIP_NSID_NONE;
		break;

	case SKIP_V1:
	case SKIP_RAW:
		params->s_nsid = SKIP_NSID_IPV4;
		break;

	case SKIP_V2:
		params->s_nsid = get_nsid_selector(access->s_nsid);
	}

	if (params->s_nsid) {
		if (access->params.version == SKIP_RAW) {
			s_mkeyidstr = (char *) xv_get(access->local_keyid,
								PANEL_VALUE);
		} else {
			s_mkeyidstr = (char *) xv_get(access->local_keyid,
				PANEL_CHOICE_STRING,
				xv_get(access->local_keyid, PANEL_VALUE));
		}

		if (strcmp(s_mkeyidstr, SKIP_DEFKEY) == 0) {
			if (access->params.version == SKIP_V1) {
				sprintf(msg, SKIP_MSG_NO_LOCALKEY_V1);
			} else {
				sprintf(msg, SKIP_MSG_NO_LOCALKEY, 
					skip_nsids[params->s_nsid].name);
			}
			alert(access->keyid, msg, B_TRUE);
			return (-1);
		}
		if (skip_s_to_keyid(s_mkeyidstr, params->s_nsid,
							&params->s_mkeyid)) {
			if (!ignore_errs) {
				sprintf(msg, SKIP_BAD_THING,
				skip_nsids[params->s_nsid].name, s_mkeyidstr);
				es_pin_win(access->win);
				alert(access->keyid, msg, B_TRUE);
			}
			return (-1);
		}
	}

	if (access->kij_alg) {
		kij_algname = (char *) xv_get(access->kij_alg,
					PANEL_CHOICE_STRING,
					xv_get(access->kij_alg, PANEL_VALUE));
		params->kij_alg	= skip_name_to_kij_alg(kij_algname,
						access->params.version);
	}
	if (access->kp_alg) {
		kp_algname = (char *) xv_get(access->kp_alg,
					PANEL_CHOICE_STRING,
					xv_get(access->kp_alg, PANEL_VALUE));
		params->kp_alg	= skip_name_to_kp_alg(kp_algname,
						access->params.version);
	}
	if (access->mac_alg) {
		mac_algname = (char *) xv_get(access->mac_alg,
					PANEL_CHOICE_STRING,
					xv_get(access->mac_alg, PANEL_VALUE));
		params->mac_alg	= skip_name_to_mac_alg(mac_algname,
						access->params.version);
	}
	params->comp_alg = 0;
	params->version = access->params.version;
	params->flags = access->params.flags;
	return (0);
}

void
es_win_apply(es_acl_t *access)
{
	es_acl_t				*new_access;
	skip_param_t				p, *params = &p;
	int					rc, rows;

	if (es_get_params(access, params, B_FALSE)) {
		return;
	}

	if (!access->is_add_win) {
		(void) skip_acl_del(ifname, params);
	}

	rc = skip_acl_add(ifname, params);

	if (rc < 0) {
		alert(access->win, skip_errmsg, B_TRUE);
		es_pin_win(access->win);
		return;
	}

	rows = xv_get(access->list, PANEL_LIST_NROWS);

	if (access->is_add_win) {
		/*
		 * create a permanent entry for the ACL
		 */
		new_access = es_new_access(access->list, access->params.version,
					es_win_type(params));
		if (new_access == NULL) {
			alert(access->win, SKIP_MSG_NOMEM, B_TRUE);
			return;
		}

		/*
		 * insert new host
		 */
		(void) xv_set(new_access->list,
			PANEL_LIST_INSERT, rows,
			PANEL_LIST_STRING, rows, acl_of(params),
			PANEL_LIST_GLYPH, rows, glyph_of(params->version, 
					(params->flags & SKIP_NOMADIC)),
			PANEL_LIST_CLIENT_DATA, rows, new_access,
			NULL);

		es_set_defaults(access);
		access = new_access;
	}
	access->params = *params;
	es_set_win(access, B_TRUE);

	/*
	 * check if an ACL entry is needed for the tunnel address
	 */
	es_check_tunnel(access);

	show_mode();
}

/* window cancel operation
 */
void
es_win_cancel(es_acl_t *access)
{
	Panel					panel;
	int					notice_stat;
	skip_param_t				p, *params = &p;
	char					msg[STRSZ];

	if (access->is_add_win) {
		es_close_win(access);
		return;
	}

	if (es_get_params(access, params, TRUE)) {
		es_close_win(access);
		return;
	}

	if ((access->params.ip_mode == params->ip_mode) &&
		PARAMSMATCH(&access->params, params)) {
		es_close_win(access);
		return;
	}

	panel = xv_get(access->list, PANEL_PARENT_PANEL);
	sprintf(msg, "You have changed the configuration for %s",
						acl_of(&access->params));
	(void) xv_create(panel,
			NOTICE,
			XV_SHOW, TRUE,
			NOTICE_LOCK_SCREEN, TRUE,
			NOTICE_MESSAGE_STRINGS, msg, NULL,
			NOTICE_BUTTON_YES, "Apply changes",
			NOTICE_BUTTON_NO, "Discard changes",
			NOTICE_STATUS, &notice_stat,
			NULL);
	if (notice_stat == NOTICE_YES) {
		es_win_apply(access);
	} else {
		es_set_win(access, B_TRUE);
	}
	es_close_win(access);
}

static Xv_opaque
es_otherlist(es_acl_t *access)
{
	if (access->list == alist) {
		return (xlist);
	} else {
		return (alist);
	}
}

/* es_swap_list()
 *
 * send an item to the other list
 */
static void
es_swap_list(es_acl_t * access)
{
	register int	i, rows, selected = -1;
	Xv_opaque	thislist = access->list;
	Xv_opaque	otherlist = es_otherlist(access);
	void		editor();

	/*
	 * find in current list
	 */
	rows = xv_get(access->list, PANEL_LIST_NROWS);
	for (i = 0; i < rows; i++) {
		if (access == (es_acl_t *) xv_get(thislist,
					PANEL_LIST_CLIENT_DATA, i, NULL)) {
			selected = i;
		}
	}
	if (selected == -1) {
		return;
	}
	/*
	 * delete it
	 */
	(void) xv_set(thislist, PANEL_LIST_DELETE, selected, NULL);

	/*
	 * and insert in other list
	 */
	access->list = otherlist;
	rows = xv_get(otherlist, PANEL_LIST_NROWS);
	(void) xv_set(otherlist,
		PANEL_LIST_INSERT, rows,
		PANEL_LIST_STRING, rows, acl_of(&access->params),
		PANEL_LIST_GLYPH, rows, glyph_of(access->params.version,
				(access->params.flags & SKIP_NOMADIC)),
		PANEL_LIST_CLIENT_DATA, rows, access,
		PANEL_LIST_SELECT, rows, TRUE,
		NULL);
	editor(otherlist, Select, rows);
}

/* host_swap()
 *
 * swap a host from list to list
 */
void
host_swap()
{
	es_acl_t				*access;
	int					selected;
	Xv_opaque				list;

	selected = xv_get(alist, PANEL_LIST_FIRST_SELECTED);
	if (selected != -1) {
		list = alist;
	} else {
		selected = xv_get(xlist, PANEL_LIST_FIRST_SELECTED);
		if (selected  != -1) {
			list = xlist;
		} else {
			return;
		}
	}

	access = (es_acl_t *) xv_get(list, PANEL_LIST_CLIENT_DATA, selected);
	if (skip_acl_del(ifname, &access->params) < 0) {
		alert(XV_NULL, skip_errmsg, B_TRUE);
		return;
	}
	access->params.flags ^= SKIP_EXCL;
	if (skip_acl_add(ifname, &access->params) < 0) {
		alert(XV_NULL, skip_errmsg, B_TRUE);
		return;
	}
	es_swap_list(access);
}

/* host_delete()
 *
 * remove a host
 */
void
host_delete()
{
	void					editor();
	es_acl_t				*access;
	int					selected, rows;
	Xv_opaque				list, otherlist;

	selected = xv_get(alist, PANEL_LIST_FIRST_SELECTED);
	if (selected == -1) {
		selected = xv_get(xlist, PANEL_LIST_FIRST_SELECTED);
		if (selected == -1) {
			return;
		} else {
			list = xlist;
		}
	} else {
		list = alist;
	}

	access = (es_acl_t *) xv_get(list, PANEL_LIST_CLIENT_DATA, selected);

	otherlist = es_otherlist(access);

	if (skip_acl_del(ifname, &access->params) < 0) {
		alert(XV_NULL, skip_errmsg, B_TRUE);
		return;
	}

	es_destroy_win(access);

	inform_list_delete(access->params.ip_addr);

	(void) xv_set(list, PANEL_LIST_DELETE, selected, NULL);
 
	rows = xv_get(list, PANEL_LIST_NROWS);
	if (rows) {
		if (selected == rows) {
			selected = rows - 1;
		}
		(void) xv_set(list,
				PANEL_LIST_SELECT, selected, TRUE,
				NULL);
		editor(list, Select, selected);
	} else {
		rows = xv_get(otherlist, PANEL_LIST_NROWS);
		if (rows) {
			editor(otherlist, Select, rows - 1);
		} else {
			(void) xv_set(Skiptool_base_window->to_x,
					PANEL_INACTIVE, TRUE,
					NULL);
			(void) xv_set(Skiptool_base_window->to_a,
					PANEL_INACTIVE, TRUE,
					NULL);
			(void) xv_set(Skiptool_base_window->delete_button,
					PANEL_INACTIVE, TRUE,
					NULL);
			(void) xv_set(Skiptool_base_window->delete_xbutton,
					PANEL_INACTIVE, TRUE,
					NULL);
		}
	}
	show_mode();
}

/* save_checks_done()
 *
 * done checking for good configuration before saving config
 */
void
save_checks_done()
{
	Menu		menu;
	Menu_item	save;
	void		acl_save();

	acl_save();
	menu = xv_get(Skiptool_base_window->settings_button, PANEL_ITEM_MENU);
	save = xv_get(menu, MENU_NTH_ITEM, 4);
	xv_set(save, MENU_INACTIVE, FALSE, NULL);
	done_checking_func = NULL;
}

/* save_checks()
 *
 * check for good configuration before saving config
 */
int
save_checks()
{
	Menu		menu;
	Menu_item	save;

	if (done_checking_func) {
		return (0);
	}

	menu = xv_get(Skiptool_base_window->settings_button, PANEL_ITEM_MENU);
	save = xv_get(menu, MENU_NTH_ITEM, 4);
	xv_set(save, MENU_INACTIVE, TRUE, NULL);
	done_checking_func = save_checks_done;
	return (required_systems_build());
}

/* acl_save()
 *
 * save the current acl
 */
void
acl_save()
{
	pid_t					pid;
	int					fd;
	char					s[STRSZ], *argv[5], acl[STRSZ];
	int					mode = skip_get_mode(ifname);

	if ((mode != SkipAccessControlOff)) {
		if (save_checks() == EBUSY) {
			return;
		}
	}
	sprintf(acl, "%sacl.%s", SKIP_DIR, ifname);

	if ((fd = open(acl, O_WRONLY | O_TRUNC | O_CREAT,
						S_IRUSR | S_IWUSR)) < 0) {
		sprintf(s, "Cannot save configuration to %s (error %d)", acl,
									errno);
		set_footer(s, B_TRUE);
		return;
	}
	close(fd);

	if (es_path(SKIPHOST_CMD) == NULL) {
		sprintf(s, "Cannot locate skiphost command");
		alert(alist, s, B_TRUE);
		return;
	}

	argv[0] = es_path(SKIPHOST_CMD);
	argv[1] = "-i";
	argv[2] = ifname;
	argv[3] = "-P";
	argv[4] = NULL;

	switch (pid = fork()) {

	case -1:
		perror("fork");
		return;

	case 0:	/* child */
		(void) freopen(acl, "w", stdout);
		execvp(*argv, argv);
		if (errno == ENOENT) {
			fprintf(stderr, "%s: command not found.\n", *argv);
		} else {
			perror("execvp");
		}
		_exit(0);
	default:
		sprintf(s, "Saving configuration to %s...", acl);
		set_footer(s, B_FALSE);
		(void) notify_set_wait3_func(Skiptool_base_window->base_window,
				notify_default_wait3, pid);
	}
}

/*
 * run a command
 */
static void
fork_command(char *cmd[], char *title)
{
	pid_t					pid;
	int					fd;
	struct rlimit				rl;

	if (getrlimit(RLIMIT_NOFILE, &rl) < 0) {
		return;
	}
	switch (pid = fork()) {

	case -1:
		perror("fork");
		return;

	case 0:	/* child */
		for (fd = 0; fd < rl.rlim_cur; fd ++) {
			(void) close(fd);
		}
		execvp(*cmd, cmd);
		if (errno == ENOENT) {
			fprintf(stderr, "%s: command not found.\n", *cmd);
		} else {
			perror("execvp");
		}
		_exit(0);
	default:
		set_footer(title, B_FALSE);
		(void) notify_set_wait3_func(Skiptool_base_window->base_window,
				notify_default_wait3, pid);
	}
}

/*
 * Display statistics by calling skipstat_ui
 */
void
stats(int which)
{
	char					*opt, *t, s[STRSZ], *argv[12];
	char					ifstats[STRSZ], *optarg = NULL;

	switch (which) {
	case 0:
		/*
		 * interface stats
		 */
		opt = "-I";
		sprintf(ifstats, "SKIP Interface Statistics (%s)", ifname);
		t = ifstats;
		break;

	case 1:
		/*
		 * header stats
		 */
		opt = "-h";
		t = "SKIP Header Statistics";
		break;

	case 2:
		/*
		 * V1 cryptor stats
		 */
		opt = "-c";
		optarg = "1";
		t = "SKIP (version 1) Algorithm Statistics";
		break;

	case 3:
		/*
		 * key stats
		 */
		opt = "-k";
		t = "SKIP Key Statistics";
		break;

	case 4:
		/*
		 * SKIP V2/Raw cryptor stats
		 */
		opt = "-c";
		optarg = "2";
		t = "SKIP Algorithm Statistics";
		break;

	case 5:
		/*
		 * MAC stats
		 */
		opt = "-m";
		t = "SKIP Authentication Statistics";
		break;
	}

	if (es_path(SKIPSTAT_CMD) == NULL) {
		sprintf(s, "Cannot locate skipstat command");
		alert(alist, s, B_TRUE);
		return;
	}

	if (es_path(SKIPSTAT_UI) == NULL) {
		sprintf(s, "Cannot locate skipstat_ui command");
		alert(alist, s, B_TRUE);
		return;
	}

	strcpy(s, es_path(SKIPSTAT_CMD));

	argv[0] = es_path(SKIPSTAT_UI);
	argv[1] = "-display";
	argv[2] = displayname;
	argv[3] = "-t";
	argv[4] = t;
	argv[5] = "--";
	argv[6] = s;
	argv[7] = "-i";
	argv[8] = ifname;
	argv[9] = opt;
	argv[10] = optarg;
	argv[11] = NULL;

	fork_command(argv, "Getting statistics...");
}

void
key_status()
{
	es_acl_t				*access;
	skip_param_t				*params;
	char					v[4], r_nsid[4], s[STRSZ],
						*host, *argv[8];
	int					selected;

	selected = xv_get(alist, PANEL_LIST_FIRST_SELECTED);

	if (selected == -1) {
		return;
	}

	if (es_path(KEYSTAT) == NULL) {
		sprintf(s, "Cannot locate key status command (%s)", KEYSTAT);
		alert(alist, s, B_TRUE);
		return;
	}

	access = (es_acl_t *) xv_get(alist, PANEL_LIST_CLIENT_DATA, selected);

	params = &access->params;

	host = "";	/* XXX */
	sprintf(v, "%d", params->version);
	sprintf(r_nsid, "%d", params->r_nsid);
	(void) skip_keyid_to_s(&params->r_mkeyid, params->r_nsid, s);

	argv[0] = es_path(KEYSTAT);
	argv[1] = "-display";
	argv[2] = displayname;
	argv[3] = host;
	argv[4] = v;
	argv[5] = r_nsid;
	argv[6] = s;
	argv[7] = NULL;

	fork_command(argv, "Getting key status...");
}

boolean_t
is_double_click(int row)
{
	static struct timeval	then = { 0, 0 };
	static int		last_row = -1, last_nrows = -1;
	struct timeval		now;
	unsigned long		delta;
	int			nrows;

	nrows = xv_get(alist, PANEL_LIST_NROWS);
	if (last_nrows == -1) {
		last_nrows = nrows;
	}
	if (nrows != last_nrows) {
		last_nrows = nrows;
		return (B_FALSE);
	}

	(void) gettimeofday(&now, NULL);
	delta = (now.tv_sec - then.tv_sec) * 1000000 +
					(now.tv_usec - then.tv_usec);
	then = now;

	if (row != last_row) {
		last_row = row;
		return (B_FALSE);
	}
	last_row = row;
	return (delta < 500*1000 ? B_TRUE : B_FALSE);
}

boolean_t
is_xdouble_click(int row)
{
	static struct timeval	then = { 0, 0 };
	static int		last_row = -1, last_nrows = -1;
	struct timeval		now;
	unsigned long		delta;
	int			nrows;

	nrows = xv_get(xlist, PANEL_LIST_NROWS);
	if (last_nrows == -1) {
		last_nrows = nrows;
	}
	if (nrows != last_nrows) {
		last_nrows = nrows;
		return (B_FALSE);
	}

	(void) gettimeofday(&now, NULL);
	delta = (now.tv_sec - then.tv_sec) * 1000000 +
					(now.tv_usec - then.tv_usec);
	then = now;

	if (row != last_row) {
		last_row = row;
		return (B_FALSE);
	}
	last_row = row;
	return (delta < 500*1000 ? B_TRUE : B_FALSE);
}

void
editor(Xv_opaque list, int op, int row)
{
	register es_acl_t		*access;
	register boolean_t		auth;
	register int			arows, xrows, old;
	register Xv_opaque		otherlist;
	Rect				this_win;
	int				x, y;

	access = (es_acl_t *) xv_get(list, PANEL_LIST_CLIENT_DATA, row);

	if (access == NULL) {
		fprintf(stderr, "access == NULL in editor\n");
		exit(1);
	}

	switch (op) {

	case Select:
		arows = xv_get(alist, PANEL_LIST_NROWS);
		xrows = xv_get(xlist, PANEL_LIST_NROWS);

		auth = (list == alist);

		otherlist = es_otherlist(access);

		old = xv_get(otherlist, PANEL_LIST_FIRST_SELECTED);

		(void) xv_set(list, PANEL_CHOOSE_NONE, FALSE, NULL);
		(void) xv_set(otherlist, PANEL_CHOOSE_NONE, TRUE, NULL);

		if (old >= 0) {
			(void) xv_set(es_otherlist(access), 
				PANEL_LIST_SELECT, old, FALSE,
				NULL);
		}
		(void) xv_set(Skiptool_base_window->to_a,
				PANEL_INACTIVE, auth,
				NULL);
		(void) xv_set(Skiptool_base_window->to_x,
				PANEL_INACTIVE, !auth,
				NULL);
		(void) xv_set(Skiptool_base_window->delete_button,
				PANEL_INACTIVE, (arows == 0) || !auth,
				NULL);
		(void) xv_set(Skiptool_base_window->delete_xbutton,
				PANEL_INACTIVE, (xrows == 0) || auth,
				NULL);
		break;

	case DblClick:
		if (access->win == XV_NULL) {
			if (!es_new_win(access, access->params.version,
					es_win_type(&access->params))) {
				alert(XV_NULL, SKIP_BADNEWWIN, B_TRUE);
				break;
			}
		}
		es_set_win(access, B_TRUE);
		if (xv_get(access->win, XV_SHOW) == 0) {
			frame_get_rect(access->win, &this_win);
			es_getxy(&x, &y);
			this_win.r_left = x;
			this_win.r_top = y;
			frame_set_rect(access->win, &this_win);
		}
		(void) xv_set(access->win, XV_SHOW, TRUE, NULL);
		break;
	}
}

/* acl_empty()
 *
 * empty the current kernel acl list
 */
static void
acl_empty()
{
	es_destroy_systems(&skip_acl);
}

/* acl_add()
 *
 * Add an entry to the kernel acl list
 */
static void
acl_add(skip_param_t *params)
{
	/*
	 * clean up the parameters
	 */
	if (params->s_nsid == SKIP_NSID_NONE) {
		KEYVARZERO(params->s_mkeyid);
	}
	if (params->r_nsid == SKIP_NSID_NONE) {
		KEYVARZERO(params->r_mkeyid);
	}
	es_add_system(&skip_acl, params, NULL);
}

/* acl_add_new()
 *
 * Merge new entries into the (un)authorised systems list
 */
static void
acl_add_new()
{
	es_system_t	*entry;
	skip_param_t	*params;
	es_acl_t	*access;
	Xv_opaque	list;
	int		selected;

	for (entry = skip_acl; entry; entry = entry->next) {

		params = &entry->params;

		if (params->flags & SKIP_EXCL) {
			list = xlist;
		} else {
			list = alist;
		}

		access = es_new_access(list, params->version,
							es_win_type(params));

		if (access == NULL) {
			alert(XV_NULL, SKIP_MSG_NOMEM, B_TRUE);
			return;
		}
		access->params = *params;

		(void) xv_set(list,
			PANEL_LIST_INSERT, 0,
			PANEL_LIST_STRING, 0, acl_of(params),
			PANEL_LIST_GLYPH, 0, glyph_of(params->version,
					(params->flags & SKIP_NOMADIC)),
			PANEL_LIST_CLIENT_DATA, 0, access,
			NULL);
	}
	if (xv_get(alist, PANEL_LIST_NROWS)) {
		(void) xv_set(alist, PANEL_LIST_SELECT, 0, TRUE, NULL);
		editor(alist, Select, 0);
	}

	selected = xv_get(xlist, PANEL_LIST_FIRST_SELECTED);
	if (selected != -1) {
		(void) xv_set(xlist, PANEL_LIST_SELECT, selected, FALSE, NULL);
	}
}

/* acl_update_old()
 *
 * Update existing entries in the (un)authorised systems list, removing
 * no longer existing entries.
 */
static void
acl_update_old()
{
	register int		n;
	register es_acl_t	*access;
	skip_param_t		params;

	/*
	 * examine authorised hostlist
	 */
	n = xv_get(Skiptool_base_window->hostlist, PANEL_LIST_NROWS);
	for (; n ; n--) {
		access = (es_acl_t *) xv_get(alist,
			PANEL_LIST_CLIENT_DATA, n - 1);

		if (es_find_system(&skip_acl, &access->params, &params)) {
			if (memcmp((char *) &access->params, 
					(char *) &params,
					sizeof(params)) != 0) {

				/*
				 * params have changed for a system
				 */
				if (es_update_win_type(access, &params)) {
					/*
					 * window type has changed, delete
					 * and re-add
					 */
					es_destroy_win(access);
					xv_set(alist,
						PANEL_LIST_DELETE, n - 1, NULL);
					es_add_system(&skip_acl, &params, NULL);
				} else {

					/*
					 * update parameters from the kernel
				 	 */
					access->params = params;

					/*
					 * check if we need to swap lists...
					 */
					if (access->params.flags & SKIP_EXCL) {
						es_swap_list(access);
					}
					es_set_win(access, B_TRUE);
				}
			}
		} else {
			/*
			 * system has been deleted from kernel
			 */
			es_destroy_win(access);
			(void) xv_set(alist, PANEL_LIST_DELETE, n - 1, NULL);
		}
	}

	/*
	 * examine unauthorised hostlist
	 */
	n = xv_get(xlist, PANEL_LIST_NROWS);
	for (; n ; n--) {
		access = (es_acl_t *) xv_get(xlist,
			PANEL_LIST_CLIENT_DATA, n - 1);

		if (es_find_system(&skip_acl, &access->params, &params)) {
			if (memcmp((char *) &access->params, 
					(char *) &params,
					sizeof(params)) != 0) {
				/*
				 * params have changed for a system
				 */
				if (es_update_win_type(access, &params)) {
					/*
					 * window type has changed, delete
					 * and re-add
					 */
					es_destroy_win(access);
					xv_set(xlist,
						PANEL_LIST_DELETE, n - 1, NULL);
					es_add_system(&skip_acl, &params, NULL);
				} else {

					/*
					 * update parameters from the kernel
				 	 */
					access->params = params;

					/*
					 * check if we need to swap lists...
					 */
					if (!(access->params.flags & SKIP_EXCL)) {
						es_swap_list(access);
					}
					es_set_win(access, B_TRUE);
				}
			}
		} else {
			/*
			 * system has been deleted from kernel
			 */
			es_destroy_win(access);
			xv_set(xlist, PANEL_LIST_DELETE, n - 1, NULL);
		}
	}
}

/*
 * create list of the current remote systems from the kernel
 */
void
acl_build()
{
	acl_empty();
	(void) skip_acl_list(ifname, acl_add);
	acl_update_old();
	acl_add_new();
}

/* required_systems_done()
 *
 * Handle the closure of the required systems window
 */
/*ARGSUSED*/
void
required_systems_done(Frame subframe)
{
	if (done_checking_func == NULL) {
		return;
	}
	access_update();

	(void) xv_set(Skiptool_required_win->required_win,
			FRAME_CMD_PUSHPIN_IN, FALSE,
			XV_SHOW, FALSE,
			NULL);	
	(*done_checking_func)();
}

/* required_systems_add()
 *
 * Add contents of required systems list
 */
void
required_systems_add()
{
	int		nrows, is_selected;
	skip_param_t	params;
	char		*s;

	memset(&params, 0, sizeof(skip_param_t));

	nrows = xv_get(Skiptool_required_win->required_list, PANEL_LIST_NROWS);

	for (; nrows ; nrows--) {
		is_selected = (boolean_t)
			xv_get(Skiptool_required_win->required_list,
				PANEL_LIST_SELECTED, nrows - 1);
		if (is_selected) {
			s = (char *)xv_get(Skiptool_required_win->required_list,
				PANEL_LIST_STRING, nrows - 1);
			s = strtok(s, " ");
			if (s == NULL) {
				continue;
			}
			if (skip_host_to_addr(s, &params.ip_addr) < 0) {
				continue;
			}
			params.mask.s_addr = SKIP_HOSTMASK;
			params.tunnel_addr = params.ip_addr;
			(void) skip_acl_add(ifname, &params);
		}
		(void) xv_set(Skiptool_required_win->required_list,
				PANEL_LIST_DELETE, nrows - 1,
				NULL);
	}
	required_systems_done(Skiptool_required_win->required_win);
}

/* enable_checks_done()
 *
 * done checking for good configuration before enabling SKIP
 */
void
enable_checks_done()
{
	xv_set(Skiptool_base_window->access_ctrl,
			PANEL_INACTIVE, FALSE,
			NULL);
	done_checking_func = NULL;
}

/* enable_checks()
 *
 * check for good configuration before enabling SKIP
 */
int
enable_checks()
{
	if (no_req_systems_check) {
		return (0);
	}

	if (done_checking_func) {
		return (0);
	}

	xv_set(Skiptool_base_window->access_ctrl,
			PANEL_INACTIVE, TRUE,
			NULL);

	done_checking_func = enable_checks_done;
	return (required_systems_build());
}

/* required_systems_build()
 *
 * Get required systems list
 */
int
required_systems_build()
{
	int		nrows;
	es_system_t	*syslist = NULL, *next_syslist;
	skip_param_t	params;
	char		host[STRSZ], label[STRSZ];
	struct in_addr	addr;
	Rect		base, this_win;

	frame_get_rect(Skiptool_base_window->base_window, &base);
	frame_get_rect(Skiptool_required_win->required_win, &this_win);
	this_win.r_left = base.r_left + 150;
	this_win.r_top = base.r_top + 200;
	frame_set_rect(Skiptool_required_win->required_win, &this_win);

	set_footer("Checking for required systems...", B_FALSE);

	notify_dispatch();

	es_get_broadcast_addr(&syslist);
	es_get_nis_servers(&syslist);
	es_get_dns_servers(&syslist);
	es_get_nfs_servers(&syslist);
	es_get_x11_display(&syslist);
	es_get_local_addr(&syslist);

	if (syslist == NULL) {
		(*done_checking_func)();
		return (0);
	}

	/*
	 * syslist holds the list of required systems.
	 */
	(void) xv_set(Skiptool_required_win->required_list,
		XV_SHOW, FALSE, NULL);	
	
	nrows = xv_get(Skiptool_required_win->required_list, PANEL_LIST_NROWS);

	for (; nrows ; nrows--) {
		(void) xv_set(Skiptool_required_win->required_list,
				PANEL_LIST_DELETE, nrows - 1,
				NULL);
	}

	for (; syslist; syslist = next_syslist) {
		next_syslist = syslist->next;
		
		memset(&params, 0, sizeof(params));
		params.ip_addr = syslist->params.ip_addr;
		params.mask.s_addr = SKIP_HOSTMASK;
		if ((skip_acl_get(ifname, &params) != 0) ||
				(params.ip_addr.s_addr == 0) ||
				(params.mask.s_addr != SKIP_HOSTMASK)) {
			/*
			 * host not present or matching a default rule
			 */
			(void) skip_addr_to_host(&syslist->params.ip_addr,host);

			/*
			 * make sure reverse mapping exists
			 */
			if (skip_host_to_addr(host, &addr) != 0) {
				/*
				 * reverse mapping is missing, use dot format
				 */
				strcpy(host,inet_ntoa(syslist->params.ip_addr));
			}
			sprintf(label, "%s (%s)", host, syslist->desc);
			(void) xv_set(Skiptool_required_win->required_list,
				PANEL_LIST_INSERT, 0,
				PANEL_LIST_SELECT, 0, TRUE,
				PANEL_LIST_STRING, 0, label,
				NULL);
		} 
		free((char *) syslist);
	}

	(void) xv_set(Skiptool_required_win->required_list,
		XV_SHOW, TRUE,
		NULL);	

	nrows = xv_get(Skiptool_required_win->required_list, PANEL_LIST_NROWS);
	if (nrows > 0) {
		if (nrows == 1) {
			sprintf(label, "1 address currently in use.");
		} else {
			sprintf(label, "%d addresses currently in use.", nrows);
		}
		(void) xv_set(Skiptool_required_win->required_message,
			PANEL_LABEL_STRING, label,
			NULL);
		window_bell(Skiptool_required_win->required_win);
		(void) xv_set(Skiptool_required_win->required_win,
			XV_SHOW, TRUE,
			FRAME_DONE_PROC, required_systems_done,
			NULL);	
		return (EBUSY);
	}
	(*done_checking_func)();
	return (0);
}

/*
 * retrieve current SKIP key management parameters and update the GUI with them
 */
void
get_key_params()
{
	int		var;
	int		rc;

	rc = skip_var_get(ifname, "skip_key_max_bytes", &var);

	if (rc < 0) {
		return;
	}

	(void) xv_set(Skiptool_key_params_win->skip_key_max_bytes,
			PANEL_VALUE,
			var/1024,
			NULL
	);

	rc = skip_var_get(ifname, "skip_key_max_idle", &var);

	if (rc < 0) {
		return;
	}

	(void) xv_set(Skiptool_key_params_win->skip_key_max_idle,
			PANEL_VALUE,
			var,
			NULL
	);
}

/*
 * set current SKIP key managment parameters from the GUI values
 */
void
set_key_params()
{
	int		var;
	int		rc;

	var = xv_get(Skiptool_key_params_win->skip_key_max_bytes, PANEL_VALUE);
	rc = skip_var_set(ifname, "skip_key_max_bytes", var * 1024);

	if (rc < 0) {
		return;
	}

	var = xv_get(Skiptool_key_params_win->skip_key_max_idle, PANEL_VALUE);
	rc = skip_var_set(ifname, "skip_key_max_idle", var);

	if (rc < 0) {
		return;
	}

}

/*
 * set current SKIP key managment parameters to default
 */
void
set_key_defaults()
{
	(void) xv_set(Skiptool_key_params_win->skip_key_max_bytes,
			PANEL_VALUE, 512,
			NULL);
	(void) xv_set(Skiptool_key_params_win->skip_key_max_idle,
			PANEL_VALUE, 30,
			NULL);
	set_key_params();
}

/*
 * load rasters
 */
static void
load_images()
{
	extern int				systems_list_notify();
	Icon					icon;
	int					screen_no, w, h, d;

#include "unknown.xbm"
#include "none.xbm"
#include "icon_v1.xbm"
#include "icon_v2.xbm"
#include "nomadic.xbm"

	screen_no = xv_get(screen, SCREEN_NUMBER);

	es_display_depth = DefaultDepth(display, screen_no);

	if ((unknown = es_readras(SKIP_UNKNOWN_ICON, &w, &h, &d)) == XV_NULL) {
		unknown = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, unknown_bits,
		XV_WIDTH, unknown_width,
		XV_HEIGHT, unknown_height,
		NULL);
	}
	if ((none = es_readras(SKIP_NONE_ICON, &w, &h, &d)) == XV_NULL) {
		none = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, none_bits,
		XV_WIDTH, none_width,
		XV_HEIGHT, none_height,
		NULL);
	}
	if ((icon_v1 = es_readras(SKIP_ICON_V1, &w, &h, &d)) == XV_NULL) {
		icon_v1 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v1_bits,
		XV_WIDTH, icon_v1_width,
		XV_HEIGHT, icon_v2_height,
		NULL);
	}
	if ((icon_v2 = es_readras(SKIP_ICON_V2, &w, &h, &d)) == XV_NULL) {
		icon_v2 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v2_bits,
		XV_WIDTH, icon_v2_width,
		XV_HEIGHT, icon_v2_height,
		NULL);
	}
	if ((nomadic = es_readras(SKIP_ICON_NOMADIC, &w, &h, &d)) == XV_NULL) {
		nomadic = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, nomadic_bits,
		XV_WIDTH, nomadic_width,
		XV_HEIGHT, nomadic_height,
		NULL);
	}
	skip = es_readras(SKIP_SMALL_ICON, &w, &h, &d);
	if (skip) {
		(void) xv_set(Skiptool_base_window->skip_icon,
			PANEL_LABEL_IMAGE,
			skip,
			NULL);
		(void) xv_set(Skiptool_required_win->skip_icon,
			PANEL_LABEL_IMAGE,
			skip,
			NULL);
		(void) xv_set(Skiptool_about_win->skip_icon,
			PANEL_LABEL_IMAGE,
			skip,
			NULL);
		icon = (Icon) xv_create(XV_NULL, ICON,
			ICON_IMAGE, skip,
			ICON_WIDTH, w,
			ICON_HEIGHT, h + 20,
			ICON_TRANSPARENT_LABEL, SKIP_OSNAME " SKIP",
			NULL);
		(void) xv_set(Skiptool_base_window->base_window,
			FRAME_ICON,
			icon,
			NULL);
	}
	(void) xv_set(Skiptool_about_win->message8,
		PANEL_LABEL_STRING,
		"SKIP v" SKIP_RELEASE,
		NULL);
}

/*
 * Initialise skiptool
 */
void
init(int argc, char *argv[])
{
	char		msg[STRSZ];
	extern char	*optarg;
	extern int	optind;
	int		opt;

	while ((opt = getopt(argc, argv, "n")) != EOF) {
		switch (opt) {
		case 'n':
			no_req_systems_check = B_TRUE;
			break;
		case '?':
			usage(argv[0]);
		}
	}

	switch (argc - optind) {
	case 0:
		strcpy(ifname, skip_default_if());
		break;
	case 1:
		strcpy(ifname, argv[optind]);
		break;
	default:
		usage(argv[0]);
	}

	progname = argv[0];

	display = (Display *) xv_get(Skiptool_base_window->base_window,
								XV_DISPLAY);
	screen = xv_get(Skiptool_base_window->base_window, XV_SCREEN);

	displayname = XDisplayName(NULL);
	if ((displayname == NULL) || (strlen(displayname) == 0)) {
		displayname = ":0.0";
	}

	load_images();

	if (skip_pre_checks(ifname)) {
		if (errno == EACCES) {
			fprintf(stderr, "%s\n", SKIP_MSG_NOTROOT);
		} else {
			fprintf(stderr, "%s\n", skip_errmsg);
			fprintf(stderr, "%s\n", SKIP_MSG_BADINSTALL);
		}
		exit(1);
	}

	if (skip_var_init(argv[0], ifname)) {
		exit(1);
	}

	if (!skip_if_module_present(ifname)) {
		sprintf(msg, SKIP_MSG_NO_PLUMB "\n", ifname);
		fprintf(stderr, msg);
		fprintf(stderr, "%s\n", SKIP_MSG_USE_SKIPIF);
		exit(1);
	}

	(void) skip_hostname(hostname, STRSZ);

	sprintf(msg, "%s (%s)", SKIP_MSG_PROGNAME, hostname);
	(void) xv_set(Skiptool_base_window->base_window,
			XV_LABEL, msg,
			NULL);

	show_mode();

	get_key_params();

	alist = Skiptool_base_window->hostlist;
	xlist = Skiptool_base_window->xhostlist;

	add_hostwin = es_new_add(alist, SKIP_NONE, hostwin);
	add_netwin = es_new_add(alist, SKIP_NONE, netwin);
	add_hostwin_v1 = es_new_add(alist, SKIP_V1, hostwin);
	add_netwin_v1 = es_new_add(alist, SKIP_V1, netwin);
	add_nomwin_v1 = es_new_add(alist, SKIP_V1, nomwin);
	add_hostwin_v2 = es_new_add(alist, SKIP_V2, hostwin);
	add_netwin_v2 = es_new_add(alist, SKIP_V2, netwin);
	add_nomwin_v2 = es_new_add(alist, SKIP_V2, nomwin);
	add_hostwin_raw = es_new_add(alist, SKIP_RAW, hostwin);
	add_netwin_raw = es_new_add(alist, SKIP_RAW, netwin);

	add_xhostwin = es_new_add(xlist, SKIP_NONE, hostwin);
	add_xnetwin = es_new_add(xlist, SKIP_NONE, netwin);
	add_xnomwin_v1 = es_new_add(xlist, SKIP_V1, nomwin);
	add_xnomwin_v2 = es_new_add(xlist, SKIP_V2, nomwin);

	if (!(add_hostwin && add_netwin && add_hostwin_v1 && add_netwin_v1 &&
		add_nomwin_v1 && add_hostwin_v2 && add_netwin_v2 &&
		add_nomwin_v2 && add_hostwin_raw && add_netwin_raw &&
		add_xhostwin && add_xnetwin && add_xnomwin_v1 &&
		add_xnomwin_v1)) {
		fprintf(stderr, "Could not create new window\n");
		exit(1);
	}

	Skiptool_hostwin = add_hostwin->w.win;
	Skiptool_netwin = add_netwin->w.win;
	Skiptool_hostwin_v1 = add_hostwin_v1->w.win;
	Skiptool_netwin_v1 = add_netwin_v1->w.win;
	Skiptool_nomwin_v1 = add_nomwin_v1->w.win;
	Skiptool_hostwin_v2 = add_hostwin_v2->w.win;
	Skiptool_netwin_v2 = add_netwin_v2->w.win;
	Skiptool_nomwin_v2 = add_nomwin_v2->w.win;
	Skiptool_hostwin_raw = add_hostwin_raw->w.win;
	Skiptool_netwin_raw = add_netwin_raw->w.win;

	es_make_exc(add_xhostwin);
	es_make_exc(add_xnetwin);
	es_make_exc(add_xnomwin_v1);
	es_make_exc(add_xnomwin_v2);

	acl_build();
	show_mode();
	sprintf(msg, "%s", ifname);
	(void) xv_set(Skiptool_base_window->base_window,
		FRAME_RIGHT_FOOTER, msg,
		XV_SHOW, TRUE,
		NULL);
	notify_dispatch();
	if (es_local_keys() == 0) {
		alert(Skiptool_base_window->base_window,
						SKIP_MSG_NOKEYS, B_TRUE);
	}
	(void) tick(Skiptool_base_window->base_window);
}
