/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_if.h	1.14 96/04/18 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * number of minors to create
 */
#define	SKIP_MAX_OPENS		16

/*
 * details of one minor
 */
typedef struct {
	struct ifqueue		q;
	struct proc		*sp_rsel;
	char			sp_flags;
} skip_softc_t;

/*
 * device flags
 */
#define	SKIP_RCOLL		1	/* read select collision */
#define	SKIP_NDELAY		2	/* open no delay */
#define	SKIP_BUSY		4	/* minor in use */

/*
 * skip pseudo-device priority
 */
#define	SKIP_PRI		(PZERO + 1)

/*
 * minor device reserved for key manager
 */
#define SKIP_KEYMGR_MINOR       (0)

/*
 * 4.x interface information
 */
typedef struct skip_es {
	struct skip_es	*next;
	char		if_name[SKIPSZ];/* e.g. "le0" */
	struct ifnet	*ifp;		/* network interface */
	int		(*if_output)();	/* default output handler */
	void		*sd;		/* skip descriptor */
	unsigned char	if_mode;	/* interface mode */
	int		notifier;	/* who to send events to */
	skip_es_hash_t	**hosthash;	/* host access control list */
	skip_es_hash_t	**nethash;	/* net access control list */
	unsigned long	netmask;	/* mask for net hashing */
	ioctl_if_stat_t	stats;		/* skip stats	*/
} skip_es_t;

/*
 * returns TRUE if SKIP is installed on an interface
 */
#define	SKIP_IF(ifp)		((ifp)->if_output == skip_ifoutput)

/*
 * returns TRUE if SKIP has processed this buffer
 */
#define	SKIP_DECRYPTED(m, skip_if) \
			(((m)->m_off == 20) && \
			(* (int *) ((caddr_t) (m) + MMINOFF) == (int) skip_if))

/* 
 * Macro to retrieve an ifnet 
 */ 
#define SKIP_IFUNIT(if_name)	 ifunit(if_name, strlen(if_name))

/*
 * function prototypes
 */
int			skip_ifopen(int, int);
int			skip_ifclose(int, int);
int			skip_ifioctl();
int			skip_ifselect(int, int);
int			skip_ifwrite(int, struct uio *);
int			skip_ifread(int, struct uio *);
void 			skip_key_tellkm( enum skip_msgs, skip_keycb_t *);

/*
 * exported functions
 */
extern skip_es_t	*skip_es_find_if(char *);
extern boolean_t	skip_es_ok(skip_es_t *,  struct in_addr *,
					skip_param_t *, struct ip *, int);
#ifdef  __cplusplus
}
#endif

