/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
#pragma ident "@(#)skip_params.C	1.9 96/09/06"

#include <skip_os.h>

#include "Bstream.h"
#include "skip_keymgr.h"
#include "skip_conf.h"
#include "skip_params.h"

SkipParams::SkipParams(const skip_param_t &from)
{
	ver	= from.version;
	kij_alg = from.kij_alg;
	kp_alg 	= from.kp_alg;
	mac_alg = from.mac_alg;
	comp_alg= from.comp_alg;
	l_nsid = from.s_nsid;
	if (l_nsid == 0)
		l_nsid = 1;
	r_nsid = from.r_nsid;
	if (r_nsid == 0)
		r_nsid = 1;
	l_mkeyid = Bstream(from.s_mkeyid.len, from.s_mkeyid.buf);
	r_mkeyid = Bstream(from.r_mkeyid.len, from.r_mkeyid.buf);
	counter_n = ntohl(from.counter_n);
	/* Switched to Tunnel Address on 9/5/96 */
	bcopy(&from.tunnel_addr, &tunnel_addr, sizeof(ip_addr));
	bcopy(&from.ip_addr, &ip_addr, sizeof(ip_addr));
}

SkipParams::SkipParams(){ }

#if 0
SkipParams::operator skip_param_t()
{
	skip_param_t ret;
	ret.version = ver;
	ret.kij_alg = kij_alg;
	ret.kp_alg = kp_alg;
	ret.mac_alg = mac_alg;
	ret.s_nsid = l_nsid;
	ret.s_mkeyid.len = l_mkeyid.getlength();
	memcpy(ret.s_mkeyid.buf, l_mkeyid.getdatap(), 
	l_mkeyid.getlength());

	ret.r_nsid = r_nsid;
	ret.r_mkeyid.len = r_mkeyid.getlength();
	memcpy(ret.r_mkeyid.buf, r_mkeyid.getdatap(), 
		r_mkeyid.getlength());
	ret.counter_n = counter_n;
	return ret;
}
#endif
