/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

#define DOT    '.'
#define DASH   '-'
#define SPC    'x'

morse::morse(){
  period=0;
  *cipher = '\0';
  keylen = 0;
}

int morse::execute_option(char option){
  switch(option){
    case SUBSTITUTE:
      substitute();
      break;
    case UNDO:
      undo();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

int morse::period_valid(){
  return TRUE;
}

int pollux::set_period(int newperiod=0){
  if(period_set == FALSE){
    keylen = 10;
    period = 1;

    setup_key();
    period_set = TRUE;
  }

  return period_set;
}

int morbit::set_period(int newperiod=0){
  if(period_set == FALSE){
    keylen = 9;
    period = 2;

    setup_key();
    period_set = TRUE;
  }

  return period_set;
}

int fmorse::set_period(int newperiod=0){
  if(period_set == FALSE){
    keylen = 26;
    period = 3;

    setup_key();
    period_set = TRUE;
  }

  return period_set;
}

void morse::substitute(){
  char temp_str[STRINGLENGTH];
  char letter;
  int number;

  prompt("What is the character? ");
  letter = get_char();

  prompt("What is the pattern to replace it? ");
  read_line(temp_str);

  /* Enter a number for using a preset pattern
  */
  if(sscanf(temp_str, "%d", &number) != 1){
    msgerror("Bad input.");
  }

  else{
    do_sub(letter, number-1);
  }
}

void pollux::substitute(){
  char letter, symbol[2];

  prompt("What is the character? ");
  letter = get_char();

  prompt("What is the pattern to replace it? ");
  symbol[0] = get_char();
  symbol[1] = '\0';

  if(symbol[0] != DOT && symbol[0] != DASH && symbol[0] != SPC)
    msgerror("Invalid symbol.");
  else if(letter -'0' > keylen || letter - '0' < 0)
    msgerror("Invalid character.");
  else{
    key[letter-'0'] = morse2num(symbol);
  }
}

void morse::do_sub(char letter, int number){
  int i;

  if(!isdigit(letter))
    msgerror("Bad input.");
  else{
    for(i = 0; i < keylen; i++){
      if(key[i] == number){
	key[i] = BLANK;
      }
    }

    key[letter - '1'] = number;
  }
}

void fmorse::do_sub(char letter, int number){
  int i;

  if(!isalpha(letter))
    msgerror("Bad input.");
  else{
    for(i = 0; i < keylen; i++){
      if(key[i] == number){
	key[i] = BLANK;
      }
    }

    key[letter - 'a'] = number;
  }
}

int morse::valid_pattern(char *pattern){
  int valid = TRUE;
  int i;

  if(strlen(pattern) > period)
    valid = FALSE;
  else for(i = 0; i < period; i++){
    if(pattern[i] != DASH && pattern[i] != DOT && 
       pattern[i] != SPC  && pattern[i] != BLANK)
    valid = FALSE;
  }
  if(strstr(pattern, "xxx"))
    valid = FALSE;
  
  return valid;
}

void morse::show_menu(){
  menu(1, "(S)ubstitute   (U)ndo   (W)rite   (Q)uit");
}

void morse::show_cipher(){
  char temp_cipher[CLENGTH];
  char temp_str[CLENGTH];
  int npl, i;

  *temp_cipher = '\0';
  npl = (int) (SCREENWIDTH * .9) / (period);

  for(i = 0; i < length; i++){
    /* First the number...
    */
    put_char(toupper(cipher[i]), (i%npl)*(period), (i/npl)*2 + 1);

    /* Now the morse...
    */
    strcpy(temp_str, get_morse(cipher[i]));
    if(!empty_string(temp_str))
      msgprint((i%npl)*(period), (i/npl)*2+1, "%s", temp_str);

    /* Keep track of the entire deciphering string so that we can
    ** decipher it later.
    */
    strcat(temp_cipher, temp_str);
  }

  /* Now translate the morse code and print it out
  */
  decrypt(temp_cipher);
  for(i = 0; temp_cipher[i]; i++)
    put_char(temp_cipher[i], (i%(npl*period)), (i/(npl*period))*2);
}

int morse::empty_string(char *string){
  return (int) strchr(string, BLANK);
}

void morse::decrypt(char *message){
  char *start, *end, letter;
  char temp_str[CLENGTH];
  int pos;

  start = end = message;

  while(*start){
    /* Set start to end and look for the next letter.
    */

    start = end;

    /* Increment end until it points to the next 'x' and copy the
    ** characters in the middle into a buffer.
    */

    pos = 0;
    while(*end && *end != SPC){
      temp_str[pos++] = *end;
      end++;
    }
    temp_str[pos] = '\0';

    /* Now translate the buffer into morse code
    */

    letter = morse2roman(temp_str);
    if(!letter)
      letter = BLANK;

    /* Now replace the character at the end position with the roman
    ** letter.
    */

    *(end-1) = letter;
    end++;
    start = end;
  }

  /* Now replace all of the dashes and dots with blanks so that we don't
  ** have this confusing string of characters.
  */

  for(start = message; *start; start++){
    if(*start == DOT || *start == DASH || *start == SPC)
      *start = BLANK;
  }
}

char morse::morse2roman(char *message){
  char value = '\0';
  int i;

  static char *morsealph[] = { ".-", "-...", "-.-.", "-..", ".", "..-.",
    "--.", "....", "..", ".---", "-.-", ".-..", "--", "-.", "---", ".--.",
    "--.-", ".-.", "...", "-", "..-", "...-", ".--", "-..-", "-.--", "--.."};
  
  if(! *message)
    value = '_';

  for(i = 0; i < 26; i++){
    if(strcmp(message, morsealph[i]) == 0){
      value = i+'a';
    }
  }

  return value;
}

void pollux::show_key(){
  int i;

  for(i = 0; i < keylen; i++){
    msgprint(i*2, 13, "%d", i);
    if(key[i] != BLANK)
      put_char(*num2morse(key[i]), i*2, 14);
    else
      put_char(BLANK, i*2, 14);
  }
}

void morbit::show_key(){
  int i, j;
  char *string;

  for(i = 0; i < keylen; i++){
    msgprint(i*2, 13, "%d", i+1);

    string = strdup(num2morse(i));
    put_char(string[0], i*2, 14);
    put_char(string[1], i*2, 15);
    put_char(BLANK,     i*2, 16);

    for(j = 0; j < keylen; j++){
      if(key[j] == i){
	put_char(j+'1', i*2, 16);
      }
    }

    (void) free(string);
  }
}

void fmorse::show_key(){
  int i, j;
  char *string;

  for(i = 0; i < keylen; i++){
    msgprint(i*3, 15, "%2d", i+1);

    string = strdup(num2morse(i));
    put_char(string[0], i*3+1, 16);
    put_char(string[1], i*3+1, 17);
    put_char(string[2], i*3+1, 18);
    put_char(BLANK,     i*3+1, 19);

    for(j = 0; j < keylen; j++){
      if(key[j] == i)
	put_char(j+'a', i*3+1, 19);
    }
    (void)free(string);
  }
}

char *morse::num2morse(int index){
  char temp_str[STRINGLENGTH];
  int pos=period-1, i;

  for(i = 0; i < period; i++){
    switch(index%3){
      case 0:
	temp_str[pos] = DOT;
	break;
      case 1:
	temp_str[pos] = DASH;
	break;
      case 2:
	temp_str[pos] = SPC;
	break;
    }
    index /= 3;
    pos--;
  }

  temp_str[period] = '\0';

  return temp_str;
}

int morse::morse2num(char *string){
  int value=0, mult;
  int pos=0;

  mult = 1;

  while(pos < period){
    switch(string[period-1-pos]){
      case BLANK:
	break;
      case DOT:
	break;
      case DASH:
	value += mult*1;
	break;
      case SPC:
	value += mult*2;
	break;
    }
    pos++;
    mult *= 3;
  }

  return value;
}

char *pollux::get_morse(char index){
  if(key[index - '0'] != BLANK)
    return num2morse(key[index-'0']);
  else
    return " ";
}

char *morbit::get_morse(char index){
  if(key[index - '1'] != BLANK)
    return num2morse(key[index-'1']);
  else
    return "  ";
}

char *fmorse::get_morse(char index){
  if(key[index-'a'] != BLANK)
    return num2morse(key[index-'a']);
  else
    return "   ";
}

void pollux::undo(){
  char number;
  int i;

  prompt("Undo which character? ");
  number = get_char();

  if(number == '*'){
    for(i = 0; i < keylen; i++){
      key[i] = BLANK;
    }
  }
  else if(number < '0' || number > '9')
    msgerror("Bad value.");
  else
    key[number - '0'] = BLANK;
}

void morbit::undo(){
  int number, i;

  prompt("Undo which character? ");
  number = get_char();

  if(number == '*'){
    for(i = 0; i < keylen; i++)
      key[i] = BLANK;
  }
  else if(number < '1' || number > keylen+'0')
    msgerror("Bad value.");
  else
    key[number-'1'] = BLANK;
  
  clear_to_prompt();
}

void fmorse::undo(){
  int i;
  char letter;

  prompt("Undo which character? ");
  letter = get_char();

  if(!isalpha(letter)){
    msgerror("Bad value.");
  }
  else if(letter == '*'){
    for(i = 0; i < keylen; i++){
      key[i] = BLANK;
    }
  }
  else{
    letter |= ' ';
    key[letter - 'a'] = BLANK;
  }
  
  clear_to_prompt();
}

void morse::decipher(char *string){
  int i;
  char temp_str[CLENGTH];
  *string = '\0';

  *temp_str = '\0';
  for(i = 0; i < length; i++)
    strcat(temp_str, get_morse(cipher[i]));
  
  decrypt(temp_str);

  /* Now remove all the spaces
  */

  for(i = 0; i < strlen(temp_str); i++){
    if(temp_str[i] == '_')
      *string++ = BLANK;
    else if(temp_str[i] != BLANK)
      *string++ = temp_str[i];
  }
  
  *string = '\0';
}

void morse::copy_key(char *string){
  int i;

  for(i = 0; i < keylen; i++){
    if(key[i] == BLANK)
      string[i] = ' ';
    else
      string[i] = key[i]+'0';
  }
  string[keylen] = '\0';
}

void morse::read_key(FILE *fptr){
  char temp_str[STRINGLENGTH];
  int i;

  fgets(temp_str, STRINGLENGTH, fptr);

  for(i = 0; i < keylen; i++)
    key[i] = BLANK;

  for(i = 0; i < keylen; i++){
    if(temp_str[i] != BLANK)
      key[i] = temp_str[i]-'0';
  }
}

int morse::get_cipher_from_file(FILE *fptr){
  int count=0;
  char c;

  while(!feof(fptr) && count < CLENGTH){
    c = getc(fptr);
    if(isdigit(c)){
      c |= ' ';
      cipher[count++] = c;
    }
  }
  if(count >= CLENGTH){
    msgerror("Cipher too long.  Truncating.");
  }
  cipher[count] = '\0';

  return count;
}

int fmorse::get_cipher_from_file(FILE *fptr){
  return cipherdata::get_cipher_from_file(fptr);
}

void morse::setup_key(){
  int i;

  for(i = 0; i < keylen; i++){
    key[i] = BLANK;
  }
}
