/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

cadenus::cadenus(){
  *cipher = '\0';
  ocipher = NULL;
  key = NULL;
  clen = 0;
  period = 0;
  period_set = FALSE;
}

int cadenus::execute_option(char option){
  switch(option){
    case ROTATE:
      rotate();
      break;
    case MOVE:
      move_stuff();
      break;
    case UNDO:
      undo();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}


int cadenus::set_period(int newperiod){
  int i;

  length = strlen(cipher);
  clen = 25;

  if(period_set == FALSE || newperiod){

    period = newperiod;

    if(!period){
      if( length%clen != 0){
	msgerror("Bad length for Cadenus cipher.  Length must be a multiple of 25.");
	period_set = FALSE;
      }
      else{
	length = strlen(cipher);
	period = length / clen;
	period_set = TRUE;
      }
    }
    delete key;
    key = new int[period];
    for(i = 0; i < period; i++)
      key[i] = i+1;
    period_set = TRUE;
  }

  return period_set;
}

void cadenus::init_cipher(){
  if(ocipher == NULL){
    ocipher = strdup(cipher);
    length = strlen(cipher);
    clen = 25;
  }
}

void cadenus::rotate(){
  int column, rot;
  char temp_str[STRINGLENGTH];

  /* Get the column
  */

  prompt("Rotate which column? ");
  read_line(temp_str);
  (void)sscanf(temp_str, "%d", &column);

  /* Get the amount to rotate
  */

  prompt("Rotate down by how much? ");
  read_line(temp_str);
  if(sscanf(temp_str, "%d", &rot) != 1){
    msgerror("Bad rotation value.");
  }
  else if(column > 0 && column <= period){
    column--;
    rotate_column(column, rot%25);
  }
  else{
    msgerror("Bad values.");
  }
}

void cadenus::move_stuff(){
  char temp_str[STRINGLENGTH];
  int column1, column2;

  prompt("Interchange which two columns/rows? (ex: 1,2) ");
  read_line(temp_str);
  if(sscanf(temp_str, "%d,%d", &column1, &column2) != 2)
    msgerror("Bad input format.");
  else if(column1 <= period && column2 <= period && column1 > 0 && column2 > 0){
    column1--, column2--;
    interchange_columns(column1, column2);
  }
  
  else{
    msgerror("Bad column number.");
  }
}

void cadenus::show_menu(){
  menu(1, "(R)otate column     (M)ove columns     (U)ndo changes   (W)rite   (Q)uit");
}

void cadenus::show_key(){
}

void cadenus::show_cipher(){
  int i;

  /* Print the row/column numbers
  */

  for(i = 0; i < period; i++)
    (void)put_char((i+1)%10 + '0', 2*i+3, 0);
  
  if(clen > 17)
    for(i = 0; i < period; i++)
      (void)put_char((i+1)%10 + '0', 2*i+2*period+8, 0);

  /* Print the cipher
  */

  for(i = 0; i < length; i++){
    if(i < 17*period)
      (void)put_char(cipher[i], (i%period)*2+3, (i/period) + 2);
    else
      (void)put_char(cipher[i], (i%period)*2+8+2*period, (i/period) + 2-17);
  }
}

void cadenus::decipher(char *string){
  strcpy(string, cipher);
}

void cadenus::copy_key(char *string){
  int i;

  for(i = 0; i < period; i++)
    string[i] = (char) (key[i] + '0');
  
  string[period] = '\0';
}

void cadenus::read_key(FILE *fptr){
  char temp_str[STRINGLENGTH];
  int i;

  fgets(temp_str, STRINGLENGTH, fptr);

  for(i = 0; i < period; i++)
    key[i] = temp_str[i] - '0';
}
