#!/usr/local/bin/perl
while(<STDIN>){
	($name,$sig,$kex,$ciph,$digest)=split(/\s+/);
	
	$name=~s/TLS/SSL/;

	if($sig eq "-"){
	  $sig="anon";
	}
	
	if($kex=~/(.*)_EXPORT/){
	  $kex=$1;
	  $export="true";
	}
	else{
	  $export="false";
	}
	if($kex=~/DHE/){
	  $require_ske="true";
	  $kex="DH";
	}
	else {
	  $require_ske=false;
	}
	
	%CIPH_BYTES=("RC4_40",16,
		    "RC4_128",16,
		    "RC2_CBC_40",16,
		    "IDEA_CBC",16,
		    "DES40_CBC",8,
		    "DES_CBC",8,
		    "3DES_EDE_CBC",24);
	
	%CIPH_NAMES=("RC4_40","RC4",
		    "RC4_128","RC4",
		    "RC2_CBC_40","RC2",
		    "IDEA_CBC","IDEA",
		    "DES40_CBC","DES",
		    "DES_CBC","DES",
		    "3DES_EDE_CBC","DES-EDE3");

	if($ciph=~/RC4/){
	  $block="false";
	}
	else{
	  $block="true";
	}
	$ciph_name=$CIPH_NAMES{$ciph};
	$ciph_bytes=$CIPH_BYTES{$ciph};
	if($export eq 'false'){
	  $effective_bytes=$ciph_bytes;
	}
	else{
	  $effective_bytes=5;
	}

	if($digest eq "SHA") {$dig_bytes=20;}
	else {$dig_bytes=16;}

print <<FOO;
	new SSLCipherSuite(
	    $name, "$name",
	    SSL_KEX_$kex, SSL_SIG_$sig, "$digest", $dig_bytes, 
	    "$ciph_name", $ciph_bytes, $effective_bytes, $require_ske, $export, $block),
FOO
}
