/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	    Copyright (C) 1996, John Ioannidis <ji@hol.gr>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * $Id: tncfg.c,v 0.5 1997/06/03 04:31:55 ji Rel $
 *
 * $Log: tncfg.c,v $
 * Revision 0.5  1997/06/03 04:31:55  ji
 * New file.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <linux/types.h>
#include <linux/if.h>

struct ipsectunnelconf
{
	__u32	cf_cmd;
	union
	{
		char 	cfu_name[12];
	} cf_u;
#define cf_name cf_u.cfu_name
};

#define IPSEC_SET_DEV	(SIOCDEVPRIVATE)

void usage(char *name)
{	
	fprintf(stderr,"%s attach <virtual-device> <real-device>\n", name);
	exit(1);
}

void main(int argc, char *argv[])
{
	int s=socket(AF_INET, SOCK_DGRAM,0);
	if(s==-1)
	{
		perror("socket");
		exit(1);
	}
	if(argc!=4)
		usage(argv[0]);
	if(strcmp(argv[1],"attach")==0)
	{
		struct ifreq ifr;
		struct ipsectunnelconf *shc=(struct ipsectunnelconf *)&ifr.ifr_data;
		strcpy(ifr.ifr_name, argv[2]);
		strcpy(shc->cf_name, argv[3]);
		shc->cf_cmd = IPSEC_SET_DEV;
		if(ioctl(s, IPSEC_SET_DEV, &ifr)==-1)
		{
			perror("attach");
			exit(1);
		}
		exit(0);
	}
	usage(argv[0]);
}
