/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * $Id: ipsec_ipe4.c,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_ipe4.c,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanup.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#include "ipsec_ipe4.h"

struct sk_buff *
ipe4_input(struct sk_buff *skb, struct tdb *tdbp)
{
	printk("ipe4_input: why was I called?\n");
	
	return skb;
}

int
ipe4_attach(void)
{
	printk("ipe4_attach: called.\n");
	return 0;
}

/*
 * ipe4_init() is called when an SPI is being set up. It interprets the
 * encap_msghdr present in m, and sets up the transformation data.
 */

int
ipe4_init(struct tdb *tdbp, struct xformsw *xsp, struct encap_msghdr *em)
{
	struct ipe4_xdata *xd;
	
	tdbp->tdb_xform = xsp;

	tdbp->tdb_xdata = (caddr_t)kmalloc(sizeof (struct ipe4_xdata), GFP_ATOMIC); /* XXX - memory leak here if updating old TDB */

	if (tdbp->tdb_xdata == NULL)
	  return ENOBUFS;
	memset(tdbp->tdb_xdata, 0, sizeof (struct ipe4_xdata));
	xd = (struct ipe4_xdata *)tdbp->tdb_xdata;

	if (em->em_msglen - EMT_SETSPI_FLEN != EMT_IPE4_ULEN)
	{
		kfree((caddr_t)tdbp->tdb_xdata);
		tdbp->tdb_xdata = NULL;
		return EINVAL;
	}
	
	memcpy((caddr_t)xd, em->em_dat, EMT_IPE4_ULEN);
	return 0;
}

int ipe4_zeroize(struct tdb *tdpb)
{
	return 0;
}

int ipe4_print(void *xdat, char *buf)
{
	int size;
	u_long s, d;
	
	struct ipe4_xdata *xd = (struct ipe4_xdata *)xdat;
	s = xd->i4_src.s_addr;
	d = xd->i4_dst.s_addr;
	
	size = sprintf(buf, "[%d.%d.%d.%d -> %d.%d.%d.%d]",
		       O4(s), O3(s), O2(s), O1(s), 
		       O4(d), O3(d), O2(d), O1(d));
	return size;
}

int
ipe4_room(struct tdb *tp, int iphlen, int tlen, int *hr, int *tr)
{
	*hr += 20;
	*tr += 0;
	return 0;
}

int ipe4_output(struct sk_buff *skb, struct tdb *tdbp)
{

	struct iphdr *iph;
	struct ipe4_xdata *ixd = (struct ipe4_xdata *)(tdbp->tdb_xdata);

	skb->h.iph = (struct iphdr *) skb_push(skb, sizeof (struct iphdr));

	/*
	 *	Push down and install the IPIP header (from new_tunnel.c)
	 */
	 
	iph 			=	skb->h.iph;
	iph->version		= 	4;
	iph->tos		=	skb->ip_hdr->tos;
	iph->ttl		=	skb->ip_hdr->ttl;
	iph->frag_off		=	0;
	iph->daddr		=	ixd->i4_dst.s_addr;
	iph->saddr		=	ixd->i4_src.s_addr;
	iph->protocol		=	IPPROTO_IPIP;
	iph->ihl		=	5;
	iph->tot_len		=	htons(skb->len);
	iph->id			=	htons(ip_id_count++);	/* Race condition here? */
	skb->ip_hdr 		=	skb->h.iph;

	iph->check = 0;
	iph->check = ip_fast_csum((unsigned char *)iph, iph->ihl);

	return 0;
}
