#if !defined(_utmp_deslogind_h)		/* sparc defines <utmp.h> _utmp_h */
#define _utmp_deslogind_h

/*
 * Sun's Solaris has two types of utmp/wtmp file:
 *    1) /var/adm/utmp.h   /var/adm/wtmp.h 	- based on <utmp.h>
 *    2) /var/adm/utmpx.h /var/adm/wtmpx.h 	- based upon <utmpx.h>
 *
 * There is a problem with each:
 *    1) there is no remote host entry in struct utmp.
 *    2) if utmpx is updated, utmp must be also or it isn't visible.
 *
 * This code will uses solution 1 above, which works on solaris too.
 * If you want solution 2 instead, add -DUTMPX to the cc command.
 */
#if defined(UTMPX) /* { */	/* utmpx.h requires (struct timeval) */
#include <utmpx.h>		/* <utmp.h> UTMPX_FILE (struct utmpx) */
#else /* } { */
#include <utmp.h>		/* UTMP_FILE WTMP_FILE (struct utmp) */
#endif /* } */

/*
 * Get the name of the utmp and wtmp files from anywhere you can.  
 * Precedence is from CCFLAGS, <utmp.h>, hardwired
 * Don't use a symbol that conflicts with previous definitions.
 */
#if defined(_PATH_UTMP)	/* { from CCFLAGS */
#undef  UTMP_FILE			/* previously defined in <utmp.h> */
#define UTMP_FILE	_PATH_UTMP
#endif	/* } */

#if !defined(UTMP_FILE)	/* { */
#define UTMP_FILE	"/etc/utmp"		/* also /var/adm/utmp */
#endif	/* } */

#if defined(_PATH_WTMP)	/* { from CCFLAGS */
#undef  WTMP_FILE			/* previously defined in <utmp.h> */
#define WTMP_FILE	_PATH_WTMP
#endif	/* } */

#if !defined(WTMP_FILE)	/* { */
#define WTMP_FILE	"/etc/wtmp"		/* also /var/adm/wtmp */
#endif	/* } */

#if defined(__STDC__) || defined(__cplusplus)
extern int setlogin(
   char *ttydevicepath, char *username, char *rhost, int *exitstatloc);
extern char *getLoginName(void);
#else
extern int setlogin();
extern char *getLoginName();		/* A non-utmp dependent getlogin() */
#endif

#endif
