/* -*- C -*- */
/* @(#)$Id: rxkad.h,v 1.10 1997/08/20 17:18:23 bg Exp $ */

#ifndef __RXKAD_H
#define __RXKAD_H

/* Krb4 tickets can't have a key version number of 255. This is used
 * as a magic kvno to indicate that this is really a krb5 ticket. The
 * real kvno can be retrieved from the cleartext portion of the
 * ticket. For more info see the Transarc rxkad.h.
 */
#define RXKAD_TKT_TYPE_KERBEROS_V5 256

/* Is this really large enough for a krb5 ticket? */
#define MAXKRB5TICKETLEN	1024

typedef char rxkad_level;
#define rxkad_clear 0		/* send packets in the clear */
#define rxkad_auth 1		/* send encrypted sequence numbers */
#define rxkad_crypt 2		/* encrypt packet data */

extern int rxkad_EpochWasSet;

int32 rxkad_GetServerInfo __P((struct rx_connection *con,
			       rxkad_level *level,
			       u_int32 *expiration,
			       char *name,
			       char *instance,
			       char *cell,
			       int32 *kvno));

struct rx_securityClass *
rxkad_NewServerSecurityObject __P((/*rxkad_level*/ int min_level,
				   void *appl_data,
				   int (*get_key)(void *appl_data,
						  int kvno,
						  des_cblock *key),
				   int (*user_ok)(char *name,
						  char *inst,
						  char *realm,
						  int kvno)));

struct rx_securityClass *
rxkad_NewClientSecurityObject __P((/*rxkad_level*/ int level,
				   void *sessionkey,
				   int32 kvno,
				   int ticketLen,
				   char *ticket));

#define RXKADINCONSISTENCY	(19270400L)
#define RXKADPACKETSHORT	(19270401L)
#define RXKADLEVELFAIL		(19270402L)
#define RXKADTICKETLEN		(19270403L)
#define RXKADOUTOFSEQUENCE	(19270404L)
#define RXKADNOAUTH		(19270405L)
#define RXKADBADKEY		(19270406L)
#define RXKADBADTICKET		(19270407L)
#define RXKADUNKNOWNKEY		(19270408L)
#define RXKADEXPIRED		(19270409L)
#define RXKADSEALEDINCON	(19270410L)
#define RXKADDATALEN		(19270411L)
#define RXKADILLEGALLEVEL	(19270412L)

#endif /* __RXKAD_H */
