#include "rxkad_locl.h"

RCSID("$Id: rxk_info.c,v 1.4 1997/07/24 11:14:11 bg Exp $");

int32
rxkad_GetServerInfo(struct rx_connection *con,
		    rxkad_level *level,
		    unsigned int *expiration,
		    char *name,
		    char *instance,
		    char *cell,
		    int32 *kvno)
{
  serv_con_data *cdat = (serv_con_data *) con->securityData;

  if (cdat && cdat->authenticated
      && (time(0) < cdat->expires)
      && cdat->user)
    {
      if (level)
	*level = cdat->cur_level;
      if (expiration)
	*expiration = cdat->expires;
      if (name)
	strcpy(name, cdat->user->name);
      if (instance)
	strcpy(instance, cdat->user->instance);
      if (cell)
	strcpy(cell, cdat->user->realm);
      if (kvno)
	*kvno = -1;		/* Where do we find this and who needs it? */
      return 0;
    }
  else
    return RXKADNOAUTH;
}
