#include "krb_locl.h"

RCSID("$Id: create_ciph.c,v 1.4 1996/05/15 03:39:36 joda Exp $");

/*
 * This routine is used by the authentication server to create
 * a packet for its client, containing a ticket for the requested
 * service (given in "tkt"), and some information about the ticket,
 *
 * Returns KSUCCESS no matter what.
 *
 * The length of the cipher is stored in c->length; the format of
 * c->dat is as follows:
 *
 * 			variable
 * type			or constant	   data
 * ----			-----------	   ----
 * 
 * 
 * 8 bytes		session		session key for client, service
 * 
 * string		service		service name
 * 
 * string		instance	service instance
 * 
 * string		realm		KDC realm
 * 
 * unsigned char	life		ticket lifetime
 * 
 * unsigned char	kvno		service key version number
 * 
 * unsigned char	tkt->length	length of following ticket
 * 
 * data			tkt->dat	ticket for service
 * 
 * 4 bytes		kdc_time	KDC's timestamp
 *
 * <=7 bytes		null		   null pad to 8 byte multiple
 *
 */

/* Text block to hold ciphertext */
/* Session key to send to user */
/* Service name on ticket */
/* Instance name on ticket */
/* Realm of this KDC */
/* Lifetime of the ticket */
/* Key version number for service */
/* The ticket for the service */
/* KDC time */
/* Key to encrypt ciphertext with */

int
create_ciph(KTEXT c, unsigned char *session, 
	    char *service, char *instance, char *realm, 
	    u_int32_t life, int kvno, KTEXT tkt, 
	    u_int32_t kdc_time, des_cblock *key)
{
    unsigned char *p = c->dat;

    memset(c, 0, sizeof(KTEXT_ST));

    memcpy(p, session, 8);
    p += 8;
    
    p += put_nir(service, instance, realm, p);
    
    p += put_int(life, p, 1);
    p += put_int(kvno, p, 1);

    p += put_int(tkt->length, p, 1);

    memcpy(p, tkt->dat, tkt->length);
    p += tkt->length;

    p += put_int(kdc_time, p, 4);

    /* multiple of eight bytes */
    c->length = (p - c->dat + 7) & ~7;

    encrypt_ktext(c, key, DES_ENCRYPT);
    return KSUCCESS;
}
