//
//
//
// Negotiator.cpp
//
//
#include <Windows.h>
#include "Negotiator.h"

Option** debugoptions;

Negotiator::Negotiator (CharStream *str, TelnetEngine *te)
{
	ZeroMemory(options, sizeof(options));
	mTelnetEngine  = te;
	stream = str;
	defaultOption = new DenyAllOption(str, te);
	debugoptions = (Option**)&options;
}

Negotiator::~Negotiator ()
{
	delete defaultOption;
}

void
Negotiator::RegisterOption (Option *newOption)
{
	options[newOption->option] = newOption;
}

Option *
Negotiator::FindOptionFor (unsigned char option)
{
	Option *item = options[option];
	if(!item)
		item = defaultOption; 
	return item;
}

void Negotiator::Negotiate ()
{
	
	unsigned char command, option;
	
	if(!stream->GetChar (&command))	return;
	if(!stream->GetChar (&option))	return;
	
	(FindOptionFor (option))->NegotiateOption (command);
}
