
#ifndef EMULATORENGINE_H
#define EMULATORENGINE_H

/*#ifndef TELNETENGINE_H
class TelnetEngine;
#endif
*/
#include "TerminalEngine.h"
#include "CharStream.h"

#ifndef ANSI_BOOLEAN
#define Boolean BOOL
#define true TRUE
#define false FALSE
#endif

const int bufSize = 100;
typedef		unsigned char	AttributeWord;

class EmulatorEngine  : public TerminalEngine {

public:
	void Open(void);
	int UpdateWindowSize(void);
	int SetWindowSize(int Width, int Height);
	void DoVT100Command(char Command);
	enum { class_ID = 'EMUL' };
	enum {	attrOff = 16,
			Off = 0,
			Bold = 1,
			Underscore = 4,
			Blink = 5,
			Reverse = 7 };
	enum {	cursorKeysApplMode	=	1<<0,
			ansiMode			=	1<<1,
			columnMode			=	1<<2,
			scrollingMode		=	1<<3,
			screenMode			=	1<<4,
			originMode			=	1<<5,
			autoWrapMode		=	1<<6,
			autoRepeatMode		=	1<<7,
			interlaceMode		=	1<<8,
			keypadApplMode		=	1<<9,
			newLineMode			=	1<<19};

	//TelnetEngine			*host;

	EmulatorEngine(TelnetSession*);						
	void					ReceiveBuffer(unsigned char *buffer, int bufSZ);
	void 					ReceivedFromHost(CharStream *);
	
	void					SendExtended(WPARAM Key);
	void					ConvertSendToHost(char c, char keyCode);
	void					Send(char *buf, unsigned int buflen);
private:
	void DoWriteBfr(unsigned char* Buffer, unsigned int BufSZ);
	int homeRow, homeCol, scrlRegTop, scrlRegBottom, windowRows, windowCols;
	int marginLeft, marginRight;
	int savedCursorPosX, savedCursorPosY, savedAttr, currentAttr;
	long terminalMode;

	char buffer[bufSize];
	int bufIndex;


	void		Reset(void);
	BOOL			ReadModeArgs(	CharStream *stream,
									int *arv,
									int *arc,
									unsigned char *lookAhead);
			
	void	SetMode(char c, int *arv, int arc);
	void 	AnswerHost(BOOL vt100, char *s, int len);
	int		ComposeEscString(char *string,int *arguments, int argCount, char command);
	BOOL
	ReadNum(CharStream *stream, char c, int *num, unsigned char *lookAhead);

	BOOL MatchEscSequence(CharStream *stream, BOOL vt100, char *pat, int patLen);
	BOOL
	ReadArgs(CharStream *stream, int *arv, int *arc, unsigned char *lookAhead);
	AttributeWord ExtractArg(int *arv, int arc);
	void SetAttr(AttributeWord attr);
	inline void ConvVT100Coord(int *newRow, int *newCol, int row, int col);
	inline void ConvTermCoord(int *newRow, int *newCol, int row, int col);
	void UnimplementedEscSequence(CharStream *stream, char *msg);	
	void UnrecognizedEscSequence(CharStream *stream, char c);

};


#endif	// EMULATORENGINE_H
