#ifndef CHARSTREAM_H
#define CHARSTREAM_H
#include <Windows.h>

struct bufNode {
	unsigned char *buf;
	unsigned int bufSize;
};
typedef struct bufNode bufNode;

class CharStream {

public:
	void CopyStream(CharStream* copy);
	BOOL AreThereMore(void);
						CharStream(unsigned int vecSize = 4);
						~CharStream(void);
	
	void				PutChars(unsigned char *data, unsigned int size);
	BOOL				GetChar(unsigned char *c);
	void				UngetChar(void);
	void				MarkAsRead(void);
	void				RestoreToMark(void);
	BOOL				SkipTo (unsigned char c, unsigned char **data, unsigned int *size);
	BOOL				GetBuffer(unsigned char **buf, unsigned int *size);
	inline BOOL			CharExist()
						{
							return	
							((firstBuf >= 0) &&
							(	((firstBuf <= currBuf) &&
								(currBuf <= lastBuf) &&
								(firstBuf <= lastBuf)) ||
								
								((currBuf <= firstBuf) &&
								(currBuf <= lastBuf) &&
								(lastBuf < firstBuf)) ||
								
								((currBuf >= firstBuf) &&
								(currBuf >= lastBuf) &&
								(lastBuf < firstBuf))));
						}
	BOOL bufVecFull;


private:
	BOOL AllocBufVec(unsigned __int64 VecSize);
	BOOL mThereAreMore;
	bufNode *bufVec;
	unsigned int bufVecSize;
	int currBuf, markBuf, firstBuf, lastBuf;
	int currBufIndex, markBufIndex;

	inline void			reset(void)
						{
							bufVecFull = FALSE;
							firstBuf = lastBuf = -1;
							currBuf = markBuf = 0;
							currBufIndex = markBufIndex = 0;
							mThereAreMore = FALSE;
						};
};

#endif