//
//
// AuthOption
//
// Authenticates user with Kerberos 4
//

#ifndef AUTHOPTION__H
#define AUTHOPTION__H
#include <winsock.h>
#include "Negotiator.h"
extern "C" {
#include "KClient.h"
}
//#include "des.h"

class AuthOption : public Option {
public:
	AuthOption (CharStream *stream, TelnetEngine *engine, const char *);
	~AuthOption ();
	void NegotiateOption (unsigned char);
	void ExecOption(unsigned int Command);
private:
	char               	host[255];
//	des_cblock			challenge;
	unsigned char challenge[8];
	void NegotiateSend ();
	void NegotiateReply ();
	void NegotiateEncryption();
	void SendChallenge();
	void SendNoKerb4 ();
	BOOL KerbInit ();
	// Authentication option, commands, modifiers etc...
	enum{
		AUTHENTICATION 	= 37,
		ENCRYPT_OPT		= 38,
	    IS 	            =  0,
	    SEND 	        =  1,
	    REPLY   	    =  2,
	    NAME        	=  3,
	
	//       Authentication types
	    KERBEROS_V4   =   1,
	    KERBEROS_V5   =   2,
	    SPX           =   3,
	    RSA           =   6,
	    LOKI          =  10,
	
	//       Modifiers
	    AUTH_WHO_MASK  			=   1,
	    AUTH_CLIENT_TO_SERVER 	=   0,
	    AUTH_SERVER_TO_CLIENT  	=  	1,
	    AUTH_HOW_MASK        	=	2,
	    AUTH_HOW_ONE_WAY     	=   0,
	    AUTH_HOW_MUTUAL      	=   2,
	
	// Kerberos suboption commands
	    AUTH			=	0,
		REJECT 			=	1,
	 	ACCEPT			=	2,
		CHALLENGE		=	3,
	 	RESPONSE		=	4
	 };
};

#endif