

//
//
// YesNoOption
//
// Base class for simple Yes/No options such as ECHO
// Do NOT instantiate from this class!!
//



#ifndef YESNOOPTIONS__H
#define YESNOOPTIONS__H

#include "CharStream.h"
#include "TelnetCodes.h"
#include "Option.h"


class YesNoOption : public Option {
public:
	YesNoOption (CharStream* stream, TelnetEngine *engine, unsigned char option)
	: Option (stream, engine, option)
	{}
	void NegotiateOption (unsigned char);
};


//
//
// EchoOption
//
class EchoOption : public YesNoOption {
public:
	EchoOption (CharStream *stream, TelnetEngine *engine)
	: YesNoOption (stream, engine, ECHO)
	{}
};


//
//
// SgaOption
//
class SgaOption : public YesNoOption {
public:
	SgaOption (CharStream *stream, TelnetEngine *engine)
	: YesNoOption (stream, engine, SGA)
	{}
};

#endif // YESNOOPTIONS__H
