
#ifndef CRYPTOENGINE_H
#define CRYPTOENGINE_H


extern "C" {
#include "des.h"
#include "KClient.h"
}

typedef unsigned char	UChar,	*pUChar;

class CryptoEngine{
public:
	long lastLength;
	pUChar lastIn;
	int					mLastIVDecCount;
	des_cblock			mLastDecInitVec;

	void UndoDecrypt(pUChar out, long length);
	CryptoEngine(des_cblock* key);
	~CryptoEngine();
	void Encrypt(pUChar in, pUChar out, long length);
	void Decrypt(pUChar in, pUChar out, long length);
	void RandData(pUChar buff, int length);
	
private:
	void cryptation(pUChar in, pUChar out, long length, int encrypt);
	
	int					mIVEncCount;
	int					mIVDecCount;
	des_cblock			mSessionKey;
	des_cblock			mEncInitVec;			// The send ivec
	des_cblock			mDecInitVec;			// The recieved ivec
	des_key_schedule	mDesSchedule;
	friend class EncryptOption;
};

#endif // CRYPTOENGINE_H
