#include <Windows.h>
#include "CryptoEngine.h"

CryptoEngine::CryptoEngine(des_cblock* key)
{
	for (int i = 0; i < 8; i++)
		mSessionKey[i] = (*key)[i];
	des_set_key (&mSessionKey, mDesSchedule);
	mIVEncCount = mIVDecCount = 0;
	lastIn = 0;
}

CryptoEngine::~CryptoEngine()
{
	if(lastIn)
		delete[] lastIn;
}

void
CryptoEngine::Encrypt(pUChar in, pUChar out, long length) // pUChar = unsigned char*
{
	des_cfb64_encrypt(in, out,  length, mDesSchedule, &mEncInitVec, &mIVEncCount, DES_ENCRYPT);
}

void
CryptoEngine::Decrypt(pUChar in, pUChar out, long length)
{
	// Save variables for UndoDecrypt.
	if(lastIn)
	{
		delete[] lastIn;
		lastIn = 0;
	}
	lastIn = new UChar[length];
	CopyMemory(lastIn, in, length);
	lastLength = length;
	CopyMemory(mLastDecInitVec, mDecInitVec, sizeof(mDecInitVec));
	mLastIVDecCount	= mIVDecCount;

	// Ok, Let's go cipher jkGs!".-&eEq*
	des_cfb64_encrypt(in, out,  length, mDesSchedule, &mDecInitVec, &mIVDecCount, DES_DECRYPT);
}


void
CryptoEngine::RandData(pUChar in, int length)
{
	for(int i=0; i<length; i+=8)
	{
		des_cblock data;
		int size = sizeof(data);
		des_generate_random_block(&data);
		if(i+size > length) size = length - i;
		CopyMemory(in+i, data, size);
	}
}

void CryptoEngine::UndoDecrypt(pUChar out, long length)
{
	if(lastIn)
	{
		// Restore variables.
		CopyMemory(mDecInitVec,mLastDecInitVec, sizeof(mDecInitVec));
		mIVDecCount = mLastIVDecCount;

		// Redo decryption, to proper length.
		des_cfb64_encrypt(	lastIn, lastIn, lastLength - length,
							mDesSchedule, &mDecInitVec, &mIVDecCount, DES_DECRYPT);
	
		// Copy clear text.
		CopyMemory(out, lastIn+lastLength-length, length);

		delete[] lastIn;
		lastIn = 0;
	}
}
