/*
 * This software may now be redistributed outside the US.
 *
 */

/* 
  Copyright (C) 1989 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */

#include "krb_locl.h"

RCSID("$Id: in_tkt.c,v 1.15 1996/11/17 20:23:45 assar Exp $");

/*
 * in_tkt() is used to initialize the ticket store.  It creates the
 * file to contain the tickets and writes the given user's name "pname"
 * and instance "pinst" in the file.  in_tkt() returns KSUCCESS on
 * success, or KFAILURE if something goes wrong.
 */

int
in_tkt(char *pname, char *pinst)
{
    int tktfile;
    uid_t uid;
    struct stat buf;
    int count;
    char *file = TKT_FILE;
    int fd;
    int i;
    char charbuf[BUFSIZ];

    uid = getuid ();
    if (lstat(file,&buf) == 0) {
	if (buf.st_uid != uid || !(buf.st_mode & S_IFREG) ||
	    buf.st_mode & 077) {
	    krb_warning("Error initializing %s",file);
	    return(KFAILURE);
	}
	/* file already exists, and permissions appear ok, so nuke it */
	if ((fd = open(file, O_RDWR, 0)) < 0)
	    goto out; /* can't zero it, but we can still try truncating it */

	memset(charbuf, 0, sizeof(charbuf));

	for (i = 0; i < buf.st_size; i += sizeof(charbuf))
	    if (write(fd, charbuf, sizeof(charbuf)) != sizeof(charbuf)) {
		fsync(fd);
		close(fd);
		goto out;
	    }
	
	fsync(fd);
	close(fd);
    }
 out:
    if ((tktfile = open(file, O_WRONLY|O_CREAT|O_TRUNC, 0600)) < 0) {
	krb_warning("Error initializing %s",TKT_FILE);
        return(KFAILURE);
    }
    if (lstat(file,&buf) < 0) {
	krb_warning("Error initializing %s",TKT_FILE);
        return(KFAILURE);
    }
    
    if (buf.st_uid != uid || !(buf.st_mode & S_IFREG) ||
        buf.st_mode & 077) {
	krb_warning("Error initializing %s",TKT_FILE);
        return(KFAILURE);
    }

    count = strlen(pname)+1;
    if (write(tktfile,pname,count) != count) {
        close(tktfile);
        return(KFAILURE);
    }
    count = strlen(pinst)+1;
    if (write(tktfile,pinst,count) != count) {
        close(tktfile);
        return(KFAILURE);
    }
    close(tktfile);
    return(KSUCCESS);
}
