/* 
   Copyright (C) 1989 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

   WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
   distribute this software and its documentation for any purpose and
   without fee is hereby granted, provided that the above copyright
   notice appear in all copies and that both that copyright notice and
   this permission notice appear in supporting documentation, and that
   the name of M.I.T. not be used in advertising or publicity pertaining
   to distribution of the software without specific, written prior
   permission.  M.I.T. makes no representations about the suitability of
   this software for any purpose.  It is provided "as is" without express
   or implied warranty.
   
   */

#include "krb_locl.h"

RCSID("$Id: get_phost.c,v 1.12 1996/11/19 23:09:01 assar Exp $");

/*
 * This routine takes an alias for a host name and returns the first
 * field, lower case, of its domain name.  For example, if "menel" is
 * an alias for host officially named "menelaus" (in /etc/hosts), for
 * the host whose official name is "MENELAUS.MIT.EDU", the name "menelaus"
 * is returned.
 */

char *
krb_get_phost(const char *alias)
{
  static char phost[MaxHostNameLen+1];
  char *p;
    
  krb_name_to_name(alias, phost);
  p = phost;

  while (p && *p && *p != '.') {
    *p = tolower(*p);
    p++;
  }
  if (*p == '.')
    *p = '\0';
  return phost;
}
