/*
 * Copyright (c) 1995, 1996 Kungliga Tekniska Hgskolan (Royal Institute
 * of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* dllmain.c - main function to krb4.dll
 * Author:	J Karlsson <d93-jka@nada.kth.se>
 * Date:	June 1996
 */

#include "ticket_memory.h"
#include <Windows.h>

void msg(char *text, int error)
{
	char error_no[10];
	char error_text[] = "\nAn error of type: ";
	char *msg_text = malloc(sizeof(char)*(strlen(text)+
										strlen(error_text)+
										strlen(error_no)));
	itoa(error, error_no, 10);
	*msg_text = 0;
	strcat(msg_text,text);
	strcat(msg_text,error_text);
	strcat(msg_text,error_no);
	MessageBox(GetActiveWindow(), msg_text, "kerberos message", MB_OK|MB_APPLMODAL);
	free(msg_text);
}

BOOL   WINAPI   DllMain (HANDLE hInst, 
                        ULONG reason,
                        LPVOID lpReserved)
{
	WORD wVersionRequested; 
	WSADATA wsaData; 
	PROCESS_INFORMATION p;	
	int err; 
	switch(reason){
	case DLL_PROCESS_ATTACH:
		wVersionRequested = MAKEWORD(1, 1); 
		err = WSAStartup(wVersionRequested, &wsaData); 
		if (err != 0) 
		{
			/* Tell the user that we couldn't find a useable */ 
			/* winsock.dll.     */ 
			msg("Cannot find winsock.dll", err);
			return FALSE;
		}
		if(newTktMem(0) != KSUCCESS)
		{
			/* Tell the user that we couldn't alloc shared memory. */ 
			msg("Cannot allocate shared ticket memory", GetLastError());
			return FALSE;
		}
		if(GetLastError() != ERROR_ALREADY_EXISTS)
		{
			STARTUPINFO s = 
			{
				sizeof(s),
				0,
				0,
				0,
				0,0,
				0,0,
				0,0,
				0,
				0,
				0,
				0,0,
				0,0,0};

			s.dwFlags = STARTF_USESHOWWINDOW;
			s.wShowWindow = SW_HIDE;
			if(!CreateProcess(0,"krbmanager",
							0,0,FALSE,0,0,
							0,&s, &p))
			{
				msg("Unable to create kerberos manager process.", GetLastError());
				return FALSE;
			}
		}

		break;
	case DLL_PROCESS_DETACH:
		freeTktMem(0);
		WSACleanup();
	}

  	return TRUE;
}
