/*
 * Copyright (c) 1995, 1996 Kungliga Tekniska Hgskolan (Royal Institute
 * of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* passwd_dlg.c - Dialog boxes for Windows95/NT
 * Author:	Jrgen Karlsson - d93-jka@nada.kth.se
 * Date:	June 1996
 */

#ifdef WIN32	/* Visual C++ 4.0 (Windows95/NT) */
#include <Windows.h>
#include "passwd_dlg.h"
#include "Resource.h"
#define passwdBufSZ 64
#define usr_nameSZ 64

extern char *guser;
char user_name[usr_nameSZ];
char passwd[passwdBufSZ];

BOOL CALLBACK pwd_dialog_proc(HWND  hwndDlg, UINT  uMsg, WPARAM  wParam, LPARAM  lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG:
			SetDlgItemText(hwndDlg, IDC_EDIT1, user_name);
			return TRUE;
			break;

		case WM_COMMAND: 
			switch(wParam)
			{
				case IDOK:
					if(!GetDlgItemText(hwndDlg,IDC_EDIT1, user_name ,usr_nameSZ))
						EndDialog(hwndDlg, IDCANCEL);
					if(!GetDlgItemText(hwndDlg,IDC_EDIT2, passwd ,passwdBufSZ))
						EndDialog(hwndDlg, IDCANCEL);
				case IDCANCEL:
					EndDialog(hwndDlg, wParam);
				return TRUE;
			}
			break;
	}
	return FALSE;
}


/* return 0 if ok, 1 otherwise */
int pwd_dialog(char *user, char *password)
{
	int i;
	HWND wnd = GetActiveWindow();
	HANDLE hInst = GetModuleHandle("kclient");
	strcpy(user_name, user);
	switch(DialogBox(hInst,MAKEINTRESOURCE(IDD_DIALOG1),wnd,pwd_dialog_proc))
	{
	case IDOK:
		strcpy(user, user_name);
		strcpy(password,passwd);
		for(i=0; passwd[i] != '\0'; i++) passwd[i] = '\0';
		return 0;
	case IDCANCEL:
	default:
		for(i=0; passwd[i] != '\0'; i++) passwd[i] = '\0';
		return 1;
	}
}



#endif /* WIN32 */
