/*
 *
 * Copyright 1988 by the Massachusetts Institute of Technology. 
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>. 
 *
 * Get a ticket-granting-ticket given a service key file (srvtab)
 * The lifetime is the shortest allowed [1 five-minute interval]
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include <krb.h>
#include <conf.h>

const char rcsid[] =
    "$Id: ksrvtgt.c,v 1.8 1996/11/17 21:08:34 assar Exp $";

main(argc,argv)
    int argc;
    char **argv;
{
    char realm[REALM_SZ + 1];
    int code;
    char srvtab[MaxPathLen + 1];

    memset(realm, 0, sizeof(realm));
    memset(srvtab, 0, sizeof(srvtab));

    if (argc < 3 || argc > 5) {
	fprintf(stderr, "Usage: %s name instance [[realm] srvtab]\n",
		argv[0]);
	exit(1);
    }
    
    if (argc == 4)
	strncpy(srvtab, argv[3], sizeof(srvtab) -1);
    
    if (argc == 5) {
	strncpy(realm, argv[3], sizeof(realm) - 1);
	strncpy(srvtab, argv[4], sizeof(srvtab) -1);
    }

    if (srvtab[0] == 0)
	strcpy(srvtab, KEYFILE);

    if (realm[0] == 0)
	if (krb_get_lrealm(realm, 1) != KSUCCESS)
	    strcpy(realm, KRB_REALM);

    code = krb_get_svc_in_tkt(argv[1], argv[2], realm,
			      KRB_TICKET_GRANTING_TICKET,
			      realm, 1, srvtab);
    if (code)
	fprintf(stderr, "%s\n", krb_get_err_text(code));
    exit(code);
}
