/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#include <popper.h>
RCSID("$Id: pop_xmit.c,v 1.15 1996/11/17 20:23:21 assar Exp $");

/*
 *  xmit:   POP XTND function to receive a message from 
 *          a client and send it in the mail
 */

int
pop_xmit (POP *p)
{
    FILE                *   tmp;                    /*  File descriptor for 
                                                        temporary file */
    char                    buffer[MAXLINELEN];     /*  Read buffer */
    char                    temp_xmit[MAXDROPLEN];  /*  Name of the temporary 
                                                        filedrop */
    int		            stat;
    int                     id, pid;

    /*  Create a temporary file into which to copy the user's message */
    mktemp(strcpy(temp_xmit,POP_TMPXMIT));
#ifdef DEBUG
    if(p->debug)
        pop_log(p, POP_DEBUG,
            "Creating temporary file for sending a mail message \"%s\"\n",
                temp_xmit);
#endif /* DEBUG */
    if ((tmp = fopen(temp_xmit, "w+")) == NULL)
        return (pop_msg(p, POP_FAILURE,
			"Unable to create temporary message file \"%s\": %s",
			temp_xmit,
			strerror(errno)));

    /*  Tell the client to start sending the message */
    pop_msg(p,POP_SUCCESS,"Start sending the message.");

    /*  Receive the message */
#ifdef DEBUG
    if(p->debug)pop_log(p,POP_DEBUG,"Receiving mail message");
#endif /* DEBUG */
    while (fgets(buffer,MAXLINELEN,p->input)){
        /*  Look for initial period */
#ifdef DEBUG
        if(p->debug)pop_log(p,POP_DEBUG,"Receiving: \"%s\"",buffer);
#endif /* DEBUG */
	if (strcmp(buffer,".\r\n") == 0) break;
        fputs (buffer,tmp);
    }
    fclose (tmp);

#ifdef DEBUG
    if(p->debug)pop_log(p,POP_DEBUG,"Forking for \"%s\"",MAIL_COMMAND);
#endif /* DEBUG */
    /*  Send the message */
    switch (pid = fork()) {
        case 0:
            fclose (p->input);
            fclose (p->output);       
            close(0);
            if (open(temp_xmit,O_RDONLY,0) < 0)
		_exit(1);
            execl (MAIL_COMMAND, "send-mail", "-t", "-oem", (char *)NULL);
            _exit(1);
        case -1:
#ifdef DEBUG
            if (!p->debug) unlink (temp_xmit);
#endif /* DEBUG */
            return (pop_msg(p,POP_FAILURE,
                "Unable to execute \"%s\"",MAIL_COMMAND));
        default:
            while((id = wait(&stat)) >=0 && id != pid)
		;
            if (!p->debug) 
		unlink (temp_xmit);
            if (WEXITSTATUS(stat) != 0)
                return pop_msg(p,POP_FAILURE,"Unable to send message");
            return pop_msg (p,POP_SUCCESS,"Message sent successfully");
    }

}
