/*
 * Copyright (c) 1995, 1996 Kungliga Tekniska Hgskolan (Royal Institute
 * of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "config.h"

RCSID("$Id: kstring2key.c,v 1.8 1996/10/27 23:51:09 assar Exp $");

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <des.h>
#include <krb.h>

#define VERIFY 0

static char *program;

static void
usage(void)
{
    fprintf(stderr, "%s: Usage: %s [-c AFS cellname] [ password ]\n",
	    program, program);
    exit(1);
}

int
main(int argc, char **argv)
{
    des_cblock key;
    char buf[1024];
    char *cellname = 0;

    program = argv[0];
    if (argc >= 3 && argv[1][0] == '-' && argv[1][1] == 'c')
	{
	    cellname = argv[2];
	    argv += 2;
	    argc -= 2;
	}
    if (argc >= 2 && argv[1][0] == '-' && argv[1][1] == 'h')
	usage();

    switch (argc) {
    case 1:
	if (des_read_pw_string(buf, sizeof(buf)-1, "password: ", VERIFY))
	    {
		fprintf(stderr, "Error reading password.\n");
		exit(1);
	    }
	break;
    case 2:
	strcpy(buf, argv[1]);
	break;
    default:
	usage();
	break;
    }

    if (cellname != 0)
	afs_string_to_key(buf, cellname, &key);
    else
	des_string_to_key(buf, &key);

    {
	int j;
	unsigned char *tkey = (unsigned char *) &key;
	for(j = 0; j < 8; j++)
	    if(tkey[j] != '\\' && isalpha(tkey[j]) != 0)
		printf("%c", tkey[j]);
	    else
		printf("\\%03o",(unsigned char)tkey[j]);
	printf("\n");
    }
    exit(0);
}
