/*
 * This is a hack to resolve the reference to _et_list when making a
 * shared library under Psoriasis and possibly other systems.
 */

#include "krb_locl.h"

RCSID("$Id: et_list.c,v 1.2 1996/08/11 17:57:36 bg Exp $");

struct et_list {
    struct et_list *next;
    const struct error_table *table;
};

#if defined(__GNUC__)
struct et_list * _et_list __attribute__ ((weak)) = 0;
#else /* !__GNUC__ */

/*
 * Try this if you get link problems!
 * ELF always(?) knows about weak symbols.
 */
#if (SunOS == 5)
static
void *
not_used()
{
  asm(".weak   _et_list");
  return (void *)&not_used;
}
#endif
struct et_list * _et_list = 0;

#endif /* !__GNUC__ */
