#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <errno.h>
#include <string.h>

RCSID("$Id: strerror.c,v 1.2 1996/05/10 23:03:48 assar Exp $");

extern int sys_nerr;
extern char *sys_errlist[];

char*
strerror(int eno)
{
    static char emsg[1024];

    if(eno < 0 || eno >= sys_nerr)
	sprintf(emsg, "Error %d occurred.", eno);
    else
	strcpy(emsg, sys_errlist[eno]);

    return emsg;
}
