#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
#ifdef HAVE_SYS_IOCCOM_H
#include <sys/ioccom.h>
#endif
#include <stdarg.h>
#include <krb.h>
#include <kafs.h>
#include <pwd.h>

RCSID("$Id: aklog.c,v 1.6 1996/05/13 01:45:34 joda Exp $");

static
char *
cell_of_file(char *path)
{
  static char cell[64];
  struct ViceIoctl v;
  v.in = NULL;
  v.in_size = 0;
  v.out = cell;
  v.out_size = sizeof(cell);
  if(k_pioctl(path, VIOC_FILE_CELL_NAME, &v, 1)<0)
    return NULL;
  return cell;
}

static
char *
expand_cell_name(char *cell)
{
  FILE *F;
  static char buf[128];
  char *p;

  F = fopen("/usr/vice/etc/CellServDB", "r");
  if(F == NULL)
    return cell;
  do{
    fgets(buf, 128, F);
    if(buf[0] == '>'){
      for(p=buf; *p && *p != ' ' && *p != '\t'; p++);
      *p=0;
      if(strstr(buf, cell)){
	fclose(F);
	return buf + 1;
      }
    }
    buf[0] = 0;
  }while(!feof(F));
  fclose(F);
  return cell;
}

int debug = 0;

static
void
DEBUG(const char *fmt, ...)
{
  va_list ap;
  if(debug){
    va_start(ap, fmt);
    fprintf(stderr, "aklog: ");
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
    va_end(ap);
  }
}

int
main(int argc, char **argv)
{
  int i;
  int do_aklog = -1;
  char *cell = NULL;
  char *realm = NULL;
  
  if(!k_hasafs())
    exit(1);

  for(i=1; i < argc; i++){
    if(!strncmp(argv[i], "-c", 2)){
      cell = expand_cell_name(argv[++i]);
      do_aklog = 1;

    }else if(!strncmp(argv[i], "-k", 2)){
      realm = argv[++i];

    }else if(!strncmp(argv[i], "-p", 2)){
      cell = cell_of_file(argv[++i]);
      do_aklog = 1;

    }else if(!strncmp(argv[i], "-unlog", 6)){
      exit(k_unlog());

    }else if(!strncmp(argv[i], "-hosts", 6)){
      fprintf(stderr, "Argument -hosts is not implemented.\n");

    }else if(!strncmp(argv[i], "-zsubs", 6)){
      fprintf(stderr, "Argument -zsubs is not implemented.\n");

    }else if(!strncmp(argv[i], "-noprdb", 6)){
      fprintf(stderr, "Argument -noprdb is not implemented.\n");

    }else if(!strncmp(argv[i], "-d", 6)){
      debug = 1;

    }else{
      if(!strcmp(argv[i], ".") ||
	 !strcmp(argv[i], "..") ||
	 strchr(argv[i], '/')){
	DEBUG("I guess that \"%s\" is a filename.", argv[i]);
	cell = cell_of_file(argv[i]);
	if(cell)
	  DEBUG("The file \"%s\" lives in cell \"%s\".", argv[i], cell);
	else
	  DEBUG("No cell found for file \"%s\".", argv[i]);
      }else{
	cell = expand_cell_name(argv[i]);
	DEBUG("I guess that %s is cell %s.", argv[i], cell);
      }
      do_aklog = 1;
    }
    if(do_aklog == 1){
      do_aklog = 0;
      if(k_afsklog(cell, realm)){
	DEBUG("Failed getting tokens for cell %s in realm %s.", 
	      cell?cell:"(local cell)", realm?realm:"(local realm)");
	exit(1);
      }
    }
  }
  if(do_aklog == -1 && k_afsklog(0, realm)){
    DEBUG("Failed getting tokens for cell %s in realm %s.", 
	  cell?cell:"(local cell)", realm?realm:"(local realm)");
    exit(1);
  }
  return 0;
}
