#include "krb_locl.h"

RCSID("$Id: create_death_packet.c,v 1.4 1996/05/15 03:39:36 joda Exp $");

/*
 * This routine creates a packet to type AUTH_MSG_DIE which is sent to
 * the Kerberos server to make it shut down.  It is used only in the
 * development environment.
 *
 * It takes a string "a_name" which is sent in the packet.  A pointer
 * to the packet is returned.
 *
 * The format of the killer packet is:
 *
 * type			variable		data
 *			or constant
 * ----			-----------		----
 *
 * unsigned char	KRB_PROT_VERSION	protocol version number
 * 
 * unsigned char	AUTH_MSG_DIE		message type
 * 
 * [least significant	HOST_BYTE_ORDER		byte order of sender
 *  bit of above field]
 * 
 * string		a_name			presumably, name of
 * 						principal sending killer
 * 						packet
 */

#ifdef DEBUG
KTEXT
krb_create_death_packet(char *a_name)
{
    static KTEXT_ST pkt_st;
    KTEXT pkt = &pkt_st;

    unsigned char *p = pkt->dat;
    
    p += put_int(KRB_PROT_VERSION, p, 1);
    p += put_int(AUTH_MSG_DIE, p, 1);
    
    p += put_string(a_name, p);
    pkt->length = p - pkt->dat;
    return pkt;
}
#endif /* DEBUG */
