#include "krb_locl.h"

RCSID("$Id: create_auth_reply.c,v 1.6 1996/05/31 20:59:59 assar Exp $");

/*
 * This routine is called by the Kerberos authentication server
 * to create a reply to an authentication request.  The routine
 * takes the user's name, instance, and realm, the client's
 * timestamp, the number of tickets, the user's key version
 * number and the ciphertext containing the tickets themselves.
 * It constructs a packet and returns a pointer to it.
 *
 * Notes: The packet returned by this routine is static.  Thus, if you
 * intend to keep the result beyond the next call to this routine, you
 * must copy it elsewhere.
 *
 * The packet is built in the following format:
 * 
 * 			variable
 * type			or constant	   data
 * ----			-----------	   ----
 * 
 * unsigned char	KRB_PROT_VERSION   protocol version number
 * 
 * unsigned char	AUTH_MSG_KDC_REPLY protocol message type
 * 
 * [least significant	HOST_BYTE_ORDER	   sender's (server's) byte
 *  bit of above field]			   order
 * 
 * string		pname		   principal's name
 * 
 * string		pinst		   principal's instance
 * 
 * string		prealm		   principal's realm
 * 
 * unsigned long	time_ws		   client's timestamp
 * 
 * unsigned char	n		   number of tickets
 * 
 * unsigned long	x_date		   expiration date
 * 
 * unsigned char	kvno		   master key version
 * 
 * short		w_1		   cipher length
 * 
 * ---			cipher->dat	   cipher data
 */

/* Principal's name */
/* Principal's instance */
/* Principal's authentication domain */
/* Workstation time */
/* Number of tickets */
/* Principal's expiration date */
/* Principal's key version number */
/* Cipher text with tickets and session keys */

KTEXT
create_auth_reply(char *pname, char *pinst, char *prealm, 
		  int32_t time_ws, int n, u_int32_t x_date, 
		  int kvno, KTEXT cipher)
{
    static  KTEXT_ST pkt_st;
    KTEXT pkt = &pkt_st;
    
    unsigned char *p = pkt->dat;

    p += put_int(KRB_PROT_VERSION, p, 1);
    p += put_int(AUTH_MSG_KDC_REPLY, p, 1);

    if(n != 0){
	/* barf on old code */
	fprintf(stderr, 
		"create_auth_reply: don't give me no krb3 crap! (n == %d)\n", 
		n);
	return NULL;
    }


    p += put_nir(pname, pinst, prealm, p);

    p += put_int(time_ws, p, 4);
    
    p += put_int(n, p, 1);
    
    p += put_int(x_date, p, 4);
    
    p += put_int(kvno, p, 1);
    
    p += put_int(cipher->length, p, 2);
    
    memcpy(p, cipher->dat, cipher->length);
    p += cipher->length;

    pkt->length = p - pkt->dat;

    return pkt;
}
