#include "krb_locl.h"

RCSID("$Id: k_strerror.c,v 1.5 1996/03/25 13:09:33 bg Exp $");

const char *
k_strerror(int errnum)
{
#ifdef HAVE_STRERROR
  return (const char *) strerror(errnum);
#else
  extern int sys_nerr;
  extern char *sys_errlist[];
  static char ebuf[40];		/* 64-bit number + slop */

  if ((unsigned int)errnum < sys_nerr)
    return(sys_errlist[errnum]);
  (void)sprintf(ebuf, "Unknown error: %d", errnum);
  return(ebuf);
#endif /* !HAVE_STRERROR */
}

