#include "krb_locl.h"

RCSID("$Id: k_name_to_name.c,v 1.5 1996/04/29 09:20:12 bg Exp $");

/* convert host to a more fully qualified domain name, returns 0 if
 * phost is the same as host, 1 otherwise. phost should be at least
 * MAXHOSTNAMELEN+1 bytes long
 */

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

int
k_name_to_name(char *host, char *phost)
{
    struct hostent *hp;
    struct in_addr adr;
    
    adr.s_addr = inet_addr(host);
    hp = gethostbyname(host);
    if (hp == NULL && adr.s_addr != INADDR_NONE)
	hp = gethostbyaddr((char *)&adr, sizeof(adr), AF_INET);
    if (hp == NULL)
	strcpy(phost, host);
    else
	strcpy(phost, hp->h_name);

    if (strcmp(phost, host) == 0)
	return 0;
    else
	return 1;
}
/*
 * Local Variables:
 * c-basic-offset: 4 
 * End:
 */
