#include "bsd_locl.h"

#ifndef HAVE_FORKPTY

RCSID("$Id: forkpty.c,v 1.37 1996/03/28 11:10:28 bg Exp $");

/* Systems where rlogind has been tested */
#if 1 || (defined(sun) && !defined(__svr4__)) || defined(__hpux) || defined(__linux) || defined(__sgi__) || defined(__NetBSD__) || defined(_AIX)
static int forkpty_ok = 1;
#else
static int forkpty_ok = 0;
#endif

#include <termios.h>

#if defined(HAVE_SYS_IOCTL_H) && SunOS != 4
#include <sys/ioctl.h>
#endif

#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif

#ifndef HAVE_PTSNAME
static char *ptsname(int fd)
{
#ifdef HAVE_TTYNAME
  return ttyname(fd);
#else
  return NULL;
#endif
}
#endif

#ifndef HAVE_GRANTPT
#define grantpt(fdm) (0)
#endif

#ifndef HAVE_UNLOCKPT
#define unlockpt(fdm) (0)
#endif

#ifndef HAVE_VHANGUP
#define vhangup() (0)
#endif

#ifndef HAVE_REVOKE
static
void
revoke(char *line)
{
    int slave;
    RETSIGTYPE (*ofun)();

    if ( (slave = open(line, O_RDWR)) < 0)
	return;
    
    ofun = signal(SIGHUP, SIG_IGN);
    vhangup();
    signal(SIGHUP, ofun);
    /*
     * Some systems (atleast SunOS4) want to have the slave end open
     * at all times to prevent a race in the child. Login will close
     * it so it should really not be a problem. However for the
     * paranoid we use the close on exec flag so it will only be open
     * in the parent. Additionally since this will be the controlling
     * tty of rlogind the final vhangup() in rlogind should hangup all
     * processes. A working revoke would of course have been prefered
     * though (sigh).
     */
    fcntl(slave, F_SETFD, 1);
    /* close(slave); */
}
#endif

static int
ptym_open(char *pts_name, int *streams_pty)
{
    int	fdm;
    char *ptr1, *ptr2;

    /* Try clone device master ptys */
    char *clone[] = { "/dev/ptc", "/dev/ptmx", "/dev/ptm", 
		      "/dev/ptym/clone", 0 };

    char **q;
    *streams_pty = 1;
    for(q=clone; *q; q++){
      fdm=open(*q, O_RDWR);
      if(fdm >= 0)
	break;
    }
    if (fdm >= 0) {
        if ( (ptr1 = ptsname(fdm)) != NULL) /* Get slave's name */
	    strcpy(pts_name, ptr1); /* Return name of slave */  
	else {
	    close(fdm);
	    return(-4);
	}
	if (grantpt(fdm) < 0) {	/* Grant access to slave */
	    close(fdm);
	    return(-2);
	}
	if (unlockpt(fdm) < 0) {	/* Clear slave's lock flag */
	    close(fdm);
	    return(-3);
	}
	return(fdm);			/* return fd of master */
    }
    
    /* HP-UX has a different naming of their pty's */
#ifdef __hpux
    strcpy(pts_name, "/dev/ptym/ptyXY");
#define pts_name_X pts_name[13]
#define pts_name_Y pts_name[14]
#else
    strcpy(pts_name, "/dev/ptyXY");
#define pts_name_X pts_name[8]
#define pts_name_Y pts_name[9]
#endif

    /* Try BSD style master ptys */
    *streams_pty = 0;
    /* array index: 0123456789 (for references in following code) */
    for (ptr1 = "pqrstuvwxyzPQRST"; *ptr1 != 0; ptr1++)
	{
	    pts_name_X = *ptr1;
	    for (ptr2 = "0123456789abcdefghijklmnopqrstuv";
		 *ptr2 != 0;
		 ptr2++)
		{
		    pts_name_Y = *ptr2;
		    /* Try to open master */
		    if ( (fdm = open(pts_name, O_RDWR)) < 0)
			continue; /* Try next pty device */
			    
#if SunOS == 4
		    /* Avoid a bug in SunOS4 ttydriver */
		    if (fdm > 0) {
			int pgrp;
			if ((ioctl(fdm, TIOCGPGRP, &pgrp) == -1)
			    && (errno == EIO))
			    /* All fine */;
			else
			    {
				close(fdm);
				continue;
			    }
		    }
#endif
#ifdef __hpux
		    sprintf(pts_name, "/dev/pty/tty%c%c", *ptr1, *ptr2);
#else
		    pts_name[5] = 't'; /* Change "pty" to "tty" */
#endif
		    return fdm;	/* All done! */
		}
	}
    /* We failed to find BSD style pty */
    errno = ENOENT;
    return -1;
}

static int
maybe_push_modules(int fd, char **modules)
{
#ifdef I_PUSH
  char **p;
  int err;

  for(p=modules; *p; p++){
    err=ioctl(fd, I_FIND, *p);
    if(err == 1)
      break;
    if(err < 0 && errno != EINVAL)
      return -17;
    /* module not pushed or does not exist */
  }
  /* p points to null or to an already pushed module, now push all
     modules before this one */

  for(p--; p >= modules; p--){
    err = ioctl(fd, I_PUSH, *p);
    if(err < 0 && errno != EINVAL)
      return -17;
  }
#endif
  return 0;
}

static int
ptys_open(int fdm, char *pts_name, int streams_pty)
{
    int fds;

    if (streams_pty) {
	/* Streams style slave ptys */
	if ( (fds = open(pts_name, O_RDWR)) < 0) {
	    close(fdm);
	    return(-5);
	}

	{
	  char *ttymodules[] = { "ttcompat", "ldterm", "ptem", NULL };
	  char *ptymodules[] = { "pckt", NULL };
	  
	  if(maybe_push_modules(fds, ttymodules)<0){
	    close(fdm);
	    close(fds);
	    return -6;
	  }
	  if(maybe_push_modules(fdm, ptymodules)<0){
	    close(fdm);
	    close(fds);
	    return -7;
	  }
	}
    } else {
        /* BSD style slave ptys */
	struct group *grptr;
	int gid;
	if ( (grptr = getgrnam("tty")) != NULL)
	    gid = grptr->gr_gid;
	else
	    gid = -1;	/* group tty is not in the group file */

	/* Grant access to slave */
	chown(pts_name, getuid(), gid);
	chmod(pts_name, S_IRUSR | S_IWUSR | S_IWGRP);

	if ( (fds = open(pts_name, O_RDWR)) < 0) {
	    close(fdm);
	    return(-1);
	}
    }
    return(fds);
}

int
forkpty(int *ptrfdm, char *slave_name, struct termios *slave_termios, struct winsize *slave_winsize)
{
    int		fdm, fds, streams_pty;
    pid_t	pid;
    char	pts_name[20];

    if (!forkpty_ok)
        fatal(0, "Protocol not yet supported, use telnet", 0);

    if ( (fdm = ptym_open(pts_name, &streams_pty)) < 0)
	return -1;

    if (slave_name != NULL)
	strcpy(slave_name, pts_name);	/* Return name of slave */

    pid = fork();
    if (pid < 0)
	return(-1);
    else if (pid == 0) {		/* Child */
	if (setsid() < 0)
	    fatal(0, "setsid() failure", errno);

        revoke(slave_name);

#if defined(NeXT) || defined(ultrix)
	/* The NeXT is severely broken, this makes things slightly
	 * better but we still doesn't get a working pty. If there
	 * where a TIOCSCTTY we could perhaps fix things but... The
	 * same problem also exists in xterm! */
	if (setpgrp(0, 0) < 0)
	    fatal(0, "NeXT kludge failed setpgrp", errno);
#endif

	/* SVR4 acquires controlling terminal on open() */
	if ( (fds = ptys_open(fdm, pts_name, streams_pty)) < 0)
	    return -1;
	close(fdm);		/* All done with master in child */
	
#if	defined(TIOCSCTTY) && !defined(CIBAUD) && !defined(__hpux)
	/* 44BSD way to acquire controlling terminal */
	/* !CIBAUD to avoid doing this under SunOS */
	if (ioctl(fds, TIOCSCTTY, (char *) 0) < 0)
	    return -1;
#endif
#if defined(NeXT)
	{
	    int t = open("/dev/tty", O_RDWR);
	    if (t < 0)
	        fatal(0, "Failed to open /dev/tty", errno);
	    close(fds);
	    fds = t;
	}
#endif
	/* Set slave's termios and window size */
	if (slave_termios != NULL) {
	    if (tcsetattr(fds, TCSANOW, slave_termios) < 0)
		return -1;
	}
	if (slave_winsize != NULL) {
	    if (ioctl(fds, TIOCSWINSZ, slave_winsize) < 0)
		return -1;
	}
	/* slave becomes stdin/stdout/stderr of child */
	if (dup2(fds, STDIN_FILENO) != STDIN_FILENO)
	    return -1;
	if (dup2(fds, STDOUT_FILENO) != STDOUT_FILENO)
	    return -1;
	if (dup2(fds, STDERR_FILENO) != STDERR_FILENO)
	    return -1;
	if (fds > STDERR_FILENO)
	    close(fds);
	return(0);		/* child returns 0 just like fork() */
    }
    else {			/* Parent */
	*ptrfdm = fdm;	/* Return fd of master */
	return(pid);	/* Parent returns pid of child */
    }
}
#endif /* HAVE_FORKPTY */
