#include "kauth.h"

RCSID("$Header: /src/packages/kth-krb/SourceRepository/krb4/appl/kauth/marshall.c,v 1.2 1996/03/24 06:57:03 assar Exp $");

unsigned
pack_args (char *buf, char *name, char *inst, char *realm, int lifetime,
	   char *locuser, char *tktfile)
{
     char *p;

     p = buf;
     strcpy (p, name);
     p += strlen (name) + 1;
     strcpy (p, inst);
     p += strlen (inst) + 1;
     strcpy (p, realm);
     p += strlen (realm) + 1;
     *p++ = (unsigned char)lifetime;
     strcpy(p, locuser);
     p += strlen (locuser) + 1;
     strcpy(p, tktfile);
     p += strlen(tktfile) + 1;
     return p - buf;
}

int
unpack_args (char *buf, char *name, char *inst, char *realm, int *lifetime,
	     char *locuser, char *tktfile)
{
     int len;

     len = strlen(buf);
     if (len > SNAME_SZ)
	  return -1;
     strncpy(name, buf, len + 1);
     buf += len + 1;
     len = strlen (buf);
     if (len > INST_SZ)
	  return -1;
     strncpy (inst, buf, len + 1);
     buf += len + 1;
     len = strlen (buf);
     if (len > REALM_SZ)
	  return -1;
     strncpy (realm, buf, len + 1);
     buf += len + 1;
     *lifetime = (unsigned char)*buf++;
     len = strlen(buf);
     if (len > SNAME_SZ)
	  return -1;
     strncpy (locuser, buf, len + 1);
     buf += len + 1;
     len = strlen(buf);
     if (len > MaxPathLen)
	  return -1;
     strncpy (tktfile, buf, len + 1);
     buf += len + 1;
     return 0;
}
