#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <kafs.h>
#include <pwd.h>

RCSID("$Header: /src/packages/kth-krb/SourceRepository/krb4/appl/afsutil/pagsh.c,v 1.3 1996/03/22 16:30:02 bg Exp $");

#ifndef HAVE_RANDOM
#define srandom(x) srand(x)
#define random() srand()
#endif

#ifndef HAVE_STRDUP
char *
strdup(const char *old)
{
	char *t = malloc(strlen(old)+1);
	if (t != 0)
		strcpy(t, old);
	return t;
}
#endif

int
main(int argc, char **argv)
{
  int f;
  char tf[1024];
  char *p;

  char *path;
  char *args[128];
  int i;

  if(!k_hasafs())
    exit(1);
  
  srandom(time(0)*getpid()*getuid());
  
  do{
    sprintf(tf, "/tmp/tkt%d_%d", getuid(), random());
    f = open(tf, O_CREAT|O_EXCL|O_RDWR);
  }while(f < 0);
  close(f);
  unlink(tf);
  setenv("KRBTKFILE", tf);

  i = 0;
  if(argc > 1){
    char **q=argv+1;
    if(!strcmp(*q, "-c")) q++;
    path = strdup(*q++);
    p=strrchr(path,'/');
    if(p)
      args[i++] = strdup(p+1);
    else
      args[i++] = strdup(path);
    while(*q){
      args[i++] = strdup(*q);
      q++;
    }
  }else{
    struct passwd *pw = getpwuid(geteuid());
    path = strdup(pw->pw_shell);
    p=strrchr(path, '/');
    if(p)
      args[i++] = strdup(p+1);
    else
      args[i++] = strdup(path);
  }
  k_setpag();
  args[i]=0;
  execvp(path, args);
  perror("execvp");
  exit(1);
}
